/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.store;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.cocoon.framework.Configurable;
import org.apache.cocoon.framework.Configurations;
import org.apache.cocoon.framework.InitializationException;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.store.Store;

public class MemoryStore
implements Store,
Configurable,
Status {
    private Runtime jvm = Runtime.getRuntime();
    private int memory;
    private Hashtable hashtable = new Hashtable(101, 0.75f);
    private static final long factor = 2L;

    public synchronized boolean containsKey(Object object) {
        return this.hashtable.containsKey(object);
    }

    private long evaluate(Container container, long l) {
        return 2L * (long)container.count + 0x3FFFFFFFFFFFFFFFL - (l - container.time);
    }

    public synchronized Object get(Object object) {
        Object v = this.hashtable.get(object);
        if (v != null) {
            Container container = (Container)v;
            container.time = System.currentTimeMillis();
            ++container.count;
            return container.object;
        }
        return null;
    }

    public String getStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Memory Object Storage System<br>");
        Enumeration enumeration = this.list();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("<li>");
            stringBuffer.append(enumeration.nextElement());
            stringBuffer.append("</li>");
        }
        return stringBuffer.toString();
    }

    private Object getWorst() {
        long l = System.currentTimeMillis();
        long l2 = Long.MAX_VALUE;
        Object var5_3 = null;
        Enumeration enumeration = this.hashtable.keys();
        Enumeration enumeration2 = this.hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Container container = (Container)enumeration2.nextElement();
            long l3 = this.evaluate(container, l);
            if (l3 >= l2) continue;
            l2 = l3;
            var5_3 = k;
        }
        return var5_3;
    }

    public synchronized void hold(Object object, Object object2) {
        while (this.jvm.freeMemory() < (long)this.memory) {
            Object object3 = this.getWorst();
            if (object3 != null) {
                this.hashtable.remove(object3);
            }
            this.jvm.runFinalization();
            this.jvm.gc();
        }
        this.hashtable.put(object, new Container(object2));
    }

    public void init(Configurations configurations) throws InitializationException {
        this.memory = Integer.parseInt((String)configurations.getNotNull("memory"));
        if (this.memory <= 0) {
            throw new IllegalArgumentException("Free memory limit must be higher than zero.");
        }
        if ((long)this.memory > this.jvm.freeMemory()) {
            throw new IllegalArgumentException("Free memory is already lower than imposed limit. (free memory available:" + this.jvm.freeMemory() + ").  See documentation and FAQ on how to solve this problem.");
        }
    }

    public synchronized Enumeration list() {
        return this.hashtable.keys();
    }

    public synchronized void remove(Object object) {
        this.hashtable.remove(object);
    }

    public void store(Object object, Object object2) {
        throw new RuntimeException("Method MemoryStore.store() not implemented!");
    }

    class Container {
        public Object object;
        public long time = 0L;
        public int count = 0;

        public Container(Object object) {
            this.object = object;
        }
    }
}

