/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.producer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.Utils;
import org.apache.cocoon.framework.Monitor;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.producer.AbstractProducer;

public class ProducerFromFile
extends AbstractProducer
implements Status {
    private Monitor monitor = new Monitor(10);

    protected String getBasename(HttpServletRequest httpServletRequest) {
        try {
            httpServletRequest.getContextPath();
            URL uRL = ((ServletContext)this.context).getResource(httpServletRequest.getServletPath());
            if (uRL.getProtocol().equals("file")) {
                return uRL.getFile();
            }
            throw new RuntimeException("Cannot handle remote resources.");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            if (httpServletRequest.getPathInfo() != null) {
                return httpServletRequest.getPathTranslated().replace('\\', '/');
            }
            return httpServletRequest.getRealPath(httpServletRequest.getRequestURI());
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Malformed request URL.");
        }
        catch (NullPointerException nullPointerException) {
            return httpServletRequest.getPathTranslated().replace('\\', '/');
        }
    }

    public String getPath(HttpServletRequest httpServletRequest) {
        String string = this.getBasename(httpServletRequest);
        return string.substring(0, string.lastIndexOf(47) + 1);
    }

    public String getStatus() {
        return "Producer from local file";
    }

    public Reader getStream(HttpServletRequest httpServletRequest) throws IOException {
        File file = new File(this.getBasename(httpServletRequest));
        this.monitor.watch(Utils.encode(httpServletRequest), file);
        return new InputStreamReader(new FileInputStream(file));
    }

    public boolean hasChanged(Object object) {
        return this.monitor.hasChanged(Utils.encode((HttpServletRequest)object));
    }
}

