/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.language.java;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.apache.cocoon.processor.xsp.XSPPage;
import org.apache.cocoon.processor.xsp.XSPUtil;
import org.apache.cocoon.processor.xsp.language.XSPLanguageProcessor;
import org.apache.cocoon.processor.xsp.language.java.XSPClassLoader;
import sun.tools.javac.Main;

public class XSPJavaProcessor
implements XSPLanguageProcessor {
    protected File repository;
    protected XSPClassLoader classLoader;
    protected boolean format = false;

    public static String className(String string) {
        return XSPUtil.normalizedBaseName(XSPUtil.fileComponent(string));
    }

    public void compile(String string) throws Exception {
        String string2 = this.repository.getCanonicalPath();
        String string3 = String.valueOf(string2) + File.separator + string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Main main = new Main((OutputStream)byteArrayOutputStream, "javac");
        String[] stringArray = new String[]{"-classpath", String.valueOf(string2) + File.pathSeparator + System.getProperty("java.class.path"), "-O", string3};
        if (!main.compile(stringArray)) {
            int n = string3.length() + 1;
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray2 = XSPUtil.split(byteArrayOutputStream.toString(), "\r\n");
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray2[n2].startsWith(string3)) {
                    stringArray2[n2] = stringArray2[n2].substring(n);
                }
                stringBuffer.append(String.valueOf(stringArray2[n2]) + "\n");
                ++n2;
            }
            throw new Exception("XSP Java Compiler: Compilation failed for " + XSPUtil.fileComponent(string) + "\n" + stringBuffer.toString());
        }
    }

    public String formatCode(String string) throws Exception {
        return string;
    }

    public String getObjectExtension() {
        return "class";
    }

    public String getSourceExtension() {
        return "java";
    }

    public XSPPage load(String string) throws Exception {
        return (XSPPage)this.classLoader.loadClass(string.substring(0, string.lastIndexOf(".")).replace(File.separatorChar, '.')).newInstance();
    }

    public static String packageName(String string) {
        return XSPUtil.normalizedBaseName(XSPUtil.pathComponent(string)).replace(File.separatorChar, '.');
    }

    public void setFormatOption(boolean bl) {
        this.format = bl;
    }

    public void setRepository(File file) throws Exception {
        this.repository = file;
        this.classLoader = new XSPClassLoader(this.repository);
    }

    public String stringEncode(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\"': {
                    stringBuffer.append('\\');
                }
                default: {
                    stringBuffer.append(cArray[n]);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void unload(XSPPage xSPPage) throws Exception {
        this.classLoader = new XSPClassLoader(this.repository);
    }
}

