/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp;

import java.util.Dictionary;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.processor.xsp.language.XSPPreprocessor;
import org.apache.cocoon.transformer.Transformer;
import org.w3c.dom.Document;

public class XSPTemplate {
    protected String languageName;
    protected Document stylesheet;
    protected XSPPreprocessor preprocessor;
    private Transformer transformer;
    private Parser parser;
    private String templateBase;

    public XSPTemplate(Transformer transformer, Parser parser, String string) {
        this.transformer = transformer;
        this.parser = parser;
        this.templateBase = string;
    }

    public Document apply(Document document, Dictionary dictionary) throws Exception {
        if (this.preprocessor != null) {
            document = this.preprocessor.preprocess(document, dictionary);
        }
        return this.transformer.transform(document, (String)dictionary.get("filename"), this.stylesheet, this.templateBase, this.parser.createEmptyDocument());
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public XSPPreprocessor getPreprocessor() {
        return this.preprocessor;
    }

    public Document getStylesheet() {
        return this.stylesheet;
    }

    public void setLanguageName(String string) {
        this.languageName = string;
    }

    public void setPreprocessor(XSPPreprocessor xSPPreprocessor) {
        this.preprocessor = xSPPreprocessor;
    }

    public void setStylesheet(Document document) {
        this.stylesheet = document;
    }
}

