/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.framework.AbstractActor;
import org.apache.cocoon.framework.Configurable;
import org.apache.cocoon.framework.Configurations;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.processor.Processor;
import org.apache.cocoon.processor.xsp.XSPGlobal;
import org.apache.cocoon.processor.xsp.XSPLibrary;
import org.apache.cocoon.processor.xsp.XSPPage;
import org.apache.cocoon.processor.xsp.XSPTemplate;
import org.apache.cocoon.processor.xsp.XSPUtil;
import org.apache.cocoon.processor.xsp.language.XSPLanguageProcessor;
import org.apache.cocoon.processor.xsp.language.XSPPreprocessor;
import org.apache.cocoon.transformer.Transformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XSPProcessor
extends AbstractActor
implements Processor,
Configurable,
Status {
    public static final String DEFAULT_LANGUAGE = "java";
    protected Parser parser;
    protected Transformer transformer;
    protected Hashtable languages;
    protected Hashtable libraries;
    protected File repositoryFile;
    protected Hashtable pageCache;
    protected XSPLibrary xspLibrary;
    protected XSPGlobal global = new XSPGlobal();
    protected ServletContext servletContext;

    protected XSPGlobal getGlobal() {
        return this.global;
    }

    protected ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getStatus() {
        return "eXtensible Server Pages Processor";
    }

    public boolean hasChanged(Object object) {
        return true;
    }

    public void init(Configurations configurations) {
        Object object;
        configurations = configurations.getConfigurations("xsp");
        String string = (String)configurations.get("repository");
        this.repositoryFile = new File(string);
        if (!this.repositoryFile.exists() && !this.repositoryFile.mkdirs()) {
            throw new RuntimeException("Can't create store repository: " + this.repositoryFile.getAbsolutePath() + ". Make sure it's there or you have writing permissions.");
        }
        if (!this.repositoryFile.canRead() || !this.repositoryFile.canWrite()) {
            throw new RuntimeException("Can't access store repository: " + this.repositoryFile.getAbsolutePath() + ". Make sure you have writing permissions.");
        }
        Enumeration enumeration = this.languages.elements();
        while (enumeration.hasMoreElements()) {
            object = (XSPLanguageProcessor)enumeration.nextElement();
            try {
                object.setRepository(this.repositoryFile);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error setting repository for language processor: " + exception.getMessage());
            }
        }
        configurations = configurations.getConfigurations("library");
        object = ((Hashtable)configurations).keys();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            String string3 = string2.substring(0, string2.indexOf(46));
            String string4 = string2.substring(string2.indexOf(46) + 1);
            String string5 = (String)configurations.get(string2);
            if (this.languages.get(string4) == null) {
                throw new RuntimeException("Unsupported language '" + string4 + "' " + "in library '" + string3 + "'");
            }
            XSPLibrary xSPLibrary = (XSPLibrary)this.libraries.get(string3);
            if (xSPLibrary == null) {
                xSPLibrary = new XSPLibrary();
                xSPLibrary.setNamespace(string3);
            }
            XSPTemplate xSPTemplate = new XSPTemplate(this.transformer, this.parser, string5);
            xSPTemplate.setLanguageName(string4);
            try {
                URL uRL = new URL(string5);
                Document document = this.parser.parse(new InputSource(new URL(string5).openStream()));
                xSPTemplate.setStylesheet(document);
                String string6 = (String)this.libraries.get(String.valueOf(string3) + "." + string4 + ".preprocessor");
                if (string6 != null) {
                    XSPPreprocessor xSPPreprocessor = (XSPPreprocessor)Class.forName(string6).newInstance();
                    xSPTemplate.setPreprocessor(xSPPreprocessor);
                }
                xSPLibrary.addTemplate(xSPTemplate);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error loading logicsheet: " + string5 + ". " + exception);
            }
            this.libraries.put(string3, xSPLibrary);
        }
    }

    public void init(Director director) {
        super.init(director);
        this.parser = (Parser)director.getActor("parser");
        this.servletContext = (ServletContext)director.getActor("context");
        this.transformer = (Transformer)director.getActor("transformer");
        this.pageCache = new Hashtable();
        this.libraries = new Hashtable();
        try {
            Document document = this.parser.parse(new InputSource(new InputStreamReader(this.getClass().getResourceAsStream("xsp.xml"))));
            Element element = document.getDocumentElement();
            this.xspLibrary = new XSPLibrary();
            this.xspLibrary.setNamespace("xsp");
            this.languages = new Hashtable();
            NodeList nodeList = element.getElementsByTagName("language");
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element2 = (Element)nodeList.item(n2);
                String string = element2.getAttribute("name");
                String string2 = element2.getAttribute("processor");
                XSPLanguageProcessor xSPLanguageProcessor = (XSPLanguageProcessor)Class.forName(string2).newInstance();
                boolean bl = element2.getAttribute("format-code").equals("true");
                xSPLanguageProcessor.setFormatOption(bl);
                this.languages.put(string, xSPLanguageProcessor);
                XSPTemplate xSPTemplate = new XSPTemplate(this.transformer, this.parser, null);
                xSPTemplate.setLanguageName(string);
                String string3 = element2.getAttribute("template");
                Document document2 = this.parser.parse(new InputSource(new InputStreamReader(this.getClass().getResourceAsStream(string3))));
                xSPTemplate.setStylesheet(document2);
                String string4 = element2.getAttribute("dom-preprocessor");
                if (string4.length() > 0) {
                    XSPPreprocessor xSPPreprocessor = (XSPPreprocessor)Class.forName(string4).newInstance();
                    xSPTemplate.setPreprocessor(xSPPreprocessor);
                }
                this.xspLibrary.addTemplate(xSPTemplate);
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error during initialization: " + exception.getMessage());
        }
    }

    protected XSPPage loadPage(XSPLanguageProcessor xSPLanguageProcessor, PageEntry pageEntry, String string) throws Exception {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("director", this.director);
        hashtable.put("global", this.global);
        XSPPage xSPPage = xSPLanguageProcessor.load(string);
        xSPPage.init(hashtable);
        pageEntry.setPage(xSPPage);
        return xSPPage;
    }

    public Document process(Document document, Dictionary dictionary) throws Exception {
        Object object;
        Object object2;
        XSPLanguageProcessor xSPLanguageProcessor;
        HttpServletRequest httpServletRequest = (HttpServletRequest)dictionary.get("request");
        HttpServletResponse httpServletResponse = (HttpServletResponse)dictionary.get("response");
        String string = httpServletRequest.getPathInfo() == null ? httpServletRequest.getRealPath(httpServletRequest.getRequestURI()) : httpServletRequest.getPathTranslated();
        File file = new File(string);
        string = file.getCanonicalPath();
        Element element = document.getDocumentElement();
        String string2 = element.getAttribute("language");
        if (string2.length() == 0) {
            string2 = DEFAULT_LANGUAGE;
        }
        if ((xSPLanguageProcessor = (XSPLanguageProcessor)this.languages.get(string2)) == null) {
            throw new Exception("Unsupported language: " + string2);
        }
        PageEntry pageEntry = (PageEntry)this.pageCache.get(string);
        if (pageEntry == null) {
            object2 = XSPUtil.normalizedBaseName(string);
            object = xSPLanguageProcessor.getObjectExtension();
            if (object != null) {
                object2 = String.valueOf(object2) + "." + (String)object;
            }
            File file2 = new File(String.valueOf(this.repositoryFile.getCanonicalPath()) + File.separator + (String)object2);
            pageEntry = new PageEntry(file, file2);
            if (file2.exists() && !pageEntry.hasChanged()) {
                this.loadPage(xSPLanguageProcessor, pageEntry, (String)object2);
            }
            this.pageCache.put(string, pageEntry);
        }
        if (pageEntry.hasChanged()) {
            String string3;
            String string4;
            File file3;
            Object object3;
            Object object4;
            Object object5;
            object2 = new Vector();
            object = element.getAttributes();
            int n = object.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string5;
                object5 = (Attr)object.item(n2);
                String string6 = object5.getName();
                if (string6.length() >= 6 && string6.substring(0, 6).equals("xmlns:") && !(string5 = string6.substring(6)).equals("xsp") && (object4 = (XSPLibrary)this.libraries.get(string6.substring(6))) != null) {
                    ((Vector)object2).addElement(object4);
                }
                ++n2;
            }
            ((Vector)object2).addElement(this.xspLibrary);
            object5 = new Hashtable();
            ((Hashtable)object5).put("filename", string);
            ((Hashtable)object5).put("language", string2);
            int n3 = ((Vector)object2).size();
            int n4 = 0;
            while (n4 < n3) {
                object4 = (XSPLibrary)((Vector)object2).elementAt(n4);
                object3 = ((XSPLibrary)object4).getTemplate(string2);
                if (object3 != null) {
                    document = ((XSPTemplate)object3).apply(document, (Dictionary)object5);
                }
                ++n4;
            }
            object4 = document.getDocumentElement();
            object4.normalize();
            object3 = object4.getFirstChild().getNodeValue();
            object3 = xSPLanguageProcessor.formatCode((String)object3);
            String string7 = XSPUtil.normalizedBaseName(string);
            String string8 = xSPLanguageProcessor.getSourceExtension();
            if (string8 != null) {
                string7 = String.valueOf(string7) + "." + string8;
            }
            if (!(file3 = new File(string4 = XSPUtil.pathComponent(string3 = String.valueOf(this.repositoryFile.getCanonicalPath()) + File.separator + string7))).exists() && !file3.mkdirs()) {
                throw new Exception("Can't create subdirectory: " + string4);
            }
            FileWriter fileWriter = new FileWriter(string3);
            fileWriter.write((String)object3);
            fileWriter.flush();
            fileWriter.close();
            XSPPage xSPPage = pageEntry.getPage();
            if (xSPPage != null) {
                xSPLanguageProcessor.unload(xSPPage);
            }
            xSPLanguageProcessor.compile(string7);
            this.loadPage(xSPLanguageProcessor, pageEntry, string7);
        }
        return pageEntry.getPage().getDocument(httpServletRequest, httpServletResponse);
    }

    public class PageEntry {
        protected File source;
        protected File target;
        protected XSPPage page;

        public PageEntry(File file, File file2) {
            this.source = file;
            this.target = file2;
        }

        public XSPPage getPage() {
            return this.page;
        }

        public boolean hasChanged() {
            return !this.target.exists() || this.target.lastModified() < this.source.lastModified();
        }

        public void setPage(XSPPage xSPPage) {
            this.page = xSPPage;
        }
    }
}

