/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xslt;

import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.Defaults;
import org.apache.cocoon.Utils;
import org.apache.cocoon.framework.Actor;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.framework.Monitor;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.parser.Parser;
import org.apache.cocoon.processor.PINotFoundException;
import org.apache.cocoon.processor.Processor;
import org.apache.cocoon.processor.ProcessorException;
import org.apache.cocoon.store.Store;
import org.apache.cocoon.transformer.Transformer;
import org.w3c.dom.Document;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;

public class XSLTProcessor
implements Actor,
Processor,
Status,
Defaults {
    private Monitor monitor = new Monitor(10);
    private Parser parser;
    private Store store;
    private Transformer transformer;

    private Document getDocument(Object object) throws Exception {
        InputSource inputSource = new InputSource();
        inputSource.setSystemId(object.toString());
        if (object instanceof File) {
            inputSource.setCharacterStream(new FileReader((File)object));
        } else if (object instanceof URL) {
            inputSource.setCharacterStream(new InputStreamReader(((URL)object).openStream()));
        } else {
            throw new Error("Fatal error: Could not elaborate given resource: " + object);
        }
        return this.parser.parse(inputSource);
    }

    private Object getResource(Document document, String string, String string2) throws ProcessorException {
        Serializable serializable = null;
        Enumeration enumeration = Utils.getAllPIs(document, "xml-stylesheet").elements();
        while (enumeration.hasMoreElements()) {
            String string3;
            Hashtable hashtable = Utils.getPIPseudoAttributes((ProcessingInstruction)enumeration.nextElement());
            String string4 = (String)hashtable.get("type");
            if (string4 == null || !string4.equals("text/xsl") || (string3 = (String)hashtable.get("href")) == null) continue;
            Serializable serializable2 = null;
            try {
                serializable2 = string3.indexOf("://") < 0 ? new File(String.valueOf(string) + string3) : new URL(string3);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ProcessorException("Could not associate stylesheet to document: " + string3 + " is a malformed URL.");
            }
            String string5 = (String)hashtable.get("media");
            if (string5 == null) {
                serializable = serializable2;
                if (string2 != null) continue;
                break;
            }
            if (string2 == null || !string5.equals(string2)) continue;
            serializable = serializable2;
            break;
        }
        if (serializable == null) {
            throw new ProcessorException("Could not associate stylesheet to document:  no matching stylesheet for: " + string2);
        }
        return serializable;
    }

    public String getStatus() {
        return "XSLT Processor";
    }

    private Document getStylesheet(Object object, Document document, HttpServletRequest httpServletRequest) throws ProcessorException {
        try {
            Document document2;
            if (this.hasChanged(httpServletRequest)) {
                document2 = this.getDocument(object);
                this.store.hold(object, document2);
                this.monitor.watch(Utils.encode(httpServletRequest, true), object);
            } else {
                Object object2 = this.store.get(object);
                if (object2 != null) {
                    document2 = (Document)object2;
                } else {
                    document2 = this.getDocument(object);
                    this.store.hold(object, document2);
                }
            }
            return document2;
        }
        catch (Exception exception) {
            throw new ProcessorException("Could not associate stylesheet to document:  error reading " + object + ": " + exception.getMessage());
        }
    }

    public boolean hasChanged(Object object) {
        return this.monitor.hasChanged(Utils.encode((HttpServletRequest)object, true));
    }

    public void init(Director director) {
        this.parser = (Parser)director.getActor("parser");
        this.store = (Store)director.getActor("store");
        this.transformer = (Transformer)director.getActor("transformer");
    }

    public Document process(Document document, Dictionary dictionary) throws Exception {
        Document document2 = (Document)dictionary.get("stylesheet");
        if (document2 != null) {
            return document2;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)dictionary.get("request");
        String string = (String)dictionary.get("path");
        String string2 = (String)dictionary.get("browser");
        try {
            Object object = this.getResource(document, string, string2);
            Document document3 = this.getStylesheet(object, document, httpServletRequest);
            Document document4 = this.parser.createEmptyDocument();
            return this.transformer.transform(document, null, document3, object.toString(), document4);
        }
        catch (PINotFoundException pINotFoundException) {
            return document;
        }
    }
}

