/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.interpreter.ecmascript;

import FESI.jslib.JSException;
import FESI.jslib.JSGlobalObject;
import java.util.Dictionary;
import org.apache.cocoon.interpreter.Instance;
import org.apache.cocoon.interpreter.LanguageException;
import org.apache.cocoon.interpreter.ecmascript.EcmaScriptEvaluator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EcmaScriptInstance
implements Instance {
    private Document document;
    private EcmaScriptEvaluator evaluator;

    public EcmaScriptInstance(EcmaScriptEvaluator ecmaScriptEvaluator, Document document) throws LanguageException {
        this.evaluator = ecmaScriptEvaluator;
        this.document = document;
    }

    public void destroy() {
        this.evaluator.release();
    }

    public Object getInstance() {
        return this.evaluator.getGlobalObject();
    }

    public Node invoke(String string, Dictionary dictionary, Node node) throws LanguageException {
        try {
            Object[] objectArray = new Object[]{dictionary, node};
            JSGlobalObject jSGlobalObject = this.evaluator.getGlobalObject();
            Object object = jSGlobalObject.call(string, objectArray);
            if (object == null) {
                return null;
            }
            if (object instanceof Node) {
                return (Node)object;
            }
            return this.document.createTextNode(object.toString());
        }
        catch (JSException jSException) {
            jSException.printStackTrace();
            throw new LanguageException(jSException.getMessage());
        }
    }
}

