/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.formatter;

import java.io.Writer;
import java.util.Dictionary;
import org.apache.cocoon.formatter.AbstractFormatter;
import org.apache.cocoon.framework.Status;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.w3c.dom.Document;

public class WMLFormatter
extends AbstractFormatter
implements Status {
    private SerializerFactory factory = SerializerFactory.getSerializerFactory((String)"xml");

    public void format(Document document, Writer writer, Dictionary dictionary) throws Exception {
        OutputFormat outputFormat = super.getFormat(dictionary);
        outputFormat.setMethod("xml");
        outputFormat.setOmitXMLDeclaration(false);
        outputFormat.setPreserveSpace(false);
        outputFormat.setDoctype("-//WAPFORUM//DTD WML 1.1//EN", "http://www.wapforum.org/DTD/wml_1.1.xml");
        Serializer serializer = this.factory.makeSerializer(writer, outputFormat);
        serializer.asDOMSerializer().serialize(document);
    }

    public String getMIMEType() {
        return "text/vnd.wap.wml";
    }

    public String getStatus() {
        return "WML Formatter";
    }
}

