/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.formatter;

import java.io.Writer;
import java.util.Dictionary;
import org.apache.cocoon.formatter.AbstractFormatter;
import org.apache.cocoon.framework.Status;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.w3c.dom.Document;

public class HTMLFormatter
extends AbstractFormatter
implements Status {
    private SerializerFactory factory = SerializerFactory.getSerializerFactory((String)"html");

    public void format(Document document, Writer writer, Dictionary dictionary) throws Exception {
        OutputFormat outputFormat = super.getFormat(dictionary);
        outputFormat.setMethod("html");
        outputFormat.setOmitXMLDeclaration(true);
        outputFormat.setPreserveSpace(true);
        outputFormat.setDoctype("-//W3C//DTD HTML 4.0//EN", "http://www.w3.org/TR/REC-html40/strict.dtd");
        outputFormat.setVersion("4.0");
        Serializer serializer = this.factory.makeSerializer(writer, outputFormat);
        serializer.asDOMSerializer().serialize(document);
    }

    public String getMIMEType() {
        return "text/html";
    }

    public String getStatus() {
        return "HTML Formatter";
    }
}

