/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.cache;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.Utils;
import org.apache.cocoon.cache.Cache;
import org.apache.cocoon.framework.Changeable;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.framework.Page;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.store.Store;

public class CocoonCache
implements Cache,
Status {
    private Store store;

    public Page getPage(HttpServletRequest httpServletRequest) {
        Page page = (Page)this.store.get(Utils.encode(httpServletRequest));
        if (page == null) {
            return null;
        }
        boolean bl = false;
        Enumeration enumeration = page.getChangeables();
        while (enumeration.hasMoreElements()) {
            Changeable changeable = (Changeable)enumeration.nextElement();
            bl = changeable.hasChanged(httpServletRequest);
            if (bl) break;
        }
        return bl ? null : page;
    }

    public String getStatus() {
        return "Cocoon Dynamic Cache System";
    }

    public void init(Director director) {
        this.store = (Store)director.getActor("store");
    }

    public void setPage(Page page, HttpServletRequest httpServletRequest) {
        if (!page.isCached()) {
            page.setCached(true);
            this.store.hold(Utils.encode(httpServletRequest), page);
        }
    }
}

