/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public final class Utils {
    public static final String encode(HttpServletRequest httpServletRequest) {
        return Utils.encode(httpServletRequest, true, true);
    }

    public static final String encode(HttpServletRequest httpServletRequest, boolean bl) {
        return Utils.encode(httpServletRequest, bl, true);
    }

    public static final String encode(HttpServletRequest httpServletRequest, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(httpServletRequest.getHeader("user-Agent"));
            stringBuffer.append(':');
        }
        stringBuffer.append(httpServletRequest.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        stringBuffer.append(':');
        stringBuffer.append(httpServletRequest.getServerPort());
        stringBuffer.append(httpServletRequest.getRequestURI());
        if (bl2) {
            stringBuffer.append('?');
            stringBuffer.append(httpServletRequest.getQueryString());
        }
        return stringBuffer.toString();
    }

    public static final Vector getAllPIs(Document document, String string) {
        return Utils.getAllPIs(document, string, false);
    }

    public static final Vector getAllPIs(Document document, String string, boolean bl) {
        Vector<Node> vector = new Vector<Node>();
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 7 && ((ProcessingInstruction)node).getTarget().equals(string)) {
                vector.addElement(node);
                if (bl) {
                    node.getParentNode().removeChild(node);
                }
            }
            ++n2;
        }
        return vector;
    }

    public static final ProcessingInstruction getFirstPI(Document document, String string) {
        return Utils.getFirstPI(document, string, false);
    }

    public static final ProcessingInstruction getFirstPI(Document document, String string, boolean bl) {
        ProcessingInstruction processingInstruction = null;
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 7 && ((ProcessingInstruction)node).getTarget().equals(string)) {
                processingInstruction = (ProcessingInstruction)node;
                if (!bl) break;
                node.getParentNode().removeChild(node);
                break;
            }
            ++n2;
        }
        return processingInstruction;
    }

    public static final Hashtable getPIPseudoAttributes(Document document, String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = Utils.getAllPIs(document, string).elements();
        while (enumeration.hasMoreElements()) {
            String string2 = ((ProcessingInstruction)enumeration.nextElement()).getData();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t=");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                string4 = string4.substring(1, string4.length() - 1);
                hashtable.put(string3, string4);
            }
        }
        return hashtable;
    }

    public static final Hashtable getPIPseudoAttributes(ProcessingInstruction processingInstruction) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = processingInstruction.getData();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t=");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            string3 = string3.substring(1, string3.length() - 1);
            hashtable.put(string2, string3);
        }
        return hashtable;
    }
}

