/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jserv;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.java.lang.Lock;
import org.apache.jserv.JServ;
import org.apache.jserv.JServConnection;
import org.apache.jserv.JServLogChannels;
import org.apache.jserv.JServSendError;
import org.apache.jserv.JServServletManager;

class JServContext
implements ServletConfig,
ServletContext,
JServSendError,
JServLogChannels {
    private JServServletManager servletMgr;
    Servlet servlet;
    private Properties initargs;
    Lock lock;
    String aliasName;

    public JServContext(Servlet servlet, JServServletManager jServServletManager, Properties properties, String string) {
        this.servlet = servlet;
        this.servletMgr = jServServletManager;
        this.initargs = properties;
        this.aliasName = string;
        this.lock = new Lock();
    }

    public ServletContext getServletContext() {
        return this;
    }

    public String getInitParameter(String string) {
        return this.initargs.getProperty(string);
    }

    public Enumeration getInitParameterNames() {
        return this.initargs.propertyNames();
    }

    public Servlet getServlet(String string) throws ServletException {
        JServContext jServContext = this.servletMgr.loadServlet(string, this);
        if (jServContext != null) {
            return jServContext.servlet;
        }
        return null;
    }

    public Enumeration getServlets() {
        return this.servletMgr.getLoadedServlets();
    }

    public Enumeration getServletNames() {
        return this.servletMgr.getServletNames();
    }

    public void log(String string) {
        JServ.log.log("servletLog", String.valueOf(this.aliasName == null ? "" : String.valueOf(this.aliasName) + "/") + string);
    }

    public void log(Exception exception, String string) {
        this.log(string, exception);
    }

    public void log(String string, Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        printWriter.println(string);
        throwable.printStackTrace(printWriter);
        this.log(charArrayWriter.toString());
    }

    public String getRealPath(String string) {
        return null;
    }

    public String getMimeType(String string) {
        String string2 = string.toLowerCase();
        if (string2.endsWith(".html") || string2.endsWith(".htm")) {
            return "text/html";
        }
        if (string2.endsWith(".txt")) {
            return "text/plain";
        }
        if (string2.endsWith(".css")) {
            return "text/css";
        }
        if (string2.endsWith(".sgml") || string2.endsWith(".sgm")) {
            return "text/x-sgml";
        }
        if (string2.endsWith(".gif")) {
            return "image/gif";
        }
        if (string2.endsWith(".jpg") || string2.endsWith(".jpeg") || string2.endsWith(".jpe")) {
            return "image/jpeg";
        }
        if (string2.endsWith(".png")) {
            return "image/png";
        }
        if (string2.endsWith(".tif") || string2.endsWith(".tiff")) {
            return "image/tiff";
        }
        if (string2.endsWith(".rgb")) {
            return "image/x-rgb";
        }
        if (string2.endsWith(".xbm")) {
            return "image/x-xbitmap";
        }
        if (string2.endsWith(".xpm")) {
            return "image/x-xpixmap";
        }
        if (string2.endsWith(".au") || string2.endsWith(".snd")) {
            return "audio/basic";
        }
        if (string2.endsWith(".mid") || string2.endsWith(".midi") || string2.endsWith(".rmi") || string2.endsWith(".kar")) {
            return "audio/mid";
        }
        if (string2.endsWith(".mpga") || string2.endsWith(".mp2") || string2.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        if (string2.endsWith(".wav")) {
            return "audio/wav";
        }
        if (string2.endsWith(".aiff") || string2.endsWith(".aifc")) {
            return "audio/aiff";
        }
        if (string2.endsWith(".aif")) {
            return "audio/x-aiff";
        }
        if (string2.endsWith(".ra")) {
            return "audio/x-realaudio";
        }
        if (string2.endsWith(".ram")) {
            return "audio/x-pn-realaudio";
        }
        if (string2.endsWith(".rpm")) {
            return "audio/x-pn-realaudio-plugin";
        }
        if (string2.endsWith(".sd2")) {
            return "audio/x-sd2";
        }
        if (string2.endsWith(".bin") || string2.endsWith(".dms") || string2.endsWith(".lha") || string2.endsWith(".lzh") || string2.endsWith(".exe") || string2.endsWith(".class")) {
            return "application/octet-stream";
        }
        if (string2.endsWith(".hqx")) {
            return "application/mac-binhex40";
        }
        if (string2.endsWith(".ps") || string2.endsWith(".ai") || string2.endsWith(".eps")) {
            return "application/postscript";
        }
        if (string2.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (string2.endsWith(".rtf")) {
            return "application/rtf";
        }
        if (string2.endsWith(".doc")) {
            return "application/msword";
        }
        if (string2.endsWith(".ppt")) {
            return "application/powerpoint";
        }
        if (string2.endsWith(".fif")) {
            return "application/fractals";
        }
        if (string2.endsWith(".p7c")) {
            return "application/pkcs7-mime";
        }
        if (string2.endsWith(".js")) {
            return "application/x-javascript";
        }
        if (string2.endsWith(".z")) {
            return "application/x-compress";
        }
        if (string2.endsWith(".gz")) {
            return "application/x-gzip";
        }
        if (string2.endsWith(".tar")) {
            return "application/x-tar";
        }
        if (string2.endsWith(".tgz")) {
            return "application/x-compressed";
        }
        if (string2.endsWith(".zip")) {
            return "application/x-zip-compressed";
        }
        if (string2.endsWith(".dir") || string2.endsWith(".dcr") || string2.endsWith(".dxr")) {
            return "application/x-director";
        }
        if (string2.endsWith(".dvi")) {
            return "application/x-dvi";
        }
        if (string2.endsWith(".tex")) {
            return "application/x-tex";
        }
        if (string2.endsWith(".latex")) {
            return "application/x-latex";
        }
        if (string2.endsWith(".tcl")) {
            return "application/x-tcl";
        }
        if (string2.endsWith(".cer") || string2.endsWith(".crt") || string2.endsWith(".der")) {
            return "application/x-x509-ca-cert";
        }
        if (string2.endsWith(".mpg") || string2.endsWith(".mpe") || string2.endsWith(".mpeg")) {
            return "video/mpeg";
        }
        if (string2.endsWith(".qt") || string2.endsWith(".mov")) {
            return "video/quicktime";
        }
        if (string2.endsWith(".avi")) {
            return "video/x-msvideo";
        }
        if (string2.endsWith(".movie")) {
            return "video/x-sgi-movie";
        }
        if (string2.endsWith(".pdb") || string2.endsWith(".xyz")) {
            return "chemical/x-pdb";
        }
        if (string2.endsWith(".ice")) {
            return "x-conference/x-cooltalk";
        }
        if (string2.endsWith(".wrl") || string2.endsWith(".vrml")) {
            return "x-world/x-vrml";
        }
        return null;
    }

    public String getServerInfo() {
        return "ApacheJServ/1.1";
    }

    public Object getAttribute(String string) {
        return null;
    }

    public void sendError(int n, String string) {
        this.log(String.valueOf(JServConnection.findStatusString(n)) + ": " + string);
    }

    public void sendError(Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        throwable.printStackTrace(printWriter);
        this.log(charArrayWriter.toString());
    }

    public Servlet getServlet() {
        return this.servlet;
    }
}

