/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ESWrapper;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.EventAdaptorGenerator;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;

public abstract class EventAdaptor {
    protected Object source;
    protected ESWrapper wrapper;
    protected Method addAdaptorMethod;
    protected Method removeAdaptorMethod;
    static /* synthetic */ Class class$java$util$EventListener;

    public static EventAdaptor getEventAdaptor(Class clazz, Object object, ESWrapper eSWrapper) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IntrospectionException {
        Class clazz2 = null;
        EventAdaptor eventAdaptor = null;
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        if (EventAdaptor.validateEventSource(eventSetDescriptorArray, clazz) == -1) {
            throw new IllegalArgumentException("Object: " + object + " does not source: " + clazz.getName());
        }
        clazz2 = EventAdaptor.getEventAdaptorClass(clazz);
        eventAdaptor = (EventAdaptor)clazz2.newInstance();
        eventAdaptor.setWrapper(eSWrapper);
        try {
            eventAdaptor.setSource(object);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to register with source");
        }
        return eventAdaptor;
    }

    public static Class getEventAdaptorClass(Class clazz) throws ClassNotFoundException {
        if (!(class$java$util$EventListener != null ? class$java$util$EventListener : (class$java$util$EventListener = EventAdaptor.class$("java.util.EventListener"))).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class is not a subinterface of java.util.EventListenerEventListener");
        }
        return EventAdaptorGenerator.getAdaptorClassForListenerClass(clazz);
    }

    protected EventAdaptor() {
    }

    public abstract Class getListenerClass();

    public String getListenerClassName() {
        return this.getListenerClass().getName();
    }

    public synchronized Object getSource() {
        return this.source;
    }

    public synchronized ESWrapper getWarepper() {
        return this.wrapper;
    }

    public synchronized void setWrapper(ESWrapper eSWrapper) {
        this.wrapper = eSWrapper;
    }

    private static int validateEventSource(EventSetDescriptor[] eventSetDescriptorArray, Class clazz) {
        int n = 0;
        while (n < eventSetDescriptorArray.length) {
            if (clazz.equals(eventSetDescriptorArray[n].getListenerType())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized void setSource(Object object) throws IntrospectionException, Exception {
        if (this.source != null && object != null && this.source.equals(object)) {
            return;
        }
        if (this.source != null) {
            this.removeAdaptorFromSource();
        }
        if (object == null) {
            this.source = null;
            this.addAdaptorMethod = null;
            this.removeAdaptorMethod = null;
            return;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        int n = EventAdaptor.validateEventSource(eventSetDescriptorArray, this.getListenerClass());
        if (n == -1) {
            throw new IllegalArgumentException("Object: " + object + " does not source: " + this.getListenerClassName());
        }
        Object object2 = this.source;
        Method method = this.addAdaptorMethod;
        Method method2 = this.removeAdaptorMethod;
        this.source = object;
        this.addAdaptorMethod = eventSetDescriptorArray[n].getAddListenerMethod();
        this.removeAdaptorMethod = eventSetDescriptorArray[n].getRemoveListenerMethod();
        try {
            this.addAdaptorToSource();
            return;
        }
        catch (Exception exception) {
            this.source = object2;
            this.addAdaptorMethod = method;
            this.removeAdaptorMethod = method2;
            if (this.source != null) {
                this.addAdaptorToSource();
            }
            throw exception;
        }
    }

    protected void fire(EventObject eventObject, Method method) throws Exception {
        Object[] objectArray = new Object[]{eventObject};
        this.wrapper.dispatchEvent(objectArray, this.getListenerClass(), method);
    }

    protected void fire(Object[] objectArray, Method method) throws Exception {
        this.wrapper.dispatchEvent(objectArray, this.getListenerClass(), method);
    }

    protected void addAdaptorToSource() {
        try {
            Object[] objectArray = new Object[]{this};
            this.addAdaptorMethod.invoke(this.source, objectArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ProgrammingError("cannot add adaptor [" + this + "] to source [" + this.source + "] InvocationTargetException: " + invocationTargetException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ProgrammingError("cannot add adaptor [" + this + "] to source [" + this.source + "] IllegalAccessException: " + illegalAccessException.getMessage());
        }
    }

    protected void removeAdaptorFromSource() {
        try {
            Object[] objectArray = new Object[]{this};
            this.removeAdaptorMethod.invoke(this.source, objectArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("cannot remove adaptor [" + this + "] from source [" + this.source + "] InvocationTargetException: " + invocationTargetException.getMessage());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("cannot remove adaptor [" + this + "] from source [" + this.source + "] IllegalAccessException: " + illegalAccessException.getMessage());
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

