/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ESLoader;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;

public class ClassInfo {
    private static Hashtable allClassInfo = new Hashtable();
    private Hashtable publicMethods;
    private Hashtable beanMethods;
    private Hashtable beanProperties;
    private BeanInfo beanInfo;

    private ClassInfo() {
    }

    private static ClassInfo ensureClassInfo(Class clazz) {
        boolean bl = ESLoader.isDebugJavaAccess();
        ClassInfo classInfo = (ClassInfo)allClassInfo.get(clazz);
        if (classInfo == null) {
            if (bl) {
                System.out.println("** Class info for class '" + clazz + "' not found in cache, created");
            }
            classInfo = new ClassInfo();
            allClassInfo.put(clazz, classInfo);
        }
        return classInfo;
    }

    public static synchronized PropertyDescriptor lookupBeanField(String string, Class clazz) {
        ClassInfo classInfo = ClassInfo.ensureClassInfo(clazz);
        return classInfo.cachedBeanFieldLookup(string, clazz);
    }

    private PropertyDescriptor cachedBeanFieldLookup(String string, Class clazz) {
        Object object;
        PropertyDescriptor[] propertyDescriptorArray;
        boolean bl = ESLoader.isDebugJavaAccess();
        if (this.beanProperties != null) {
            if (bl) {
                System.out.println("** Bean properties for class '" + clazz + "' found in cache");
            }
            if ((propertyDescriptorArray = (PropertyDescriptor[])this.beanProperties.get(string)) != null) {
                if (bl) {
                    System.out.println("** property descriptor '" + string + "' found in cache");
                }
                return propertyDescriptorArray;
            }
        }
        if (bl) {
            System.out.println("** No property named '" + string + "' found in cache, lookup started");
        }
        if (this.beanInfo == null) {
            try {
                this.beanInfo = Introspector.getBeanInfo(clazz);
            }
            catch (IntrospectionException introspectionException) {
                if (bl) {
                    System.out.println(" ** Error getting beaninfo: " + introspectionException);
                }
                return null;
            }
        }
        propertyDescriptorArray = this.beanInfo.getPropertyDescriptors();
        Object object2 = null;
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            object = propertyDescriptorArray[n];
            if (bl) {
                System.out.println("** Property examined: " + ((FeatureDescriptor)object).getName());
            }
            if (((FeatureDescriptor)object).getName().equals(string)) {
                object2 = object;
                break;
            }
            ++n;
        }
        if (object2 != null) {
            object = ((PropertyDescriptor)object2).getReadMethod();
            Method method = ((PropertyDescriptor)object2).getWriteMethod();
            Class<?> clazz2 = ((PropertyDescriptor)object2).getPropertyType();
            if (object2 instanceof IndexedPropertyDescriptor) {
                Class<?>[] classArray;
                IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)object2;
                Method method2 = indexedPropertyDescriptor.getIndexedReadMethod();
                Method method3 = indexedPropertyDescriptor.getIndexedWriteMethod();
                Class<?> clazz3 = indexedPropertyDescriptor.getIndexedPropertyType();
                if (clazz3 == null) {
                    throw new ProgrammingError("getIndexedPropertyType returned null for " + string);
                }
                if (clazz3 == Void.TYPE) {
                    throw new ProgrammingError("Void indexed property type for '" + string + "' is not allowed");
                }
                if (method2 != null && method2.getParameterTypes().length != 1) {
                    throw new ProgrammingError("Indexed getter of property ' " + string + "' should have 1 parameter!");
                }
                if (method3 != null) {
                    classArray = method3.getParameterTypes();
                    if (classArray == null || classArray.length != 2) {
                        throw new ProgrammingError("Indexed setter of property ' " + string + "' should have 2 parameter!");
                    }
                    if (classArray[0] != clazz3) {
                        throw new ProgrammingError("Inconstant parameter type for indexed setter of indexed property' " + string + "', type: " + clazz2);
                    }
                }
                if (clazz2 != null) {
                    if (!clazz2.isArray()) {
                        throw new ProgrammingError("Non array type (" + clazz2 + ") for array access of indexed property '" + string + "'");
                    }
                    if (clazz2.getComponentType() != clazz3) {
                        throw new ProgrammingError("Type missmatch between array and non array access of indexed property '" + string + "'");
                    }
                    if (object != null && ((Method)object).getParameterTypes().length != 0) {
                        throw new ProgrammingError("Non indexed getter of indxed property ' " + string + "' is not supposed to have a parameter!");
                    }
                    if (method != null) {
                        classArray = method.getParameterTypes();
                        if (classArray == null || classArray.length != 1) {
                            throw new ProgrammingError("Non indexed setter of indexed property ' " + string + "' should have 1 parameter!");
                        }
                        if (classArray[0] != clazz2) {
                            throw new ProgrammingError("Inconstant parameter type for non indexed setter of indexed property' " + string + "', type: " + clazz2);
                        }
                    }
                }
            } else {
                if (clazz2 == null) {
                    throw new ProgrammingError("getPropertyType returned null for " + string);
                }
                if (clazz2 == Void.TYPE) {
                    throw new ProgrammingError("Void property type for '" + string + "' is not allowed");
                }
                if (object != null && ((Method)object).getParameterTypes().length != 0) {
                    throw new ProgrammingError("Non indexed getter of property ' " + string + "' is not supposed to have a parameter!");
                }
                if (method != null) {
                    Class<?>[] classArray = method.getParameterTypes();
                    if (classArray == null || classArray.length != 1) {
                        throw new ProgrammingError("Non indexed setter of property ' " + string + "' should have 1 parameter!");
                    }
                    if (classArray[0] != clazz2) {
                        throw new ProgrammingError("Inconstant parameter type for setter of property' " + string + "', type: " + clazz2);
                    }
                }
            }
            if (bl) {
                System.out.println("** property '" + string + "' + found, add to cache");
            }
            if (this.beanProperties == null) {
                this.beanProperties = new Hashtable();
            }
            this.beanProperties.put(string, object2);
        } else if (bl) {
            System.out.println("** No method named '" + string + "' found");
        }
        return object2;
    }

    public static synchronized Method[] lookupPublicMethod(String string, Class clazz) throws EcmaScriptException {
        ClassInfo classInfo = ClassInfo.ensureClassInfo(clazz);
        return classInfo.cachedPublicMethodLookup(string, clazz);
    }

    /*
     * Unable to fully structure code
     */
    private Method getInInterfaces(String var1_1, Class[] var2_2, Class[] var3_3) {
        var4_4 = ESLoader.isDebugJavaAccess();
        if (var4_4 && var2_2.length > 0) {
            System.out.println("** Looking in " + var2_2.length + " interfaces");
        }
        var5_5 = 0;
        while (var5_5 < var2_2.length) {
            var6_6 = var2_2[var5_5];
            if (Modifier.isPublic(var6_6.getModifiers())) {
                if (var4_4) {
                    System.out.println("** Looking in public interface: " + var6_6);
                }
                try {
                    var7_7 = var6_6.getDeclaredMethod(var1_1, var3_3);
                    if (!Modifier.isPublic(var7_7.getModifiers())) ** GOTO lbl24
                    if (var4_4) {
                        System.out.println("** Public method found: " + var1_1);
                    }
                    return var7_7;
                }
                catch (NoSuchMethodException v0) {
                    if (!var4_4) ** GOTO lbl24
                    System.out.println("** The method has no public declaration in the interface: " + var1_1);
                }
                catch (SecurityException var7_8) {
                    throw new ProgrammingError("Access error inspecting method " + var1_1 + ": " + var7_8);
                }
            } else if (var4_4) {
                System.out.println("** Interface " + var6_6 + " is not public - not searching for method");
            }
lbl24:
            // 6 sources

            if ((var8_9 = this.getInInterfaces(var1_1, (Class[])(var7_7 = var6_6.getInterfaces()), var3_3)) != null) {
                if (var4_4) {
                    System.out.println("** Method found in super interfaces");
                }
                return var8_9;
            }
            ++var5_5;
        }
        if (var4_4) {
            System.out.println("** No method found in interface and super interfaces");
        }
        return null;
    }

    private Method[] cachedPublicMethodLookup(String string, Class clazz) throws EcmaScriptException {
        Object object;
        Method[] methodArray;
        boolean bl = ESLoader.isDebugJavaAccess();
        if (this.publicMethods != null) {
            if (bl) {
                System.out.println("** Method descriptor for class '" + clazz + "' found in cache");
            }
            if ((methodArray = (Method[])this.publicMethods.get(string)) != null) {
                if (bl) {
                    System.out.println("** " + methodArray.length + " method(s) named '" + string + "' found in cache");
                }
                return methodArray;
            }
        }
        if (bl) {
            System.out.println("** No method named '" + string + "' found in class cache, lookup started");
        }
        methodArray = clazz.getMethods();
        Vector<Object[]> vector = new Vector<Object[]>(methodArray.length);
        boolean bl2 = false;
        int n = 0;
        while (n < methodArray.length) {
            object = methodArray[n];
            if (bl) {
                System.out.println("** Method examined: " + ((Method)object).toString());
            }
            if (((Method)object).getName().equals(string)) {
                if (!Modifier.isStatic(clazz.getModifiers()) && !Modifier.isPublic(clazz.getModifiers())) {
                    if (bl) {
                        System.out.println("** Class " + clazz + " is not public, examining superclasses and interfaces to find proper method descriptor");
                    }
                    Class[] classArray = ((Method)object).getParameterTypes();
                    Class clazz2 = clazz;
                    while (clazz2 != null) {
                        block27: {
                            Class[] classArray2 = clazz.getInterfaces();
                            Method method = this.getInInterfaces(string, classArray2, classArray);
                            if (method != null) {
                                object = method;
                                bl2 = true;
                                break;
                            }
                            if (Modifier.isPublic(clazz2.getModifiers())) {
                                if (bl) {
                                    System.out.println("** Looking in public class: " + clazz2);
                                }
                                try {
                                    method = clazz2.getDeclaredMethod(string, classArray);
                                    if (Modifier.isPublic(((Method)object).getModifiers())) {
                                        if (bl) {
                                            System.out.println("** Public method found: " + string);
                                        }
                                        object = method;
                                        bl2 = true;
                                        break;
                                    }
                                    break block27;
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    if (bl) {
                                        System.out.println("** The method has no public declaration in the public class: " + string);
                                    }
                                    break block27;
                                }
                                catch (SecurityException securityException) {
                                    throw new ProgrammingError("Access error inspecting method " + string + ": " + securityException);
                                }
                            }
                            if (bl) {
                                System.out.println("** Class " + clazz2 + " is not public - not searching for method");
                            }
                        }
                        clazz2 = clazz2.getSuperclass();
                    }
                    if (!bl2) {
                        throw new EcmaScriptException("The method '" + string + "' has no public declaration in a public class or public interface ");
                    }
                }
                vector.addElement((Object[])object);
            }
            ++n;
        }
        object = null;
        int n2 = vector.size();
        if (n2 > 0) {
            if (bl) {
                System.out.println("** " + n2 + " methods named: '" + string + "' + found, add to class cache");
            }
            object = new Method[n2];
            vector.copyInto((Object[])object);
            if (this.publicMethods == null) {
                this.publicMethods = new Hashtable();
            }
            this.publicMethods.put(string, object);
        } else if (bl) {
            System.out.println("** No method named '" + string + "' found");
        }
        return object;
    }

    public static synchronized Method[] lookupBeanMethod(String string, Class clazz) {
        ClassInfo classInfo = ClassInfo.ensureClassInfo(clazz);
        return classInfo.cachedBeanMethodLookup(string, clazz);
    }

    private Method[] cachedBeanMethodLookup(String string, Class clazz) {
        Object object;
        Object[] objectArray;
        boolean bl = ESLoader.isDebugJavaAccess();
        if (this.beanMethods != null) {
            if (bl) {
                System.out.println("** Method descriptor for bean '" + clazz + "' found in cache");
            }
            if ((objectArray = (Method[])this.beanMethods.get(string)) != null) {
                if (bl) {
                    System.out.println("** " + objectArray.length + " method(s) named '" + string + "' found in cache");
                }
                return objectArray;
            }
        }
        if (bl) {
            System.out.println("** No method named '" + string + "' found in bean cache, lookup started");
        }
        if (this.beanInfo == null) {
            try {
                this.beanInfo = Introspector.getBeanInfo(clazz);
            }
            catch (IntrospectionException introspectionException) {
                if (bl) {
                    System.out.println(" ** Error getting beaninfo: " + introspectionException);
                }
                return null;
            }
        }
        objectArray = this.beanInfo.getMethodDescriptors();
        Vector<Object[]> vector = new Vector<Object[]>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            object = ((MethodDescriptor)objectArray[n]).getMethod();
            if (bl) {
                System.out.println("** Method examined: " + object.toString());
            }
            if (((FeatureDescriptor)objectArray[n]).getName().equals(string)) {
                if (!Modifier.isStatic(clazz.getModifiers()) && !Modifier.isPublic(clazz.getModifiers())) {
                    if (bl) {
                        System.out.println("** Bean class " + clazz + " is not public, examining superclasses to find proper method descriptor");
                    }
                    Class clazz2 = clazz;
                    while (clazz2 != null) {
                        block28: {
                            if (Modifier.isPublic(clazz2.getModifiers())) {
                                if (bl) {
                                    System.out.println("** Looking in public superlass: " + clazz2);
                                }
                                try {
                                    Class<?>[] classArray = object.getParameterTypes();
                                    Method method = clazz2.getDeclaredMethod(string, classArray);
                                    if (Modifier.isPublic(object.getModifiers())) {
                                        if (bl) {
                                            System.out.println("** Public method found: " + string);
                                        }
                                        object = method;
                                        break;
                                    }
                                    break block28;
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    throw new ProgrammingError("Error inspecting method " + string + ": " + noSuchMethodException);
                                }
                                catch (SecurityException securityException) {
                                    throw new ProgrammingError("Acess error inspecting method " + string + ": " + securityException);
                                }
                            }
                            if (bl) {
                                System.out.println("** Superlass " + clazz2 + " is not public");
                            }
                        }
                        clazz2 = clazz2.getSuperclass();
                    }
                }
                vector.addElement((Object[])object);
            }
            ++n;
        }
        object = null;
        int n2 = vector.size();
        if (n2 > 0) {
            if (bl) {
                System.out.println("** " + n2 + " methods named: '" + string + "' + found, add to bean cache");
            }
            object = new Method[n2];
            vector.copyInto((Object[])object);
            if (this.beanMethods == null) {
                this.beanMethods = new Hashtable();
            }
            this.beanMethods.put(string, object);
        } else if (bl) {
            System.out.println("** No bean method named: '" + string + "' + found");
        }
        return object;
    }
}

