/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ESWrapper;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESDatabase;
import FESI.Extensions.ESRowSet;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;

public class Database
extends Extension {
    private transient Evaluator evaluator;
    private ESObject esDatabasePrototype;
    private ESObject esRowSetPrototype;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject globalObject = evaluator.getGlobalObject();
        ObjectPrototype objectPrototype = (ObjectPrototype)evaluator.getObjectPrototype();
        FunctionPrototype functionPrototype = (FunctionPrototype)evaluator.getFunctionPrototype();
        this.esRowSetPrototype = new ObjectPrototype(objectPrototype, evaluator);
        this.esDatabasePrototype = new ESDatabase(objectPrototype, evaluator);
        GlobalObjectDatabase globalObjectDatabase = new GlobalObjectDatabase("Database", evaluator, functionPrototype);
        globalObjectDatabase.putHiddenProperty("prototype", this.esDatabasePrototype);
        globalObjectDatabase.putHiddenProperty("length", new ESNumber(2.0));
        this.esDatabasePrototype.putHiddenProperty("constructor", globalObjectDatabase);
        this.esDatabasePrototype.putHiddenProperty("getLastError", new DatabaseGetLastError("getLastError", evaluator, functionPrototype));
        this.esDatabasePrototype.putHiddenProperty("release", new DatabaseRelease("release", evaluator, functionPrototype));
        this.esDatabasePrototype.putHiddenProperty("connect", new DatabaseConnect("connect", evaluator, functionPrototype));
        this.esDatabasePrototype.putHiddenProperty("disconnect", new DatabaseDisconnect("disconnect", evaluator, functionPrototype));
        this.esDatabasePrototype.putHiddenProperty("executeRetrieval", new DatabaseExecuteRetrieval("executeRetrieval", evaluator, functionPrototype));
        this.esDatabasePrototype.putHiddenProperty("executeCommand", new DatabaseExecuteCommand("executeCommand", evaluator, functionPrototype));
        this.esDatabasePrototype.putHiddenProperty("getMetaData", new DatabaseGetMetaData("getMetaData", evaluator, functionPrototype));
        this.esRowSetPrototype.putHiddenProperty("release", new RowSetRelease("release", evaluator, functionPrototype));
        this.esRowSetPrototype.putHiddenProperty("next", new RowSetNext("next", evaluator, functionPrototype));
        this.esRowSetPrototype.putHiddenProperty("getColumnCount", new RowSetGetColumnCount("getColumnCount", evaluator, functionPrototype));
        this.esRowSetPrototype.putHiddenProperty("getColumnName", new RowSetGetColumnName("getColumnName", evaluator, functionPrototype));
        this.esRowSetPrototype.putHiddenProperty("getColumnItem", new RowSetGetColumnItem("getColumnItem", evaluator, functionPrototype));
        this.esRowSetPrototype.putHiddenProperty("getColumnDatatypeNumber", new RowSetGetColumnDatatypeNumber("getColumnDatatypeNumber", evaluator, functionPrototype));
        this.esRowSetPrototype.putHiddenProperty("getColumnDatatypeName", new RowSetGetColumnDatatypeName("getColumnDatatypeName", evaluator, functionPrototype));
        this.esRowSetPrototype.putHiddenProperty("hasMoreRows", new RowSetHasMoreRows("hasMoreRows", evaluator, functionPrototype));
        this.esRowSetPrototype.putHiddenProperty("getMetaData", new RowSetGetMetaData("getMetaData", evaluator, functionPrototype));
        globalObject.putHiddenProperty("Database", globalObjectDatabase);
    }

    class GlobalObjectDatabase
    extends BuiltinFunctionObject {
        GlobalObjectDatabase(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            return this.doConstruct(eSObject, eSValueArray);
        }

        public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESDatabase eSDatabase = null;
            if (eSValueArray.length == 0) {
                throw new EcmaScriptException("Database requires 1 or 2 arguments");
            }
            if (eSValueArray.length == 1) {
                eSDatabase = new ESDatabase(Database.this.esDatabasePrototype, this.evaluator, Database.this.esRowSetPrototype, eSValueArray[0].toString());
            } else if (eSValueArray.length > 1) {
                eSDatabase = new ESDatabase(Database.this.esDatabasePrototype, this.evaluator, Database.this.esRowSetPrototype, eSValueArray[0].toString(), eSValueArray[1].toString());
            }
            return eSDatabase;
        }
    }

    class DatabaseGetLastError
    extends BuiltinFunctionObject {
        DatabaseGetLastError(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESDatabase eSDatabase = (ESDatabase)eSObject;
            return eSDatabase.getLastError();
        }
    }

    class DatabaseRelease
    extends BuiltinFunctionObject {
        DatabaseRelease(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESDatabase eSDatabase = (ESDatabase)eSObject;
            return eSDatabase.release();
        }
    }

    class DatabaseConnect
    extends BuiltinFunctionObject {
        DatabaseConnect(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESDatabase eSDatabase = (ESDatabase)eSObject;
            return eSDatabase.connect(eSValueArray);
        }
    }

    class DatabaseDisconnect
    extends BuiltinFunctionObject {
        DatabaseDisconnect(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESDatabase eSDatabase = (ESDatabase)eSObject;
            return eSDatabase.disconnect();
        }
    }

    class DatabaseExecuteRetrieval
    extends BuiltinFunctionObject {
        DatabaseExecuteRetrieval(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESDatabase eSDatabase = (ESDatabase)eSObject;
            return eSDatabase.executeRetrieval(eSValueArray);
        }
    }

    class DatabaseExecuteCommand
    extends BuiltinFunctionObject {
        DatabaseExecuteCommand(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESDatabase eSDatabase = (ESDatabase)eSObject;
            return eSDatabase.executeCommand(eSValueArray);
        }
    }

    class DatabaseGetMetaData
    extends BuiltinFunctionObject {
        DatabaseGetMetaData(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESDatabase eSDatabase = (ESDatabase)eSObject;
            return new ESWrapper(eSDatabase.getMetaData(), this.evaluator);
        }
    }

    class RowSetRelease
    extends BuiltinFunctionObject {
        RowSetRelease(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESRowSet eSRowSet = (ESRowSet)eSObject;
            return eSRowSet.release();
        }
    }

    class RowSetNext
    extends BuiltinFunctionObject {
        RowSetNext(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESRowSet eSRowSet = (ESRowSet)eSObject;
            return eSRowSet.next();
        }
    }

    class RowSetGetColumnCount
    extends BuiltinFunctionObject {
        RowSetGetColumnCount(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESRowSet eSRowSet = (ESRowSet)eSObject;
            return new ESNumber(eSRowSet.getColumnCount());
        }
    }

    class RowSetGetColumnName
    extends BuiltinFunctionObject {
        RowSetGetColumnName(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESRowSet eSRowSet = (ESRowSet)eSObject;
            if (eSValueArray.length < 1) {
                throw new EcmaScriptException("Missing parameter in function " + this);
            }
            int n = eSValueArray[0].toUInt32();
            String string = eSRowSet.getColumnName(n);
            if (string == null) {
                return ESUndefined.theUndefined;
            }
            return new ESString(string);
        }
    }

    class RowSetGetColumnItem
    extends BuiltinFunctionObject {
        RowSetGetColumnItem(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESRowSet eSRowSet = (ESRowSet)eSObject;
            if (eSValueArray.length < 1) {
                throw new EcmaScriptException("Missing parameter in function " + this);
            }
            String string = eSValueArray[0].toString();
            return eSRowSet.getColumnItem(string);
        }
    }

    class RowSetGetColumnDatatypeNumber
    extends BuiltinFunctionObject {
        RowSetGetColumnDatatypeNumber(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESRowSet eSRowSet = (ESRowSet)eSObject;
            if (eSValueArray.length < 1) {
                throw new EcmaScriptException("Missing parameter in function " + this);
            }
            int n = eSValueArray[0].toUInt32();
            return new ESNumber(eSRowSet.getColumnDatatypeNumber(n));
        }
    }

    class RowSetGetColumnDatatypeName
    extends BuiltinFunctionObject {
        RowSetGetColumnDatatypeName(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESRowSet eSRowSet = (ESRowSet)eSObject;
            if (eSValueArray.length < 1) {
                throw new EcmaScriptException("Missing parameter in function " + this);
            }
            int n = eSValueArray[0].toUInt32();
            String string = eSRowSet.getColumnDatatypeName(n);
            if (string == null) {
                return ESUndefined.theUndefined;
            }
            return new ESString(string);
        }
    }

    class RowSetHasMoreRows
    extends BuiltinFunctionObject {
        RowSetHasMoreRows(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESRowSet eSRowSet = (ESRowSet)eSObject;
            return ESBoolean.makeBoolean(eSRowSet.hasMoreRows());
        }
    }

    class RowSetGetMetaData
    extends BuiltinFunctionObject {
        RowSetGetMetaData(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            Database.this = Database.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESRowSet eSRowSet = (ESRowSet)eSObject;
            return new ESWrapper(eSRowSet.getMetaData(), this.evaluator);
        }
    }
}

