/*
 * Decompiled with CFR 0.152.
 */
package FESI.Exceptions;

import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.EvaluationSource;
import FESI.Parser.EcmaScriptConstants;
import FESI.Parser.TokenMgrError;

public class EcmaScriptLexicalException
extends EcmaScriptException
implements EcmaScriptConstants {
    private TokenMgrError tokenMgrError;
    private EvaluationSource evaluationSource;

    public EcmaScriptLexicalException(TokenMgrError tokenMgrError, EvaluationSource evaluationSource) {
        super("Lexical error");
        this.tokenMgrError = tokenMgrError;
        this.evaluationSource = evaluationSource;
    }

    public int getLineNumber() {
        if (this.evaluationSource != null) {
            return this.evaluationSource.getLineNumber();
        }
        return -1;
    }

    public String getMessage() {
        String string = this.tokenMgrError.getMessage();
        string = String.valueOf(string) + EcmaScriptException.eol + this.evaluationSource;
        return string;
    }

    public boolean isIncomplete() {
        String string = this.tokenMgrError.getMessage();
        return string.indexOf(".  Probably unclosed comment.") != -1;
    }
}

