/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;

public class MathObject
extends ObjectPrototype {
    private FunctionPrototype fp;

    private MathObject(ESObject eSObject, Evaluator evaluator, FunctionPrototype functionPrototype) throws EcmaScriptException {
        super(eSObject, evaluator);
        this.putHiddenProperty("E", new ESNumber(Math.E));
        this.putHiddenProperty("LN10", new ESNumber(Math.log(10.0)));
        this.putHiddenProperty("LN2", new ESNumber(Math.log(2.0)));
        this.putHiddenProperty("LOG2E", new ESNumber(1.0 / Math.log(2.0)));
        this.putHiddenProperty("LOG10E", new ESNumber(1.0 / Math.log(10.0)));
        this.putHiddenProperty("PI", new ESNumber(Math.PI));
        this.putHiddenProperty("SQRT1_2", new ESNumber(1.0 / Math.sqrt(2.0)));
        this.putHiddenProperty("SQRT2", new ESNumber(Math.sqrt(2.0)));
        this.putHiddenProperty("abs", new 1(this, "abs", evaluator, functionPrototype));
        this.putHiddenProperty("acos", new 2(this, "acos", evaluator, functionPrototype));
        this.putHiddenProperty("asin", new 3(this, "asin", evaluator, functionPrototype));
        this.putHiddenProperty("atan", new 4(this, "atan", evaluator, functionPrototype));
        this.putHiddenProperty("atan2", new 5(this, "atan2", evaluator, functionPrototype));
        this.putHiddenProperty("ceil", new 6(this, "ceil", evaluator, functionPrototype));
        this.putHiddenProperty("cos", new 7(this, "cos", evaluator, functionPrototype));
        this.putHiddenProperty("exp", new 8(this, "exp", evaluator, functionPrototype));
        this.putHiddenProperty("floor", new 9(this, "floor", evaluator, functionPrototype));
        this.putHiddenProperty("log", new 10(this, "log", evaluator, functionPrototype));
        this.putHiddenProperty("max", new 11(this, "max", evaluator, functionPrototype));
        this.putHiddenProperty("min", new 12(this, "min", evaluator, functionPrototype));
        this.putHiddenProperty("pow", new 13(this, "pow", evaluator, functionPrototype));
        this.putHiddenProperty("random", new 14(this, "random", evaluator, functionPrototype));
        this.putHiddenProperty("round", new 15(this, "round", evaluator, functionPrototype));
        this.putHiddenProperty("sin", new 16(this, "sin", evaluator, functionPrototype));
        this.putHiddenProperty("sqrt", new 17(this, "sqrt", evaluator, functionPrototype));
        this.putHiddenProperty("tan", new 18(this, "tan", evaluator, functionPrototype));
    }

    public String getESClassName() {
        return "Math";
    }

    public static ESObject makeMathObject(Evaluator evaluator, ObjectPrototype objectPrototype, FunctionPrototype functionPrototype) {
        try {
            MathObject mathObject = new MathObject((ESObject)objectPrototype, evaluator, functionPrototype);
            return mathObject;
        }
        catch (EcmaScriptException ecmaScriptException) {
            ecmaScriptException.printStackTrace();
            throw new ProgrammingError(ecmaScriptException.getMessage());
        }
    }

    private final class 1
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.abs(d);
        }

        /* synthetic */ 1(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 2
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.acos(d);
        }

        /* synthetic */ 2(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 3
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.asin(d);
        }

        /* synthetic */ 3(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 4
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.atan(d);
        }

        /* synthetic */ 4(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 5
    extends BuiltinMathFunctionTwo {
        public double applyMathFunction(double d, double d2) {
            return Math.atan2(d, d2);
        }

        /* synthetic */ 5(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 6
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.ceil(d);
        }

        /* synthetic */ 6(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 7
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.cos(d);
        }

        /* synthetic */ 7(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 8
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.exp(d);
        }

        /* synthetic */ 8(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 9
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.floor(d);
        }

        /* synthetic */ 9(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 10
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.log(d);
        }

        /* synthetic */ 10(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 11
    extends BuiltinMathFunctionTwo {
        public double applyMathFunction(double d, double d2) {
            return Math.max(d, d2);
        }

        /* synthetic */ 11(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 12
    extends BuiltinMathFunctionTwo {
        public double applyMathFunction(double d, double d2) {
            return Math.min(d, d2);
        }

        /* synthetic */ 12(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 13
    extends BuiltinMathFunctionTwo {
        public double applyMathFunction(double d, double d2) {
            double d3 = Double.NaN;
            try {
                d3 = Math.pow(d, d2);
            }
            catch (ArithmeticException arithmeticException) {}
            return d3;
        }

        /* synthetic */ 13(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 14
    extends BuiltinMathFunctionZero {
        public double applyMathFunction() {
            return Math.random();
        }

        /* synthetic */ 14(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 15
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.round(d);
        }

        /* synthetic */ 15(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 16
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.sin(d);
        }

        /* synthetic */ 16(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 17
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.sqrt(d);
        }

        /* synthetic */ 17(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    private final class 18
    extends BuiltinMathFunctionOne {
        public double applyMathFunction(double d) {
            return Math.tan(d);
        }

        /* synthetic */ 18(MathObject mathObject, String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(string, evaluator, functionPrototype);
        }
    }

    abstract class BuiltinMathFunctionZero
    extends BuiltinFunctionObject {
        BuiltinMathFunctionZero(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 0);
            MathObject.this = MathObject.this;
        }

        abstract double applyMathFunction();

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            return new ESNumber(this.applyMathFunction());
        }
    }

    abstract class BuiltinMathFunctionOne
    extends BuiltinFunctionObject {
        BuiltinMathFunctionOne(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            MathObject.this = MathObject.this;
        }

        abstract double applyMathFunction(double var1);

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            double d;
            double d2 = d = eSValueArray.length > 0 ? eSValueArray[0].doubleValue() : Double.NaN;
            if (Double.isNaN(d)) {
                return new ESNumber(Double.NaN);
            }
            return new ESNumber(this.applyMathFunction(d));
        }
    }

    abstract class BuiltinMathFunctionTwo
    extends BuiltinFunctionObject {
        BuiltinMathFunctionTwo(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 2);
            MathObject.this = MathObject.this;
        }

        abstract double applyMathFunction(double var1, double var3);

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            double d;
            if (eSValueArray.length < 2) {
                throw new EcmaScriptException("Missing parameter in function " + this);
            }
            double d2 = eSValueArray.length > 0 ? eSValueArray[0].doubleValue() : Double.NaN;
            double d3 = d = eSValueArray.length > 1 ? eSValueArray[1].doubleValue() : Double.NaN;
            if (Double.isNaN(d2) || Double.isNaN(d)) {
                return new ESNumber(Double.NaN);
            }
            return new ESNumber(this.applyMathFunction(d2, d));
        }
    }
}

