/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESValue;
import FESI.Data.StringPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;

public final class ESString
extends ESPrimitive {
    private String string;

    public ESString(String string) {
        this.string = string;
    }

    public String toDetailString() {
        return "ES:\"" + this.string + "\"";
    }

    public int getTypeOf() {
        return 5;
    }

    public String getTypeofString() {
        return "string";
    }

    public String toString() {
        return this.string;
    }

    public int getStringLength() {
        return this.string.length();
    }

    public double doubleValue() {
        double d = Double.NaN;
        try {
            d = Double.valueOf(this.string);
        }
        catch (NumberFormatException numberFormatException) {}
        return d;
    }

    public boolean booleanValue() {
        return this.string.length() > 0;
    }

    public ESValue toESString() {
        return this;
    }

    public ESValue toESObject(Evaluator evaluator) throws EcmaScriptException {
        StringPrototype stringPrototype = null;
        ESObject eSObject = evaluator.getStringPrototype();
        stringPrototype = new StringPrototype(eSObject, evaluator);
        stringPrototype.value = this;
        return stringPrototype;
    }

    public Object toJavaObject() {
        return this.string;
    }

    public boolean isStringValue() {
        return true;
    }
}

