/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.JSWrapper;
import FESI.Data.ValueDescription;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.FesiHashtable;
import FESI.Interpreter.ScopeChain;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public abstract class ESObject
extends ESValue {
    protected FesiHashtable properties;
    protected Evaluator evaluator;
    private ESObject prototype;
    private static final String TOSTRINGstring = "toString".intern();
    private static final int TOSTRINGhash = TOSTRINGstring.hashCode();
    private static final String VALUEOFstring = "valueOf".intern();
    private static final int VALUEOFhash = VALUEOFstring.hashCode();

    protected ESObject(ESObject eSObject, Evaluator evaluator) {
        this.prototype = eSObject;
        this.properties = new FesiHashtable();
        this.evaluator = evaluator;
    }

    protected ESObject(ESObject eSObject, Evaluator evaluator, int n) {
        this.prototype = eSObject;
        this.properties = new FesiHashtable(n);
        this.evaluator = evaluator;
    }

    public final Evaluator getEvaluator() {
        return this.evaluator;
    }

    public final boolean isPrimitive() {
        return false;
    }

    public ESObject getPrototype() {
        return this.prototype;
    }

    public String getESClassName() {
        return "Object";
    }

    public int getTypeOf() {
        return 6;
    }

    public ESValue getPropertyInScope(String string, ScopeChain scopeChain, int n) throws EcmaScriptException {
        ESValue eSValue = this.properties.get(string, n);
        if (eSValue == null) {
            if (scopeChain == null) {
                throw new EcmaScriptException("global variable '" + string + "' does not have a value");
            }
            eSValue = scopeChain.getValue(string, n);
        }
        return eSValue;
    }

    public ESValue getProperty(String string, int n) throws EcmaScriptException {
        ESValue eSValue = this.properties.get(string, n);
        if (eSValue == null) {
            eSValue = this.prototype == null ? ESUndefined.theUndefined : this.prototype.getProperty(string, n);
        }
        return eSValue;
    }

    public ESValue getProperty(int n) throws EcmaScriptException {
        String string = Integer.toString(n);
        return this.getProperty(string, string.hashCode());
    }

    public boolean hasProperty(String string, int n) throws EcmaScriptException {
        boolean bl = this.properties.containsKey(string, n);
        if (!bl && this.prototype != null) {
            bl = this.prototype.hasProperty(string, n);
        }
        return bl;
    }

    public boolean isHiddenProperty(String string, int n) {
        return this.properties.isHidden(string, n);
    }

    public boolean isDirectEnumerator() {
        return false;
    }

    public Enumeration getProperties() {
        return new 1();
    }

    public Enumeration getAllProperties() {
        return new 2();
    }

    public void putProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
        this.properties.put(string, n, false, false, eSValue);
    }

    public void putProperty(int n, ESValue eSValue) throws EcmaScriptException {
        String string = Integer.toString(n);
        this.putProperty(string, eSValue, string.hashCode());
    }

    public void putHiddenProperty(String string, ESValue eSValue) throws EcmaScriptException {
        string = string.intern();
        int n = string.hashCode();
        this.properties.put(string, n, true, false, eSValue);
    }

    public boolean deleteProperty(String string, int n) throws EcmaScriptException {
        this.properties.remove(string, n);
        return true;
    }

    public ESValue getDefaultValue(int n) throws EcmaScriptException {
        ESValue eSValue = null;
        ESValue eSValue2 = null;
        if (n == 5) {
            eSValue2 = this.getProperty(TOSTRINGstring, TOSTRINGhash);
            if (eSValue2 instanceof ESObject && (eSValue = eSValue2.callFunction(this, new ESValue[0])).isPrimitive()) {
                return eSValue;
            }
            eSValue2 = this.getProperty(VALUEOFstring, VALUEOFhash);
            if (eSValue2 instanceof ESObject && (eSValue = eSValue2.callFunction(this, new ESValue[0])).isPrimitive()) {
                return eSValue;
            }
            throw new EcmaScriptException("No default value for " + super.toString() + " and hint " + n);
        }
        if (n == 4) {
            eSValue2 = this.getProperty(VALUEOFstring, VALUEOFhash);
            if (eSValue2 instanceof ESObject && (eSValue = eSValue2.callFunction(this, new ESValue[0])).isPrimitive()) {
                return eSValue;
            }
            eSValue2 = this.getProperty(TOSTRINGstring, TOSTRINGhash);
            if (eSValue2 instanceof ESObject && (eSValue = eSValue2.callFunction(this, new ESValue[0])).isPrimitive()) {
                return eSValue;
            }
        }
        throw new EcmaScriptException("No default value for " + this + " and hint " + n);
    }

    public ESValue getDefaultValue() throws EcmaScriptException {
        return this.getDefaultValue(4);
    }

    public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        throw new EcmaScriptException("No function defined on: " + this);
    }

    public ESValue doIndirectCall(Evaluator evaluator, String string, ESValue[] eSValueArray) throws EcmaScriptException, NoSuchMethodException {
        ESValue eSValue = this.getProperty(string, string.hashCode());
        if (eSValue instanceof ESUndefined) {
            throw new EcmaScriptException("The function '" + string + "' is not defined for object '" + this.toString() + "'");
        }
        return eSValue.callFunction(this, eSValueArray);
    }

    public ESValue doIndirectCallInScope(Evaluator evaluator, ScopeChain scopeChain, ESObject eSObject, String string, int n, ESValue[] eSValueArray) throws EcmaScriptException {
        ESValue eSValue = this.properties.get(string, n);
        if (eSValue == null) {
            if (scopeChain == null) {
                throw new EcmaScriptException("no global function named '" + string + "'");
            }
            return scopeChain.doIndirectCall(evaluator, eSObject, string, n, eSValueArray);
        }
        return eSValue.callFunction(eSObject, eSValueArray);
    }

    public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        throw new EcmaScriptException("No constructor defined on: " + this);
    }

    public double doubleValue() throws EcmaScriptException {
        ESValue eSValue = ESUndefined.theUndefined;
        double d = Double.NaN;
        try {
            eSValue = this.toESPrimitive(4);
            d = eSValue.doubleValue();
        }
        catch (EcmaScriptException ecmaScriptException) {
            throw new ProgrammingError(ecmaScriptException.getMessage());
        }
        return d;
    }

    public boolean booleanValue() throws EcmaScriptException {
        return true;
    }

    public String toString() {
        ESValue eSValue = ESUndefined.theUndefined;
        String string = null;
        try {
            eSValue = this.toESPrimitive(5);
        }
        catch (EcmaScriptException ecmaScriptException) {
            return this.toDetailString();
        }
        string = eSValue.toString();
        return string;
    }

    public final ESValue toESObject(Evaluator evaluator) throws EcmaScriptException {
        return this;
    }

    public final ESValue toESPrimitive(int n) throws EcmaScriptException {
        return this.getDefaultValue(n);
    }

    public final ESValue toESPrimitive() throws EcmaScriptException {
        return this.getDefaultValue();
    }

    public Object toJavaObject() {
        return new JSWrapper(this, this.evaluator);
    }

    public String getTypeofString() {
        return "object";
    }

    public String toDetailString() {
        return "ES:[" + this.getESClassName() + "]";
    }

    public boolean isComposite() {
        return true;
    }

    public String[] getSpecialPropertyNames() {
        return new String[0];
    }

    public Enumeration getAllDescriptions() {
        return new 3();
    }

    public ValueDescription getDescription(String string) {
        return new ValueDescription(string, "OBJECT", this.toString());
    }

    private final class 1
    implements Enumeration {
        Enumeration props;
        String currentKey;
        int currentHash;
        boolean inside;

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            if (this.currentKey == null) ** GOTO lbl7
            return true;
lbl-1000:
            // 1 sources

            {
                this.currentKey = (String)this.props.nextElement();
                this.currentHash = this.currentKey.hashCode();
                if (this.inside != false ? ESObject.this.properties.containsKey(this.currentKey, this.currentHash) != false : ESObject.this.isHiddenProperty(this.currentKey, this.currentHash) != false) continue;
                return true;
lbl7:
                // 2 sources

                ** while (this.props.hasMoreElements())
            }
lbl8:
            // 1 sources

            if (!this.inside && ESObject.access$0(ESObject.this) != null) {
                this.inside = true;
                this.props = ESObject.access$0(ESObject.this).getProperties();
                while (this.props.hasMoreElements()) {
                    this.currentKey = (String)this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    if (ESObject.this.properties.containsKey(this.currentKey, this.currentHash)) continue;
                    return true;
                }
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String string = this.currentKey;
                this.currentKey = null;
                return string;
            }
            throw new NoSuchElementException();
        }

        /* synthetic */ 1() {
            this.props = ESObject.this.properties.keys();
            this.inside = false;
        }
    }

    private final class 2
    implements Enumeration {
        String[] specialProperties;
        int specialEnumerator;
        Enumeration props;
        String currentKey;
        int currentHash;
        boolean inside;

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            if (this.currentKey != null) {
                return true;
            }
            if (this.specialEnumerator >= this.specialProperties.length) ** GOTO lbl12
            this.currentKey = this.specialProperties[this.specialEnumerator];
            this.currentHash = this.currentKey.hashCode();
            ++this.specialEnumerator;
            return true;
lbl-1000:
            // 1 sources

            {
                this.currentKey = (String)this.props.nextElement();
                this.currentHash = this.currentKey.hashCode();
                if (this.inside && ESObject.this.properties.containsKey(this.currentKey, this.currentHash)) continue;
                return true;
lbl12:
                // 2 sources

                ** while (this.props.hasMoreElements())
            }
lbl13:
            // 1 sources

            if (!this.inside && ESObject.access$0(ESObject.this) != null) {
                this.inside = true;
                this.props = ESObject.access$0(ESObject.this).getProperties();
                while (this.props.hasMoreElements()) {
                    this.currentKey = (String)this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    if (ESObject.this.properties.containsKey(this.currentKey, this.currentHash)) continue;
                    return true;
                }
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String string = this.currentKey;
                this.currentKey = null;
                return string;
            }
            throw new NoSuchElementException();
        }

        /* synthetic */ 2() {
            this.specialProperties = ESObject.this.getSpecialPropertyNames();
            this.props = ESObject.this.properties.keys();
            this.inside = false;
        }
    }

    private final class 3
    implements Enumeration {
        String[] specialProperties;
        int specialEnumerator;
        Enumeration props;
        String currentKey;
        int currentHash;
        boolean inside;
        boolean inSpecial;

        public boolean hasMoreElements() {
            if (this.currentKey != null) {
                return true;
            }
            if (this.specialEnumerator < this.specialProperties.length) {
                this.currentKey = this.specialProperties[this.specialEnumerator];
                this.currentHash = this.currentKey.hashCode();
                ++this.specialEnumerator;
                return true;
            }
            this.inSpecial = false;
            if (this.props.hasMoreElements()) {
                this.currentKey = (String)this.props.nextElement();
                this.currentHash = this.currentKey.hashCode();
                return true;
            }
            if (!this.inside && ESObject.this.prototype != null) {
                this.inside = true;
                this.props = ESObject.this.prototype.getProperties();
                if (this.props.hasMoreElements()) {
                    this.currentKey = (String)this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    return true;
                }
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String string = this.currentKey;
                int n = string.hashCode();
                this.currentKey = null;
                ESValue eSValue = null;
                try {
                    eSValue = ESObject.this.getProperty(string, n);
                }
                catch (EcmaScriptException ecmaScriptException) {
                    throw new ProgrammingError("Unexpected exception " + ecmaScriptException);
                }
                String string2 = this.inSpecial ? "HIDDEN" : (this.inside && ESObject.this.properties.containsKey(string, n) ? "INVISIBLE" : (ESObject.this.isHiddenProperty(string, n) ? "HIDDEN" : "VISIBLE"));
                string2 = String.valueOf(string2) + (this.inside ? " PROTOTYPE" : " OBJECT");
                string2 = String.valueOf(string2) + " PROPERTY";
                return new ValueDescription(string, string2, eSValue.toString());
            }
            throw new NoSuchElementException();
        }

        /* synthetic */ 3() {
            this.specialProperties = ESObject.this.getSpecialPropertyNames();
            this.props = ESObject.this.properties.keys();
            this.inside = false;
            this.inSpecial = true;
        }
    }
}

