/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;

public final class ESArguments
extends ESObject {
    private ESObject callee;
    private int length;
    String[] argumentNames;

    private ESArguments(ESObject eSObject, Evaluator evaluator, String[] stringArray, int n, ESObject eSObject2) {
        super(eSObject, evaluator, n < 3 ? 5 : 11);
        this.argumentNames = stringArray;
        this.length = n;
        this.callee = eSObject2;
    }

    public ESValue getPropertyInScope(String string, ScopeChain scopeChain, int n) throws EcmaScriptException {
        if (string.equals("callee")) {
            return this.callee;
        }
        if (string.equals("arguments")) {
            return this;
        }
        if (string.equals("length")) {
            return new ESNumber(this.length);
        }
        if (super.hasProperty(string, n)) {
            return super.getProperty(string, n);
        }
        int n2 = -1;
        try {
            char c = string.charAt(0);
            if (c >= '0' && c <= '9') {
                n2 = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        if (n2 >= 0 && n2 < this.argumentNames.length) {
            string = this.argumentNames[n2];
            n = string.hashCode();
            return super.getProperty(string, n);
        }
        if (scopeChain == null) {
            throw new EcmaScriptException("global variable '" + string + "' does not have a value");
        }
        return scopeChain.getValue(string, n);
    }

    public ESValue doIndirectCallInScope(Evaluator evaluator, ScopeChain scopeChain, ESObject eSObject, String string, int n, ESValue[] eSValueArray) throws EcmaScriptException {
        if (string.equals("callee")) {
            return this.callee.callFunction(eSObject, eSValueArray);
        }
        return super.doIndirectCallInScope(evaluator, scopeChain, eSObject, string, n, eSValueArray);
    }

    public ESValue getProperty(String string, int n) throws EcmaScriptException {
        if (string.equals("callee")) {
            return this.callee;
        }
        if (string.equals("arguments")) {
            return this;
        }
        if (string.equals("length")) {
            return new ESNumber(this.length);
        }
        if (super.hasProperty(string, n)) {
            return super.getProperty(string, n);
        }
        int n2 = -1;
        try {
            char c = string.charAt(0);
            if (c >= '0' && c <= '9') {
                n2 = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (n2 >= 0 && n2 < this.argumentNames.length) {
            string = this.argumentNames[n2];
            n = string.hashCode();
        }
        return super.getProperty(string, n);
    }

    public ESValue getProperty(int n) throws EcmaScriptException {
        if (n >= 0 && n < this.argumentNames.length) {
            String string = this.argumentNames[n];
            return super.getProperty(string, string.hashCode());
        }
        String string = Integer.toString(n);
        return this.getProperty(string, string.hashCode());
    }

    public boolean hasProperty(String string, int n) throws EcmaScriptException {
        if (string.equals("callee")) {
            return true;
        }
        if (string.equals("arguments")) {
            return true;
        }
        if (string.equals("length")) {
            return true;
        }
        if (super.hasProperty(string, n)) {
            return true;
        }
        int n2 = -1;
        try {
            char c = string.charAt(0);
            if (c >= '0' && c <= '9') {
                n2 = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return n2 >= 0 && n2 < this.argumentNames.length;
    }

    public static ESArguments makeNewESArguments(Evaluator evaluator, ESObject eSObject, String[] stringArray, ESValue[] eSValueArray) {
        ObjectPrototype objectPrototype = (ObjectPrototype)evaluator.getObjectPrototype();
        ESArguments eSArguments = new ESArguments(objectPrototype, evaluator, stringArray, Math.max(eSValueArray.length, stringArray.length), eSObject);
        try {
            int n = 0;
            while (n < eSValueArray.length) {
                ESUndefined eSUndefined;
                ESValue eSValue = eSUndefined = n < eSValueArray.length ? eSValueArray[n] : ESUndefined.theUndefined;
                if (n < stringArray.length) {
                    eSArguments.putProperty(stringArray[n], eSUndefined, stringArray[n].hashCode());
                } else {
                    String string = Integer.toString(n);
                    eSArguments.putProperty(string, eSUndefined, string.hashCode());
                }
                ++n;
            }
        }
        catch (EcmaScriptException ecmaScriptException) {
            ecmaScriptException.printStackTrace();
            throw new ProgrammingError(ecmaScriptException.getMessage());
        }
        return eSArguments;
    }

    public boolean deleteProperty(String string, int n) throws EcmaScriptException {
        return !this.hasProperty(string, n);
    }

    public ESValue getDefaultValue(Evaluator evaluator, int n) throws EcmaScriptException {
        return this.callee.getDefaultValue(n);
    }

    public int getTypeOf() {
        return this.callee.getTypeOf();
    }

    public Object toJavaObject() {
        return this.callee.toJavaObject();
    }

    public String getTypeofString() {
        return this.callee.getTypeofString();
    }

    public String toString() {
        return this.callee.toString();
    }

    public String toDetailString() {
        return this.callee.toDetailString();
    }

    public String[] getSpecialPropertyNames() {
        String[] stringArray = new String[]{"arguments", "callee", "length"};
        return stringArray;
    }
}

