/*
 * Decompiled with CFR 0.152.
 */
package twz1.jdbc.mysql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;
import twz1.jdbc.mysql.RSMd;
import twz1.jdbc.mysql.jdbcMysqlBag;
import twz1.jdbc.mysql.jdbcMysqlBase;
import twz1.jdbc.mysql.jdbcMysqlConnex;
import twz1.jdbc.mysql.jdbcMysqlMutex;
import twz1.jdbc.mysql.jdbcMysqlRSet;
import twz1.jdbc.mysql.jdbcMysqlResult;
import twz1.jdbc.mysql.jdbcMysqlURL;

public class jdbcMysqlStmt
implements Statement {
    jdbcMysqlConnex cx;
    int myOID = ++jdbcMysqlBase.xoid;
    byte[] lastExecuted;
    String commandWord;
    int commandValue;
    int maxRows;
    int maxFieldSize;
    jdbcMysqlBag inBag;
    jdbcMysqlBag outBag;
    boolean open;
    int status;
    jdbcMysqlMutex guard;
    int lTimeout;
    long lastInsertID;
    jdbcMysqlResult qResult;
    boolean rsmdXcept;
    boolean rsLock;
    boolean autoReX;
    static final int QTYPE_EU = 1;
    static final int QTYPE_EQ = 2;
    static final int QTYPE_EX = 3;
    static final int C_CLOSE = 1;
    static final int C_GETMAXFIELDSIZE = 2;
    static final int C_SETMAXFIELDSIZE = 3;
    static final int C_GETMAXROWS = 4;
    static final int C_SETMAXROWS = 5;
    static final int C_SETESCAPEPROCESSING = 6;
    static final int C_GETQUERYTIMEOUT = 7;
    static final int C_SETQUERYTIMEOUT = 8;
    static final int C_CANCEL = 9;
    static final int C_GETWARNINGS = 10;
    static final int C_CLEARWARNINGS = 11;
    static final int C_SETCURSORNAME = 12;
    static final int C_GETUPDATECOUNT = 13;
    static final int C_GETMORERESULTS = 14;
    static final int C_SETNULL = 15;
    static final int C_SETBOOLEAN = 16;
    static final int C_SETBYTE = 17;
    static final int C_SETSHORT = 18;
    static final int C_SETINT = 19;
    static final int C_SETLONG = 20;
    static final int C_SETFLOAT = 21;
    static final int C_SETDOUBLE = 22;
    static final int C_SETSTRING = 23;
    static final int C_SETBYTES = 24;
    static final int C_SETDATE = 25;
    static final int C_SETTIME = 26;
    static final int C_SETTIMESTAMP = 27;
    static final int C_SETASCIISTREAM = 28;
    static final int C_SETBINARYSTREAM = 29;
    static final int C_SETUNICODESTREAM = 30;
    static final int C_SETBIGDECIMAL = 31;
    static final int C_SETOBJECT = 32;
    static final int C_CLEARPARAMETERS = 33;
    static final String[] apis = new String[]{"", "close()", "getMaxFieldSize()", "setMaxFieldSize()", "getMaxRows()", "setMaxRows()", "setEscapeProcessing()", "getQueryTimeout()", "setQueryTimeout()", "cancel()", "getWarnings()", "clearWarnings()", "setCursorName()", "getUpdateCount()", "getMoreResults()", "setNull()", "setBoolean()", "setByte()", "setShort()", "setInt()", "setLong()", "setFloat()", "setDouble()", "setString()", "setBytes()", "setDate()", "setTime()", "setTimestamp()", "setAsciiStream()", "setBinaryStream()", "setUnicodeStream()", "setBigDecimal()", "setObject()", "clearParameters()"};
    static final String[] errs = new String[]{"E0600 No argument to execute.", "E0601 Invalid command to executeUpdate() -", "E0602 Error in executeUpdate() --", "E0603 executeUpdate() error --", "E0604 Bizarre status code from executeUpdate() - ", "E0605 Invalid command to executeQuery() -", "E0606 executeQuery() error --", "E0607 Thread guard timed out.", "E0608 Unexpected result from mutex.", "E0609 Error in executeUpdate()", "E0610 Error in executeQuery()", "E0611 Error from db for executeQuery() -", "E0612 Unexpected status in executeQuery() - ", "E0613 Invalid command to execute() -", "E0614 execute() error --", "E0615 Error handling API method --", "E0616 Error: statement is closed.", "E0617 Invalid value specified.", "E0618 Not supported.", "P0619 Progerr sAction called with bad option.", "E0620 Invalid property value", "E0621 Prepared statement may not begin with a \"?\".", "E0622 Prepared statement requires a statement to prepare.", "E0623 Error in Prepared Statement API method --", "E0624 Parameter value is out of range.", "P0625 Prepared Statement command value error. -- ", "E0626 Error setting Parameters for execute."};

    jdbcMysqlStmt(jdbcMysqlConnex jdbcMysqlConnex2) throws SQLException {
        this.cx = jdbcMysqlConnex2;
        this.lastExecuted = null;
        this.maxRows = Integer.MAX_VALUE;
        this.maxFieldSize = 65535;
        Object object = this.cx;
        if (!((jdbcMysqlConnex)object).open) {
            ((jdbcMysqlConnex)object).errHandlerL(13, "getInBag()");
        }
        this.inBag = ((jdbcMysqlConnex)object).inBag;
        object = this.cx;
        if (!((jdbcMysqlConnex)object).open) {
            ((jdbcMysqlConnex)object).errHandlerL(13, "getOutBag()");
        }
        this.outBag = ((jdbcMysqlConnex)object).outBag;
        this.open = true;
        this.guard = new jdbcMysqlMutex();
        this.lTimeout = this.cx.connexTimeout;
        this.qResult = new jdbcMysqlResult(this, this.cx);
        this.lastInsertID = -1L;
        jdbcMysqlConnex jdbcMysqlConnex3 = this.cx;
        jdbcMysqlURL jdbcMysqlURL2 = jdbcMysqlConnex3.curl;
        object = (String)jdbcMysqlURL2.values.get("maxRows");
        int n = jdbcMysqlBase.intValue((String)object, -1, -2);
        if (n == 0) {
            this.maxRows = Integer.MAX_VALUE;
        }
        if (n == -2) {
            this.errHandlerM(20, "maxRows");
        }
        if (n > 0) {
            this.maxRows = n;
        }
        jdbcMysqlConnex3 = this.cx;
        jdbcMysqlURL2 = jdbcMysqlConnex3.curl;
        object = (String)jdbcMysqlURL2.values.get("maxField");
        n = jdbcMysqlBase.intValue((String)object, -1, -2);
        if (n == -2) {
            this.errHandlerM(20, "maxField");
        }
        if (n > 0) {
            this.maxFieldSize = n;
        }
        jdbcMysqlConnex3 = this.cx;
        jdbcMysqlURL2 = jdbcMysqlConnex3.curl;
        object = (String)jdbcMysqlURL2.values.get("rsmdXcept");
        if (jdbcMysqlBase.boolValue((String)object, 0, 0) == 1) {
            this.rsmdXcept = true;
        }
        jdbcMysqlConnex3 = this.cx;
        jdbcMysqlURL2 = jdbcMysqlConnex3.curl;
        object = (String)jdbcMysqlURL2.values.get("RSLock");
        this.rsLock = jdbcMysqlBase.boolValue((String)object, 0, 0) == 1;
        jdbcMysqlConnex3 = this.cx;
        jdbcMysqlURL2 = jdbcMysqlConnex3.curl;
        object = (String)jdbcMysqlURL2.values.get("autoReX");
        this.autoReX = jdbcMysqlBase.boolValue((String)object, 1, 0) == 1;
    }

    public int executeUpdate(String string) throws SQLException {
        int n = ++jdbcMysqlBase.xoid;
        boolean bl = false;
        int n2 = -1;
        try {
            bl = this.lock(true, n, this.lTimeout);
            this.qResult.clear();
            this.getCommandValue(string);
            if (this.commandValue < 100 || this.commandValue > 199) {
                this.errHandlerM(1, this.commandWord);
            }
            this.mExecUpdate(string.getBytes());
            n2 = this.qResult.getRows();
            bl = this.lock(false, n, this.lTimeout);
        }
        catch (Exception exception) {
            if (bl) {
                this.lock(false, n, this.lTimeout);
            }
            this.errHandlerE(9, exception);
        }
        return n2;
    }

    void mExecUpdate(byte[] byArray) throws SQLException {
        String string;
        int n;
        block9: {
            n = -1;
            string = null;
            if (this.commandValue == 190) {
                this.qResult.getResult(1, this.commandValue);
                return;
            }
            boolean bl = false;
            try {
                bl = this.cx.lock(true, this.myOID, this.lTimeout);
                this.mxEU(byArray);
                bl = this.cx.lock(false, this.myOID, 1);
            }
            catch (Exception exception) {
                boolean bl2 = false;
                if (this.cx.broken && this.autoReX) {
                    try {
                        this.cx.xOpen();
                        this.mxEU(byArray);
                        bl2 = true;
                    }
                    catch (Exception exception2) {}
                }
                if (bl) {
                    this.cx.lock(false, this.myOID, 2);
                }
                if (bl2) break block9;
                this.errHandlerE(2, exception);
            }
        }
        jdbcMysqlResult jdbcMysqlResult2 = this.qResult;
        n = jdbcMysqlResult2.lastStatus;
        if (n == 255) {
            jdbcMysqlResult2 = this.qResult;
            string = jdbcMysqlResult2.sMessage;
            this.errHandlerM(3, String.valueOf(String.valueOf(-1)) + " " + string);
        }
        if (n != 0) {
            this.errHandlerM(4, String.valueOf(n));
        }
    }

    private void mxEU(byte[] byArray) throws SQLException {
        jdbcMysqlBag jdbcMysqlBag2 = this.outBag;
        jdbcMysqlBag2.maxAt = 4;
        jdbcMysqlBag2.at = 4;
        jdbcMysqlBag2.seq = 0;
        this.outBag.iToB(3, 1);
        this.outBag.putZT(byArray);
        this.outBag.write();
        this.qResult.getResult(1, this.commandValue);
    }

    public ResultSet executeQuery(String string) throws SQLException {
        int n = ++jdbcMysqlBase.xoid;
        boolean bl = false;
        ResultSet resultSet = null;
        jdbcMysqlRSet jdbcMysqlRSet2 = null;
        try {
            bl = this.lock(true, n, this.lTimeout);
            this.getCommandValue(string);
            if (this.commandValue < 200 || this.commandValue > 399) {
                this.errHandlerM(5, this.commandWord);
            }
            this.qResult.clear();
            resultSet = this.mExecQuery(string.getBytes());
            if (resultSet != null) {
                jdbcMysqlRSet2 = (jdbcMysqlRSet)resultSet;
                jdbcMysqlRSet2.retrieved = true;
            }
            bl = this.lock(false, n, this.lTimeout);
        }
        catch (Exception exception) {
            if (bl) {
                this.lock(false, n, this.lTimeout);
            }
            this.errHandlerE(10, exception);
        }
        return resultSet;
    }

    ResultSet mExecQuery(byte[] byArray) throws SQLException {
        jdbcMysqlRSet jdbcMysqlRSet2;
        block8: {
            jdbcMysqlRSet2 = null;
            boolean bl = false;
            try {
                bl = this.cx.lock(true, this.myOID, this.lTimeout);
                jdbcMysqlRSet2 = this.mxEQ(byArray);
                if (this.qResult.cacheMode != 2) {
                    bl = this.cx.lock(false, this.myOID, 3);
                }
            }
            catch (Exception exception) {
                if (this.cx.broken) {
                    try {
                        this.cx.xOpen();
                        jdbcMysqlRSet2 = this.mxEQ(byArray);
                        if (this.qResult.cacheMode != 2) {
                            bl = this.cx.lock(false, this.myOID, 3);
                        }
                    }
                    catch (Exception exception2) {}
                }
                if (jdbcMysqlRSet2 != null) break block8;
                if (bl) {
                    this.cx.lock(false, this.myOID, 4);
                }
                this.errHandlerE(6, exception);
            }
        }
        return jdbcMysqlRSet2;
    }

    private jdbcMysqlRSet mxEQ(byte[] byArray) throws SQLException {
        jdbcMysqlRSet jdbcMysqlRSet2 = null;
        jdbcMysqlBag jdbcMysqlBag2 = this.outBag;
        jdbcMysqlBag2.maxAt = 4;
        jdbcMysqlBag2.at = 4;
        jdbcMysqlBag2.seq = 0;
        this.outBag.iToB(3, 1);
        this.outBag.putZT(byArray);
        this.outBag.write();
        this.qResult.getResult(2, this.commandValue);
        jdbcMysqlRSet2 = new jdbcMysqlRSet(this.qResult);
        return jdbcMysqlRSet2;
    }

    public boolean execute(String string) throws SQLException {
        int n = ++jdbcMysqlBase.xoid;
        boolean bl = false;
        ResultSet resultSet = null;
        try {
            bl = this.lock(true, n, this.lTimeout);
            this.qResult.clear();
            this.getCommandValue(string);
            if (this.commandValue > 200 && this.commandValue < 400) {
                resultSet = this.mExecQuery(string.getBytes());
            } else if (this.commandValue > 100 && this.commandValue < 200) {
                this.mExecUpdate(string.getBytes());
            } else {
                this.errHandlerM(13, "");
            }
            bl = this.lock(false, n, this.lTimeout);
        }
        catch (Exception exception) {
            if (bl) {
                this.lock(false, n, this.lTimeout);
            }
            this.errHandlerE(14, exception);
        }
        return resultSet != null;
    }

    ResultSet pseudoResult(Vector vector, RSMd rSMd) throws SQLException {
        this.qResult.pseudoResult(vector, rSMd);
        jdbcMysqlRSet jdbcMysqlRSet2 = new jdbcMysqlRSet(this.qResult);
        return jdbcMysqlRSet2;
    }

    public void close() throws SQLException {
        this.sAction(1, 0, null);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.sAction(2, 0, null);
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.sAction(3, n, null);
    }

    public int getMaxRows() throws SQLException {
        return this.sAction(4, 0, null);
    }

    public void setMaxRows(int n) throws SQLException {
        this.sAction(5, n, null);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.sAction(6, 0, null);
    }

    public int getQueryTimeout() throws SQLException {
        return this.sAction(7, 0, null);
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.sAction(8, n, null);
    }

    public void cancel() throws SQLException {
        this.sAction(9, 0, null);
    }

    public SQLWarning getWarnings() throws SQLException {
        this.sAction(10, 0, null);
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.sAction(11, 0, null);
    }

    public void setCursorName(String string) throws SQLException {
        this.sAction(12, 0, null);
    }

    public int getUpdateCount() throws SQLException {
        return this.sAction(13, 0, null);
    }

    public boolean getMoreResults() throws SQLException {
        return this.sAction(14, 0, null) == 1;
    }

    public ResultSet getResultSet() throws SQLException {
        int n = ++jdbcMysqlBase.xoid;
        boolean bl = false;
        jdbcMysqlRSet jdbcMysqlRSet2 = null;
        try {
            bl = this.lock(true, n, this.lTimeout);
            if (!this.open) {
                this.errHandlerM(16, "getResultSet()");
            }
            jdbcMysqlRSet2 = this.qResult.getUnretrievedRS();
            bl = this.lock(false, n, this.lTimeout);
        }
        catch (Exception exception) {
            if (bl) {
                this.lock(false, n, this.lTimeout);
            }
            this.errHandlerE2(15, "getResultSet()", exception);
        }
        return jdbcMysqlRSet2;
    }

    private int sAction(int n, int n2, String string) throws SQLException {
        int n3 = ++jdbcMysqlBase.xoid;
        boolean bl = false;
        int n4 = -1;
        try {
            bl = this.lock(true, n3, this.lTimeout);
            if (!this.open) {
                this.errHandlerM(16, apis[n]);
            }
            switch (n) {
                case 1: {
                    this.qResult.clear();
                    this.open = false;
                    break;
                }
                case 2: {
                    n4 = this.maxFieldSize;
                    break;
                }
                case 3: {
                    if (n2 < 10) {
                        this.errHandlerM(17, apis[n]);
                    }
                    this.maxFieldSize = n2;
                    break;
                }
                case 4: {
                    n4 = this.maxRows;
                    break;
                }
                case 5: {
                    if (n2 < 0) {
                        this.errHandlerM(17, apis[n]);
                    }
                    this.maxRows = n2;
                    if (n2 != 0) break;
                    this.maxRows = Integer.MAX_VALUE;
                    break;
                }
                case 6: 
                case 12: {
                    this.errHandlerM(18, apis[n]);
                    break;
                }
                case 7: {
                    n4 = this.lTimeout;
                    break;
                }
                case 8: {
                    this.lTimeout = n2;
                    break;
                }
                case 14: {
                    if (!this.qResult.areUnretrieved()) break;
                    n4 = 1;
                    break;
                }
                case 13: {
                    n4 = this.qResult.getRows();
                    break;
                }
                case 9: {
                    this.qResult.clear();
                    break;
                }
                default: {
                    this.errHandlerM(19, String.valueOf(n));
                }
                case 10: 
                case 11: 
            }
            bl = this.lock(false, n3, this.lTimeout);
        }
        catch (Exception exception) {
            if (bl) {
                this.lock(false, n3, this.lTimeout);
            }
            this.errHandlerE2(15, apis[n], exception);
        }
        return n4;
    }

    void getCommandValue(String string) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            this.errHandlerM(0, "");
        }
        this.commandWord = stringTokenizer.nextToken();
        this.commandValue = jdbcMysqlBase.getCommand(this.commandWord);
    }

    boolean lock(boolean bl, int n, int n2) throws SQLException {
        int n3 = this.guard.synch(n, bl, n2);
        if (bl && n3 == 0) {
            return true;
        }
        if (!bl && n3 == 3) {
            return false;
        }
        if (n3 == 1) {
            this.errHandlerM(7, "");
        }
        this.errHandlerM(8, String.valueOf(n3));
        return false;
    }

    void errHandlerM(int n, String string) throws SQLException {
        String string2 = "\n" + errs[n] + string;
        jdbcMysqlBase.errMessage(string2);
    }

    void errHandlerE(int n, Exception exception) throws SQLException {
        String string = "\n" + errs[n] + jdbcMysqlBase.eMessage(exception);
        jdbcMysqlBase.errMessage(string);
    }

    void errHandlerE2(int n, String string, Exception exception) throws SQLException {
        String string2 = "\n" + errs[n] + " " + string + jdbcMysqlBase.eMessage(exception);
        jdbcMysqlBase.errMessage(string2);
    }

    int iGetMaxFieldSize() {
        return this.maxFieldSize;
    }
}

