/*
 * Decompiled with CFR 0.152.
 */
package twz1.jdbc.mysql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.sql.SQLException;
import java.util.Vector;
import twz1.jdbc.mysql.RSMd;
import twz1.jdbc.mysql.jdbcMysqlBag;
import twz1.jdbc.mysql.jdbcMysqlBase;
import twz1.jdbc.mysql.jdbcMysqlConnex;
import twz1.jdbc.mysql.jdbcMysqlField;
import twz1.jdbc.mysql.jdbcMysqlRSet;
import twz1.jdbc.mysql.jdbcMysqlStmt;
import twz1.jdbc.mysql.jdbcMysqlURL;

final class jdbcMysqlResult {
    jdbcMysqlStmt statement;
    jdbcMysqlConnex connex;
    RSMd metadata;
    String catalog;
    int priorRowCount;
    int rowCount;
    int realRowCount;
    int readRowCount;
    int lastStatus;
    String sMessage;
    int cacheMode;
    static final int CM_MEMORY = 0;
    static final int CM_DISK = 1;
    static final int CM_NONE = 2;
    static final int CM_PHONEY = 3;
    BufferedInputStream dbis;
    BufferedOutputStream dbos;
    String dcpath;
    int stid;
    String dcfName;
    File dcFile;
    boolean dCacheWritten;
    Vector mcache;
    boolean noCacheDone;
    boolean dataError;
    jdbcMysqlBag inBag;
    jdbcMysqlBag wBag;
    int OID;
    Vector rSets;
    static final String[] errs = new String[]{"E0700 Error in result initialization.", "E0701 Error in getResult().", "P0702 Unsupported type in getResult()", "E0703 Error synchronizing headers and data.", "E0704 Error caching results.", "P0705 getRow() request for non memory caching.", "E0706 cacheClose() error", "E0707 error in buildColumn()", "E0708 Command results in error - ", "E0709 Error clearing prior results", "E0710 Error in data retrieval -", "E0711 Error. Unhandled cacheMode."};

    jdbcMysqlResult(jdbcMysqlStmt jdbcMysqlStmt2, jdbcMysqlConnex jdbcMysqlConnex2) throws SQLException {
        this.statement = jdbcMysqlStmt2;
        this.connex = jdbcMysqlConnex2;
        this.metadata = null;
        this.priorRowCount = -1;
        this.rowCount = -1;
        this.lastStatus = -1;
        this.sMessage = null;
        this.cacheMode = 0;
        this.dbis = null;
        this.dbos = null;
        this.dcpath = null;
        this.stid = ++jdbcMysqlBase.xoid;
        this.dcfName = null;
        this.dcFile = null;
        this.dCacheWritten = false;
        this.noCacheDone = true;
        this.mcache = null;
        this.rSets = null;
        this.realRowCount = 0;
        this.readRowCount = 0;
        this.dataError = false;
        this.wBag = new jdbcMysqlBag(10);
        try {
            jdbcMysqlConnex jdbcMysqlConnex3 = this.connex;
            if (!jdbcMysqlConnex3.open) {
                jdbcMysqlConnex3.errHandlerL(13, "getInBag()");
            }
            this.inBag = jdbcMysqlConnex3.inBag;
            jdbcMysqlConnex3 = this.connex;
            jdbcMysqlURL jdbcMysqlURL2 = jdbcMysqlConnex3.curl;
            String string = (String)jdbcMysqlURL2.values.get("cacheMode");
            if (string != null && (string = string.trim()).equalsIgnoreCase("disk")) {
                this.cacheMode = 1;
            }
            jdbcMysqlConnex3 = this.connex;
            jdbcMysqlURL2 = jdbcMysqlConnex3.curl;
            this.dcpath = (String)jdbcMysqlURL2.values.get("cachePath");
            this.dcpath = this.dcpath != null ? this.dcpath.trim() : ".";
            if (this.dcpath.equals("")) {
                this.dcpath = ".";
            }
            jdbcMysqlConnex3 = this.connex;
            if (!jdbcMysqlConnex3.open) {
                jdbcMysqlConnex3.errHandlerL(13, "isMultipleQuery");
            }
            if (!jdbcMysqlConnex3.multipleQueries) {
                this.cacheMode = 2;
                return;
            }
        }
        catch (Exception exception) {
            this.errHandlerE(0, exception);
        }
    }

    void clear() throws SQLException {
        this.cacheClose(this.noCacheDone);
        if (this.rSets != null) {
            int n = this.rSets.size();
            int n2 = 0;
            while (n2 < n) {
                jdbcMysqlRSet jdbcMysqlRSet2 = (jdbcMysqlRSet)this.rSets.elementAt(n2);
                jdbcMysqlRSet2.iClose();
                ++n2;
            }
            this.rSets = null;
        }
        if (this.cacheMode == 3) {
            this.cacheMode = 0;
        }
        this.mcache = null;
        this.metadata = null;
        this.catalog = null;
        this.rowCount = -1;
        this.realRowCount = 0;
        this.lastStatus = -1;
        this.dataError = false;
    }

    void getResult(int n, int n2) throws SQLException {
        try {
            if (n == 1) {
                if (n2 == 190) {
                    this.rowCount = 0;
                    return;
                }
                this.inBag.read();
                this.lastStatus = this.inBag.bToI(1);
                this.statement.lastInsertID = -1L;
                if (this.lastStatus == 0) {
                    this.rowCount = this.inBag.viToI();
                    if (this.inBag.at < this.inBag.maxAt) {
                        this.statement.lastInsertID = this.inBag.viToL();
                    }
                }
                if (this.lastStatus == 255) {
                    this.rowCount = this.inBag.bToI(2);
                    this.sMessage = this.inBag.getZTstring();
                }
                return;
            }
            this.inBag.read();
            if (this.inBag.peekAbyte() == 255) {
                this.lastStatus = this.inBag.bToI(1);
                int n3 = this.inBag.bToI(2);
                this.sMessage = new String(String.valueOf(n3) + " " + this.inBag.getZTstring());
                jdbcMysqlBase.errMessage(String.valueOf(errs[8]) + this.sMessage);
                return;
            }
            int n4 = this.inBag.viToI();
            this.metadata = new RSMd(this.statement);
            this.catalog = new String(this.connex.catalog);
            int n5 = 0;
            while (n5 < n4) {
                this.buildColumn();
                ++n5;
            }
            this.inBag.read();
            n5 = this.inBag.bToI(1);
            if (n5 != 254) {
                jdbcMysqlBase.errMessage(errs[3]);
            }
            switch (this.cacheMode) {
                case 1: {
                    this.cacheItDisk();
                    return;
                }
                case 0: {
                    this.cacheItMem();
                    return;
                }
                case 2: {
                    this.noCacheDone = false;
                    return;
                }
            }
            this.errHandlerM(11);
            return;
        }
        catch (Exception exception) {
            this.errHandlerE(1, exception);
            return;
        }
    }

    private void cacheItMem() throws SQLException {
        block6: {
            Exception exception2;
            block7: {
                boolean bl = false;
                try {
                    this.mcache = new Vector();
                    this.realRowCount = 0;
                    this.readRowCount = 0;
                    bl = this.inEoD(this.inBag);
                    while (!bl) {
                        if (this.realRowCount < this.statement.maxRows) {
                            this.mcache.addElement(this.inBag.inside);
                            this.inBag.inside = null;
                            ++this.realRowCount;
                        }
                        ++this.readRowCount;
                        bl = this.inEoD(this.inBag);
                    }
                    if (this.dataError) {
                        this.errHandlerNM(10, this.lastStatus, this.sMessage);
                        return;
                    }
                    break block6;
                }
                catch (Exception exception2) {
                    if (bl) break block7;
                }
                while (!this.inEoD(this.inBag)) {
                }
            }
            this.errHandlerE(4, exception2);
        }
    }

    private void cacheItDisk() throws SQLException {
        Exception exception2;
        block6: {
            boolean bl = false;
            try {
                Closeable closeable;
                this.dCacheWritten = true;
                this.dcfName = new String(String.valueOf(this.dcpath) + "/" + this.stid + ".cache");
                this.dcFile = new File(this.dcfName);
                this.dbos = new BufferedOutputStream(new FileOutputStream(this.dcFile));
                jdbcMysqlBag jdbcMysqlBag2 = this.inBag;
                jdbcMysqlBag2.bos = closeable = this.dbos;
                this.realRowCount = 0;
                this.readRowCount = 0;
                bl = this.inEoD(this.inBag);
                while (!bl) {
                    if (this.realRowCount < this.statement.maxRows) {
                        this.inBag.write();
                        ++this.realRowCount;
                    }
                    ++this.readRowCount;
                    bl = this.inEoD(this.inBag);
                }
                this.inBag.write();
                this.dbos.close();
                this.dbos = null;
                jdbcMysqlBag2 = this.inBag;
                jdbcMysqlBag2.bos = null;
                if (this.dataError) {
                    this.dcFile.delete();
                    this.errHandlerNM(10, this.lastStatus, this.sMessage);
                }
                this.dbis = new BufferedInputStream(new FileInputStream(this.dcFile));
                jdbcMysqlBag2 = this.inBag = new jdbcMysqlBag();
                closeable = this.dbis;
                jdbcMysqlBag2.bis = closeable;
                return;
            }
            catch (Exception exception2) {
                if (bl) break block6;
            }
            while (!this.inEoD(this.inBag)) {
            }
        }
        this.errHandlerE(4, exception2);
    }

    boolean inEoD(jdbcMysqlBag jdbcMysqlBag2) throws SQLException {
        jdbcMysqlBag2.read();
        int n = jdbcMysqlBag2.maxAt - 4;
        int n2 = jdbcMysqlBag2.peekAbyte();
        if (n2 == 254 && n < 4) {
            return true;
        }
        if (n2 == 255) {
            jdbcMysqlBag2.bToI(1);
            this.dataError = true;
            this.lastStatus = 2;
            this.sMessage = "Data error!";
            try {
                this.lastStatus = jdbcMysqlBag2.bToI(2);
                this.sMessage = jdbcMysqlBag2.getRstring();
            }
            catch (Exception exception) {}
            return true;
        }
        return false;
    }

    private void buildColumn() throws SQLException {
        try {
            String string;
            String string2;
            this.inBag.read();
            jdbcMysqlField jdbcMysqlField2 = new jdbcMysqlField(this.metadata.cc);
            jdbcMysqlField2.catalog = string2 = this.catalog;
            int n = this.inBag.viToI();
            jdbcMysqlField2.table = string = this.inBag.getNstring(n);
            n = this.inBag.viToI();
            jdbcMysqlField2.column = string = this.inBag.getNstring(n);
            jdbcMysqlField2.size = n = this.inBag.nbToI();
            jdbcMysqlField2.ctype = n = this.inBag.nbToI();
            int n2 = this.inBag.bToI(1);
            if (n2 > 0) {
                jdbcMysqlField2.cflags = n = this.inBag.bToI(1);
                --n2;
            }
            if (n2 > 0) {
                jdbcMysqlField2.decimals = n = this.inBag.bToI(1);
                --n2;
            }
            this.metadata.addField(jdbcMysqlField2);
            return;
        }
        catch (Exception exception) {
            this.errHandlerE(7, exception);
            return;
        }
    }

    int getStatus() {
        return this.lastStatus;
    }

    int getRows() {
        if (this.rowCount == -1) {
            return this.rowCount;
        }
        this.priorRowCount = this.rowCount;
        this.rowCount = -1;
        return this.priorRowCount;
    }

    String getMessage() {
        return this.sMessage;
    }

    void addRS(jdbcMysqlRSet jdbcMysqlRSet2) {
        if (this.rSets == null) {
            this.rSets = new Vector();
        }
        this.rSets.addElement(jdbcMysqlRSet2);
    }

    void doneRS(int n) {
        if (this.rSets != null) {
            int n2 = 0;
            while (n2 < this.rSets.size()) {
                jdbcMysqlRSet jdbcMysqlRSet2 = (jdbcMysqlRSet)this.rSets.elementAt(n2);
                if (jdbcMysqlRSet2.myOID == n) {
                    this.rSets.removeElementAt(n2--);
                }
                ++n2;
            }
        }
    }

    void cacheClose(boolean bl) throws SQLException {
        if (this.cacheMode == 0) {
            return;
        }
        if (this.cacheMode == 3) {
            this.cacheMode = 0;
            return;
        }
        try {
            if (this.cacheMode == 1) {
                if (this.dCacheWritten) {
                    if (this.dbis != null) {
                        ((FilterInputStream)this.dbis).close();
                    }
                    try {
                        this.dcFile.delete();
                    }
                    catch (Exception exception) {}
                    jdbcMysqlConnex jdbcMysqlConnex2 = this.connex;
                    if (!jdbcMysqlConnex2.open) {
                        jdbcMysqlConnex2.errHandlerL(13, "getInBag()");
                    }
                    this.inBag = jdbcMysqlConnex2.inBag;
                }
                return;
            }
            if (!bl && !this.noCacheDone) {
                while (!this.inEoD(this.inBag)) {
                }
            }
            if (!this.noCacheDone) {
                this.connex.lock(false, this.statement.myOID, this.statement.lTimeout);
                this.noCacheDone = true;
                return;
            }
        }
        catch (Exception exception) {
            this.errHandlerE(6, exception);
        }
    }

    jdbcMysqlRSet getUnretrievedRS() {
        if (this.rSets == null) {
            return null;
        }
        int n = this.rSets.size();
        int n2 = 0;
        while (n2 < n) {
            jdbcMysqlRSet jdbcMysqlRSet2 = (jdbcMysqlRSet)this.rSets.elementAt(n2);
            if (!jdbcMysqlRSet2.retrieved) {
                jdbcMysqlRSet2.retrieved = true;
                return jdbcMysqlRSet2;
            }
            ++n2;
        }
        return null;
    }

    boolean areUnretrieved() {
        if (this.rSets == null) {
            return false;
        }
        int n = this.rSets.size();
        int n2 = 0;
        while (n2 < n) {
            jdbcMysqlRSet jdbcMysqlRSet2 = (jdbcMysqlRSet)this.rSets.elementAt(n2);
            if (!jdbcMysqlRSet2.retrieved) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    void pseudoResult(Vector vector, RSMd rSMd) throws SQLException {
        this.clear();
        this.cacheMode = 3;
        this.catalog = new String(this.connex.catalog);
        this.metadata = rSMd;
        this.mcache = vector == null ? new Vector() : vector;
        this.realRowCount = this.readRowCount = this.mcache.size();
    }

    void errHandlerM(int n) throws SQLException {
        String string = "\n" + errs[n];
        jdbcMysqlBase.errMessage(string);
    }

    void errHandlerE(int n, Exception exception) throws SQLException {
        String string = "\n" + errs[n] + jdbcMysqlBase.eMessage(exception);
        jdbcMysqlBase.errMessage(string);
    }

    void errHandlerNM(int n, int n2, String string) throws SQLException {
        String string2 = "\n" + errs[n] + n2 + " " + string;
        jdbcMysqlBase.errMessage(string2);
    }
}

