/*
 * Decompiled with CFR 0.152.
 */
package twz1.jdbc.mysql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.Socket;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import twz1.jdbc.mysql.DbMd;
import twz1.jdbc.mysql.jdbcMysqlBag;
import twz1.jdbc.mysql.jdbcMysqlBase;
import twz1.jdbc.mysql.jdbcMysqlMutex;
import twz1.jdbc.mysql.jdbcMysqlPStmt;
import twz1.jdbc.mysql.jdbcMysqlStmt;
import twz1.jdbc.mysql.jdbcMysqlURL;

public final class jdbcMysqlConnex
implements Connection {
    jdbcMysqlURL curl;
    boolean open;
    String host;
    int port;
    String catalog;
    String user;
    String password;
    Socket socket;
    BufferedInputStream socketInput;
    BufferedOutputStream socketOutput;
    boolean multipleQueries;
    jdbcMysqlBag inBag;
    jdbcMysqlBag outBag;
    int clientProtocol;
    int clientCapabilities;
    String serverVersion;
    int serverThreadID;
    String hashSeed;
    jdbcMysqlMutex guard;
    int myOID;
    int xOptions;
    int sockTCP_NODELAY;
    int sockSO_LINGER;
    int sockTimeout;
    int connexTimeout;
    Vector dbmdConnections;
    boolean broken;
    String xversion;
    static final String[] errs = new String[]{"E2000 Connection option choices are marked invalid.", "E2001 Property is invalid -", "E2002 Socket error", "P2003 ", "E2004 Error setting SO_LINGER", "E2005 Error setting socket timeout", "P2006", "P2007", "E2008 Error receiving initial from server.", "E2009 Error writing initial reply to server.", "E2010 Error receiving connect response.", "E2011 Access error ", "E2012 Unexpected result from connect: ", "E2013 Connection not open. ", "E2014 Error setCatalog() to ", "E2015 Error from setCatalog() for ", "E2016 Invalid result code from setCatalog() : ", "E2017 Error on initial set of database.", "P2018 Error setting catalog", "E2019 Connection lock() timeout", "E2020 Connection lock() unexpected return.", "E2021 Connection is in query with multiple turned off.", "S2022 PROG! attempt to decrement inQuery already at zero.", "E2023 Error in getCatalog()", "E2024 Invoking properties are invalid. ", "E2025 Reflected error ", "E2026 Feature not supported.", "E2027 Error retrieving DBMD.", "E2028 Error in connection packet", "E2029 Invalid protocol specification."};

    jdbcMysqlConnex(jdbcMysqlURL jdbcMysqlURL2) throws SQLException {
        boolean bl;
        String string = null;
        int n = 0;
        this.curl = jdbcMysqlURL2;
        this.open = false;
        this.multipleQueries = true;
        this.socket = null;
        this.socketInput = null;
        this.socketOutput = null;
        this.clientProtocol = -1;
        this.serverVersion = null;
        this.serverThreadID = 0;
        this.hashSeed = null;
        this.user = null;
        this.password = null;
        this.clientCapabilities = 0;
        this.guard = new jdbcMysqlMutex();
        this.myOID = ++jdbcMysqlBase.xoid;
        this.sockTCP_NODELAY = -1;
        this.sockSO_LINGER = -1;
        this.sockTimeout = -1;
        this.dbmdConnections = new Vector();
        this.xOptions = 0;
        this.broken = false;
        this.xversion = null;
        Object object = this.curl;
        if (!((jdbcMysqlURL)object).valid) {
            this.curl.debugProperty("Properties ...");
            this.errHandlerL(24, "");
        }
        this.inBag = new jdbcMysqlBag();
        this.outBag = new jdbcMysqlBag();
        this.inBag.connex = this;
        this.outBag.connex = this;
        object = this.curl;
        string = (String)((jdbcMysqlURL)object).values.get("multipleQuery");
        n = jdbcMysqlBase.boolValue(string, 1, -1);
        if (n == -1) {
            this.curl.debugProperty("Properties ...");
            this.errHandlerL(1, "multipleQuery");
        }
        this.multipleQueries = n == 1;
        object = this.curl;
        this.host = (String)((jdbcMysqlURL)object).values.get("host");
        object = this.curl;
        this.catalog = (String)((jdbcMysqlURL)object).values.get("db");
        object = this.curl;
        string = (String)((jdbcMysqlURL)object).values.get("port");
        this.port = jdbcMysqlBase.intValue(string, 3306, 0);
        if (this.port == 0) {
            this.curl.debugProperty("Properties ...");
            this.errHandlerL(1, "port");
        }
        object = this.curl;
        this.user = (String)((jdbcMysqlURL)object).values.get("user");
        object = this.curl;
        this.password = (String)((jdbcMysqlURL)object).values.get("password");
        object = this.curl;
        string = (String)((jdbcMysqlURL)object).values.get("TCP_NODELAY");
        this.sockTCP_NODELAY = jdbcMysqlBase.boolValue(string, -1, -2);
        if (this.sockTCP_NODELAY == -2) {
            this.curl.debugProperty("Properties ...");
            this.errHandlerL(1, "TCP_NODELAY");
        }
        object = this.curl;
        string = (String)((jdbcMysqlURL)object).values.get("SO_LINGER");
        this.sockSO_LINGER = jdbcMysqlBase.intValue(string, -1, -2);
        if (this.sockSO_LINGER == -2) {
            this.curl.debugProperty("Properties ...");
            this.errHandlerL(1, "SO_LINGER");
        }
        object = this.curl;
        string = (String)((jdbcMysqlURL)object).values.get("socketTimeout");
        this.sockTimeout = jdbcMysqlBase.intValue(string, -1, -2);
        if (this.sockTimeout < -1) {
            this.curl.debugProperty("Properties ...");
            this.errHandlerL(1, "socketTimeout");
        }
        object = this.curl;
        string = (String)((jdbcMysqlURL)object).values.get("connectionTimeout");
        this.connexTimeout = jdbcMysqlBase.intValue(string, 120, -2);
        if (this.connexTimeout < 0) {
            this.curl.debugProperty("Properties ...");
            this.errHandlerL(1, "connectionTimeout");
        }
        object = this.curl;
        string = (String)((jdbcMysqlURL)object).values.get("debugRead");
        n = jdbcMysqlBase.boolValue(string, 0, -1);
        if (n < 0) {
            this.curl.debugProperty("Properties ...");
            this.errHandlerL(1, "debugRead");
        }
        object = this.inBag;
        ((jdbcMysqlBag)object).dumpRead = bl = n == 1;
        object = this.curl;
        string = (String)((jdbcMysqlURL)object).values.get("debugWrite");
        n = jdbcMysqlBase.boolValue(string, 0, -1);
        if (n < 0) {
            this.curl.debugProperty("Properties ...");
            this.errHandlerL(1, "debugWrite");
        }
        object = this.outBag;
        ((jdbcMysqlBag)object).dumpWrite = bl = n == 1;
        this.xOpen();
    }

    void xOpen() throws SQLException {
        String string = null;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        if (this.socket != null) {
            try {
                ((FilterInputStream)this.inBag.bis).close();
            }
            catch (Exception exception) {}
            try {
                this.outBag.bos.close();
            }
            catch (Exception exception) {}
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
            this.socket = null;
            this.inBag.bis = null;
            this.outBag.bos = null;
        }
        try {
            string2 = "creation";
            this.socket = new Socket(this.host, this.port);
            boolean bl = false;
            string2 = "TCP_NODELAY";
            if (this.sockTCP_NODELAY == 1) {
                this.socket.setTcpNoDelay(true);
            }
            if (this.sockTCP_NODELAY == 0) {
                this.socket.setTcpNoDelay(false);
            }
            string2 = "SO_LINGER";
            if (this.sockSO_LINGER > -1) {
                bl = this.sockSO_LINGER != 0;
                this.socket.setSoLinger(bl, this.sockSO_LINGER);
            }
            string2 = "timeout";
            if (this.sockTimeout > -1) {
                this.socket.setSoTimeout(this.sockTimeout * 1000);
            }
            string2 = "Set input buffer";
            this.socketInput = new BufferedInputStream(this.socket.getInputStream());
            string2 = "Set output buffer";
            this.socketOutput = new BufferedOutputStream(this.socket.getOutputStream());
        }
        catch (IOException iOException) {
            this.errHandlerM(2, string2, iOException);
        }
        Object object = this.inBag;
        Object object2 = this.socketInput;
        ((jdbcMysqlBag)object).bis = object2;
        object = this.outBag;
        object2 = this.socketOutput;
        ((jdbcMysqlBag)object).bos = object2;
        try {
            this.inBag.read();
            this.clientProtocol = this.inBag.bToI(1);
            if (this.clientProtocol == 255) {
                object = new String(String.valueOf(this.inBag.bToI(2)) + " " + this.inBag.getRstring());
                this.curl.debugProperty("Properties ...");
                this.errHandlerL(28, (String)object);
            }
            if (this.clientProtocol < 9 || this.clientProtocol > 10) {
                object = String.valueOf(this.clientProtocol);
                this.curl.debugProperty("Properties ...");
                this.errHandlerL(29, (String)object);
            }
            this.serverVersion = this.inBag.getZTstring();
            this.xsv();
            if (this.xversion.compareTo("032205") < 0) {
                this.inBag.teeny = true;
                this.outBag.teeny = true;
            }
            this.serverThreadID = this.inBag.bToI(4);
            this.hashSeed = this.inBag.getZTstring();
            if (this.inBag.maxAt > this.inBag.at) {
                this.xOptions = this.inBag.bToI(2);
            }
            if (this.clientProtocol == 10) {
                this.clientCapabilities = 1;
            }
        }
        catch (Exception exception) {
            this.errHandlerM(8, "", exception);
        }
        try {
            object = this.outBag;
            object2 = this.inBag;
            int n3 = ((jdbcMysqlBag)object2).seq + 1;
            ((jdbcMysqlBag)object).maxAt = 4;
            ((jdbcMysqlBag)object).at = 4;
            ((jdbcMysqlBag)object).seq = n3;
            this.outBag.iToB(this.clientCapabilities, 2);
            this.outBag.iToB(65536, 3);
            this.outBag.putZT(this.user);
            this.outBag.putZT(this.scramble());
            this.outBag.write();
        }
        catch (Exception exception) {
            this.errHandlerM(9, "", exception);
        }
        try {
            this.inBag.read();
            n = this.inBag.bToI(1);
            n2 = this.inBag.bToI(2);
            if (n == 255) {
                string = this.inBag.getZTstring();
            }
        }
        catch (Exception exception) {
            this.errHandlerM(10, "", exception);
        }
        if (n == 255) {
            this.closeMe();
            object = String.valueOf(n2) + " " + string;
            this.curl.debugProperty("Properties ...");
            this.errHandlerL(11, (String)object);
        }
        if (n != 0) {
            this.closeMe();
            object = String.valueOf(n);
            this.curl.debugProperty("Properties ...");
            this.errHandlerL(12, (String)object);
        }
        this.open = true;
        this.broken = false;
        this.iSetCat(this.catalog);
    }

    void xsv() {
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(), new StringBuffer(), new StringBuffer()};
        String[] stringArray = new String[3];
        int n = 0;
        int n2 = this.serverVersion.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = this.serverVersion.charAt(n3);
            if (c >= '0' && c <= '9') {
                stringBufferArray[n].append(c);
            }
            if (c == '.') {
                if (stringBufferArray[n].length() < 2) {
                    stringBufferArray[n].insert(0, '0');
                }
                stringArray[n] = new String(stringBufferArray[n]);
                ++n;
            }
            ++n3;
        }
        if (stringBufferArray[n].length() < 2) {
            stringBufferArray[n].insert(0, '0');
        }
        stringArray[n] = new String(stringBufferArray[n]);
        this.xversion = new String(String.valueOf(stringArray[0]) + stringArray[1] + stringArray[2]);
    }

    void setReadDump(boolean bl) throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "setReadDump()");
        }
        jdbcMysqlBag jdbcMysqlBag2 = this.inBag;
        jdbcMysqlBag2.dumpRead = bl;
    }

    void setWriteDump(boolean bl) throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "setWriteDump()");
        }
        jdbcMysqlBag jdbcMysqlBag2 = this.outBag;
        jdbcMysqlBag2.dumpWrite = bl;
    }

    void setMultipleQuery(boolean bl) throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "setMultipleQueries()");
        }
        this.multipleQueries = bl;
    }

    boolean isMultipleQuery() throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "isMultipleQuery");
        }
        return this.multipleQueries;
    }

    jdbcMysqlBag getInBag() throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "getInBag()");
        }
        return this.inBag;
    }

    jdbcMysqlBag getOutBag() throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "getOutBag()");
        }
        return this.outBag;
    }

    private void testOpen(String string) throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, string);
        }
    }

    String getProperty(String string) {
        jdbcMysqlURL jdbcMysqlURL2 = this.curl;
        return (String)jdbcMysqlURL2.values.get(string);
    }

    void setProperty(String string, String string2) {
        jdbcMysqlURL jdbcMysqlURL2 = this.curl;
        if (string2 == null) {
            jdbcMysqlURL2.values.remove(string);
            return;
        }
        jdbcMysqlURL2.values.put(string, string2);
    }

    void addDBMDconnex(jdbcMysqlConnex jdbcMysqlConnex2) {
        this.dbmdConnections.addElement(jdbcMysqlConnex2);
    }

    boolean lock(boolean bl, int n, int n2) throws SQLException {
        int n3 = n2;
        if (!this.multipleQueries) {
            n3 = -1;
        }
        int n4 = this.guard.synch(n, bl, n3);
        if (bl) {
            if (n4 == 0) {
                return true;
            }
            if (n4 == 1) {
                if (!this.multipleQueries) {
                    this.errHandlerL(21, "");
                }
                this.errHandlerL(19, String.valueOf(n));
            }
        } else if (n4 == 3) {
            return false;
        }
        this.errHandlerL(20, String.valueOf(String.valueOf(n4)) + " " + String.valueOf(n));
        return false;
    }

    void closeMe() {
        this.open = false;
        int n = 0;
        int n2 = 0;
        try {
            this.lock(true, this.myOID, this.connexTimeout);
            Object object = this.outBag;
            ((jdbcMysqlBag)object).maxAt = 4;
            ((jdbcMysqlBag)object).at = 4;
            ((jdbcMysqlBag)object).seq = 0;
            this.outBag.iToB(1, 1);
            this.outBag.putZT("QUIT");
            this.outBag.write();
            this.inBag.read();
            n2 = this.dbmdConnections.size();
            n = 0;
            while (n < n2) {
                object = (Connection)this.dbmdConnections.elementAt(n);
                try {
                    object.close();
                }
                catch (SQLException sQLException) {}
                ++n;
            }
            this.lock(false, this.myOID, 0);
        }
        catch (Exception exception) {}
        this.outBag.connex = null;
        this.inBag.connex = null;
        if (this.socketInput != null) {
            try {
                ((FilterInputStream)this.socketInput).close();
            }
            catch (Exception exception) {}
        }
        if (this.socketOutput != null) {
            try {
                this.socketOutput.close();
            }
            catch (Exception exception) {}
        }
        if (this.socket != null) {
            try {
                this.socket.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void close() throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "close()");
        }
        this.closeMe();
    }

    public boolean isClosed() throws SQLException {
        return !this.open;
    }

    public void setCatalog(String string) throws SQLException {
        boolean bl = false;
        try {
            bl = this.lock(true, this.myOID, this.connexTimeout);
            if (!this.open) {
                this.errHandlerL(13, "setCatalog()");
            }
            this.iSetCat(string);
            bl = this.lock(false, this.myOID, 0);
        }
        catch (Exception exception) {
            if (bl) {
                this.lock(false, this.myOID, 0);
            }
            this.errHandlerL(18, exception.getMessage());
        }
        this.catalog = string;
    }

    private void iSetCat(String string) throws SQLException {
        int n = 0;
        int n2 = 0;
        String string2 = null;
        jdbcMysqlBag jdbcMysqlBag2 = this.outBag;
        jdbcMysqlBag2.maxAt = 4;
        jdbcMysqlBag2.at = 4;
        jdbcMysqlBag2.seq = 0;
        this.outBag.iToB(2, 1);
        this.outBag.putZT(string);
        this.outBag.write();
        this.inBag.read();
        n = this.inBag.bToI(1);
        n2 = this.inBag.bToI(2);
        if (n == 255) {
            string2 = this.inBag.getZTstring();
            this.errHandlerL(15, String.valueOf(string) + " " + n2 + " " + string2);
        }
        if (n != 0) {
            this.errHandlerL(16, String.valueOf(n));
        }
    }

    public Statement createStatement() throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "createStatement()");
        }
        return new jdbcMysqlStmt(this);
    }

    public String getCatalog() throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "getCatalog()");
        }
        return this.catalog;
    }

    public void clearWarnings() throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "clearWarnings()");
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "getWarnings()");
        }
        return null;
    }

    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (n != 0) {
            this.errHandlerL(26, "setTransactionIsolation()");
        }
    }

    public void rollback() throws SQLException {
        this.errHandlerL(26, "rollback()");
    }

    public void commit() throws SQLException {
    }

    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (!bl) {
            this.errHandlerL(26, "setAutoCommit()");
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.errHandlerL(26, "setReadOnly()");
    }

    public boolean isReadOnly() throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "isReadOnly()");
        }
        return false;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        DbMd dbMd = null;
        try {
            dbMd = new DbMd(this);
        }
        catch (Exception exception) {
            this.errHandlerE(27, exception);
        }
        return dbMd;
    }

    public String nativeSQL(String string) throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "nativeSQL()");
        }
        return string;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.errHandlerL(26, "prepareCall()");
        return null;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (!this.open) {
            this.errHandlerL(13, "prepareStatement()");
        }
        return new jdbcMysqlPStmt(this, string);
    }

    private void errHandlerL(int n, String string) throws SQLException {
        String string2 = "\n" + errs[n] + " " + string;
        jdbcMysqlBase.errMessage(string2);
    }

    private void errHandlerPS(int n, String string) throws SQLException {
        this.curl.debugProperty("Properties ...");
        this.errHandlerL(n, string);
    }

    private void errHandlerM(int n, String string, Exception exception) throws SQLException {
        this.closeMe();
        String string2 = "\n" + errs[n] + " " + string + jdbcMysqlBase.eMessage(exception);
        jdbcMysqlBase.errMessage(string2);
    }

    private void errHandlerE(int n, Exception exception) throws SQLException {
        String string = "\n" + errs[n] + jdbcMysqlBase.eMessage(exception);
        jdbcMysqlBase.errMessage(string);
    }

    private long[] hashPassword(String string) {
        long[] lArray = new long[2];
        long l = 1345345333L;
        long l2 = 7L;
        long l3 = 305419889L;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c != ' ' && c != '\t') {
                long l4 = c;
                l ^= ((l & 0x3FL) + l2) * l4 + (l << 8);
                l3 += l3 << 8 ^ l;
                l2 += l4;
            }
            ++n2;
        }
        lArray[0] = l & Integer.MAX_VALUE;
        lArray[1] = l3 & Integer.MAX_VALUE;
        return lArray;
    }

    private byte[] scramble() {
        double d;
        double d2;
        long l;
        long l2;
        long l3;
        if (this.password == null) {
            return new byte[0];
        }
        if (this.password.length() == 0) {
            return new byte[0];
        }
        int n = this.hashSeed.length();
        byte[] byArray = new byte[n];
        long[] lArray = this.hashPassword(this.password);
        long[] lArray2 = this.hashPassword(this.hashSeed);
        if (this.clientCapabilities < 1) {
            l3 = 0x1FFFFFFL;
            l2 = (lArray[0] ^ lArray2[0]) % l3;
            l = l2 / 2L;
        } else {
            l3 = 0x3FFFFFFFL;
            l2 = (lArray[0] ^ lArray2[0]) % l3;
            l = (lArray[1] ^ lArray2[1]) % l3;
        }
        double d3 = l3;
        int n2 = 0;
        while (n2 < n) {
            l2 = (l2 * 3L + l) % l3;
            l = (l2 + l + 33L) % l3;
            d2 = l2;
            d = d2 / d3;
            byArray[n2] = (byte)(Math.floor(d * 31.0) + 64.0);
            ++n2;
        }
        if (this.clientCapabilities == 1) {
            l2 = (l2 * 3L + l) % l3;
            l = (l2 + l + 33L) % l3;
            d2 = l2;
            d = d2 / d3;
            byte by = (byte)Math.floor(d * 31.0);
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3++;
                byArray[n4] = (byte)(byArray[n4] ^ by);
            }
        }
        return byArray;
    }
}

