/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.Command;
import org.apache.fop.viewer.DocumentPanel;
import org.apache.fop.viewer.IconToolBar;
import org.apache.fop.viewer.PreviewDialogAboutBox;

public class PreviewDialog
extends JFrame {
    protected int currentPage = 0;
    protected int pageCount = 0;
    protected AWTRenderer renderer;
    protected IconToolBar toolBar = new IconToolBar();
    protected Command printAction = new Command("Print", "Print");
    protected Command firstPageAction = new Command("First page", "firstpg"){

        public void doit() {
            PreviewDialog.this.goToFirstPage(null);
        }
    };
    protected Command previousPageAction = new Command("Previous page", "prevpg"){

        public void doit() {
            PreviewDialog.this.goToPreviousPage(null);
        }
    };
    protected Command nextPageAction = new Command("Next page", "nextpg"){

        public void doit() {
            PreviewDialog.this.goToNextPage(null);
        }
    };
    protected Command lastPageAction = new Command("Last page", "lastpg"){

        public void doit() {
            PreviewDialog.this.goToLastPage(null);
        }
    };
    protected JLabel zoomLabel = new JLabel();
    protected JComboBox scale = new JComboBox(){

        public float getAlignmentY() {
            return 0.5f;
        }
    };
    protected JScrollPane previewArea = new JScrollPane();
    protected JLabel statusBar = new JLabel();
    protected DocumentPanel docPanel;

    public PreviewDialog(AWTRenderer aWTRenderer) {
        this.renderer = aWTRenderer;
        this.setDefaultCloseOperation(2);
        ((Component)this).setSize(new Dimension(379, 476));
        this.previewArea.setMinimumSize(new Dimension(50, 50));
        this.statusBar.setText("");
        this.statusBar.setBackground(new Color(0, 0, 231));
        this.setTitle("FOP: AWT-Preview");
        this.scale.addItem("25");
        this.scale.addItem("50");
        this.scale.addItem("75");
        this.scale.addItem("100");
        this.scale.addItem("150");
        this.scale.addItem("200");
        this.scale.setMaximumSize(new Dimension(80, 24));
        this.scale.setPreferredSize(new Dimension(80, 24));
        this.scale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewDialog.this.scale_actionPerformed(actionEvent);
            }
        });
        this.scale.setSelectedItem("100");
        this.renderer.setScaleFactor(100.0);
        this.zoomLabel.setText("Zoom");
        this.setJMenuBar(this.setupMenue());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.toolBar.add(this.printAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.firstPageAction);
        this.toolBar.add(this.previousPageAction);
        this.toolBar.add(this.nextPageAction);
        this.toolBar.add(this.lastPageAction);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.zoomLabel, null);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.scale, null);
        this.getContentPane().add((Component)this.previewArea, "Center");
        this.docPanel = new DocumentPanel(this.renderer, this);
        this.previewArea.setSize(this.docPanel.getSize());
        this.previewArea.getViewport().add(this.docPanel);
        this.statusBar.setText("FOTree --> AreaTree ...");
    }

    JMenuBar setupMenue() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("OutputFormat");
        jMenu2.add(new Command("mHTML"));
        jMenu2.add(new Command("mPDF"));
        jMenu2.add(new Command("mRTF"));
        jMenu2.add(new Command("mTEXT"));
        jMenu.add(new Command("Print"));
        jMenu.addSeparator();
        jMenu.add(new Command("Exit"){

            public void doit() {
                PreviewDialog.this.dispose();
            }
        });
        jMenuBar.add(jMenu);
        jMenu = new JMenu("View");
        jMenu.add(new Command("First page"){

            public void doit() {
                PreviewDialog.this.goToFirstPage(null);
            }
        });
        jMenu.add(new Command("Previous page"){

            public void doit() {
                PreviewDialog.this.goToPreviousPage(null);
            }
        });
        jMenu.add(new Command("Next page"){

            public void doit() {
                PreviewDialog.this.goToNextPage(null);
            }
        });
        jMenu.add(new Command("Last page"){

            public void doit() {
                PreviewDialog.this.goToLastPage(null);
            }
        });
        jMenu.addSeparator();
        jMenu2 = new JMenu("Zoom");
        jMenu2.add(new Command("25%"){

            public void doit() {
                PreviewDialog.this.setScale(25.0);
            }
        });
        jMenu2.add(new Command("50%"){

            public void doit() {
                PreviewDialog.this.setScale(50.0);
            }
        });
        jMenu2.add(new Command("75%"){

            public void doit() {
                PreviewDialog.this.setScale(75.0);
            }
        });
        jMenu2.add(new Command("100%"){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        jMenu2.add(new Command("150%"){

            public void doit() {
                PreviewDialog.this.setScale(150.0);
            }
        });
        jMenu2.add(new Command("200%"){

            public void doit() {
                PreviewDialog.this.setScale(200.0);
            }
        });
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenu.add(new Command("Default zoom"){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Help");
        jMenu.add(new Command("Index"));
        jMenu.addSeparator();
        jMenu.add(new Command("Introduction"));
        jMenu.addSeparator();
        jMenu.add(new Command("About"){

            public void doit() {
                PreviewDialog.this.startHelpAbout(null);
            }
        });
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    public void dispose() {
        System.exit(0);
    }

    public void startHelpAbout(ActionEvent actionEvent) {
        PreviewDialogAboutBox previewDialogAboutBox = new PreviewDialogAboutBox(this);
        Dimension dimension = previewDialogAboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        ((Component)previewDialogAboutBox).setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        previewDialogAboutBox.setModal(true);
        previewDialogAboutBox.show();
    }

    void goToPage(int n) {
        this.docPanel.setPageNumber(n);
        this.repaint();
        this.previewArea.repaint();
        this.statusBar.setText("Page " + (n + 1) + " of " + this.pageCount);
    }

    void goToPreviousPage(ActionEvent actionEvent) {
        if (this.currentPage <= 0) {
            return;
        }
        --this.currentPage;
        this.goToPage(this.currentPage);
    }

    void goToNextPage(ActionEvent actionEvent) {
        if (this.currentPage >= this.pageCount - 1) {
            return;
        }
        ++this.currentPage;
        this.goToPage(this.currentPage);
    }

    void goToLastPage(ActionEvent actionEvent) {
        if (this.currentPage == this.pageCount - 1) {
            return;
        }
        this.currentPage = this.pageCount - 1;
        this.goToPage(this.currentPage);
    }

    void goToFirstPage(ActionEvent actionEvent) {
        if (this.currentPage == 0) {
            return;
        }
        this.currentPage = 0;
        this.goToPage(this.currentPage);
    }

    void print(ActionEvent actionEvent) {
        Properties properties = null;
        Container container = this.getRootPane();
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        Frame frame = (Frame)container;
        PrintJob printJob = frame.getToolkit().getPrintJob(frame, this.getTitle(), properties);
        if (printJob == null) {
            return;
        }
        Graphics graphics = printJob.getGraphics();
        if (graphics != null) {
            this.docPanel.paintAll(graphics);
            graphics.dispose();
        }
        printJob.end();
    }

    public void setScale(double d) {
        if (d == 25.0) {
            this.scale.setSelectedIndex(0);
        } else if (d == 50.0) {
            this.scale.setSelectedIndex(1);
        } else if (d == 75.0) {
            this.scale.setSelectedIndex(2);
        } else if (d == 100.0) {
            this.scale.setSelectedIndex(3);
        } else if (d == 150.0) {
            this.scale.setSelectedIndex(4);
        } else if (d == 200.0) {
            this.scale.setSelectedIndex(5);
        }
        this.renderer.setScaleFactor(d);
        this.previewArea.invalidate();
        this.previewArea.repaint();
    }

    void scale_actionPerformed(ActionEvent actionEvent) {
        this.setScale(new Double((String)this.scale.getSelectedItem()));
    }

    public void setPageCount(int n) {
        this.pageCount = n;
        this.statusBar.setText("Page 1 of " + this.pageCount);
    }
}

