/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.Page;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.PreviewDialog;

public class DocumentPanel
extends JComponent {
    static final int V_BORDER = 80;
    static final int H_BORDER = 70;
    protected AWTRenderer renderer;
    protected PreviewDialog previewDialog;
    protected AreaTree areaTree;
    protected int pageNumber = 0;
    protected int docWidth;
    protected int docHeight;
    protected Color myColor = Color.lightGray;

    public DocumentPanel(AWTRenderer aWTRenderer, PreviewDialog previewDialog) {
        this.previewDialog = previewDialog;
        this.renderer = aWTRenderer;
        this.renderer.setComponent(this);
    }

    public void updateSize(int n, double d) {
        if (this.areaTree == null) {
            return;
        }
        Page page = (Page)this.areaTree.getPages().elementAt(n);
        this.docWidth = page.getWidth() / 1000;
        this.docHeight = page.getHeight() / 1000;
        this.setSize((int)(d * (double)page.getWidth() / 1000.0 + 160.0), (int)(d * (double)page.getHeight() / 1000.0 + 140.0));
    }

    public void setAreaTree(AreaTree areaTree) {
        this.areaTree = areaTree;
        this.updateSize(this.pageNumber, 1.0);
        this.getParent().getParent().doLayout();
    }

    public void paintComponent(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.myColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(color);
        graphics.translate(80, 70);
        this.renderer.setGraphics((Graphics2D)graphics);
        if (this.areaTree != null) {
            try {
                this.renderer.render(this.areaTree, this.pageNumber);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        graphics.translate(-80, -70);
    }

    public void setPageNumber(int n) {
        this.pageNumber = n;
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void setPageCount(int n) {
        this.previewDialog.setPageCount(n);
    }
}

