/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.FontState;
import org.apache.fop.svg.SVGArea;

public class SVG
extends FObj {
    FontState fs;
    int breakBefore;
    int breakAfter;
    int width;
    int height;
    int spaceBefore;
    int spaceAfter;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public SVG(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "svg:svg";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        if (this.marker == -1001) {
            return new Status(1);
        }
        if (this.marker == -1000) {
            object = this.properties.get("font-family").getString();
            String string = this.properties.get("font-style").getString();
            String string2 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), (String)object, string, string2, n);
            this.breakBefore = this.properties.get("break-before").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.width = this.properties.get("width").getLength().mvalue();
            this.height = this.properties.get("height").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            if (area instanceof BlockArea) {
                area.end();
            }
            this.marker = 0;
            if (this.breakBefore == 3) {
                return new Status(4);
            }
            if (this.breakBefore == 5) {
                return new Status(6);
            }
            if (this.breakBefore == 4) {
                return new Status(5);
            }
        }
        if (this.spaceBefore != 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        object = new SVGArea(this.fs, this.width, this.height);
        ((Area)object).start();
        area.addChild((Box)object);
        int n = this.children.size();
        int n2 = 0;
        while (n2 < n) {
            FONode fONode = (FONode)this.children.elementAt(n2);
            Status status = fONode.layout((Area)object);
            if (status.isIncomplete()) {
                return status;
            }
            ++n2;
        }
        ((Area)object).end();
        area.increaseHeight(((Area)object).getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        if (this.breakAfter == 3) {
            this.marker = -1001;
            return new Status(4);
        }
        if (this.breakAfter == 5) {
            this.marker = -1001;
            return new Status(6);
        }
        if (this.breakAfter == 4) {
            this.marker = -1001;
            return new Status(5);
        }
        return new Status(1);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new SVG(fObj, propertyList);
        }
    }
}

