/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;

public class PDFPage
extends PDFObject {
    protected PDFPages parent;
    protected PDFResources resources;
    protected PDFStream contents;
    protected int pagewidth;
    protected int pageheight;
    protected PDFAnnotList annotList;

    public PDFPage(int n, PDFResources pDFResources, PDFStream pDFStream, int n2, int n3) {
        super(n);
        this.resources = pDFResources;
        this.contents = pDFStream;
        this.pagewidth = n2;
        this.pageheight = n3;
        this.annotList = null;
    }

    public void setParent(PDFPages pDFPages) {
        this.parent = pDFPages;
    }

    public void setAnnotList(PDFAnnotList pDFAnnotList) {
        this.annotList = pDFAnnotList;
    }

    public String toPDF() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = stringBuffer.append(this.number + " " + this.generation + " obj\n" + "<< /Type /Page\n" + "/Parent " + this.parent.referencePDF() + "\n" + "/MediaBox [ 0 0 " + this.pagewidth + " " + this.pageheight + " ]\n" + "/Resources " + this.resources.referencePDF() + "\n" + "/Contents " + this.contents.referencePDF() + "\n");
        if (this.annotList != null) {
            stringBuffer = stringBuffer.append("/Annots " + this.annotList.referencePDF() + "\n");
        }
        stringBuffer = stringBuffer.append(">>\nendobj\n");
        return stringBuffer.toString();
    }
}

