/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.InlineArea;
import org.apache.fop.layout.InlineSpace;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.CodePointMapping;

public class LineArea
extends Area {
    protected int lineHeight;
    protected int halfLeading;
    protected int nominalFontSize;
    protected int nominalGlyphHeight;
    protected int allocationHeight;
    protected int startIndent;
    protected int endIndent;
    private int placementOffset;
    private FontState currentFontState;
    private float red;
    private float green;
    private float blue;
    private int wrapOption;
    private int whiteSpaceTreatment;
    protected int finalWidth = 0;
    protected int wordWidth = 0;
    protected static final int NOTHING = 0;
    protected static final int WHITESPACE = 1;
    protected static final int TEXT = 2;
    protected int prev = 0;
    protected int wordStart;
    protected int wordLength = 0;
    protected int spaceWidth = 0;
    protected Vector pendingAreas = new Vector();
    protected int pendingWidth = 0;

    public LineArea(FontState fontState, int n, int n2, int n3, int n4, int n5) {
        super(fontState);
        this.currentFontState = fontState;
        this.lineHeight = n;
        this.nominalFontSize = fontState.getFontSize();
        this.nominalGlyphHeight = fontState.getAscender() - fontState.getDescender();
        this.placementOffset = fontState.getAscender();
        this.contentRectangleWidth = n3 - n4 - n5;
        this.fontState = fontState;
        this.allocationHeight = this.nominalGlyphHeight;
        this.halfLeading = this.lineHeight - this.allocationHeight;
        this.startIndent = n4;
        this.endIndent = n5;
    }

    public void render(Renderer renderer) {
        renderer.renderLineArea(this);
    }

    public int addText(char[] cArray, int n, int n2) {
        boolean bl = false;
        this.wordStart = n;
        this.wordLength = 0;
        this.wordWidth = 0;
        int n3 = n;
        while (n3 < n2) {
            int n4 = cArray[n3];
            if (n4 > 127) {
                int n5 = CodePointMapping.map[n4];
                if (n5 != 0) {
                    n4 = cArray[n3] = n5;
                } else {
                    System.err.print("ch" + n4 + "?");
                    cArray[n3] = 35;
                    n4 = 35;
                }
            }
            int n6 = this.currentFontState.width(n4);
            if (n4 == 32 || n4 == 10 || n4 == 13 || n4 == 9) {
                if (this.prev == 1) {
                    if (this.whiteSpaceTreatment == 1) {
                        if (n4 == 32) {
                            this.spaceWidth += this.currentFontState.width(32);
                        } else {
                            if (n4 == 10) {
                                return n3;
                            }
                            if (n4 == 9) {
                                this.spaceWidth += 8 * this.currentFontState.width(32);
                            }
                        }
                    }
                } else if (this.prev == 2) {
                    if (this.spaceWidth > 0) {
                        this.addChild(new InlineSpace(this.spaceWidth));
                        this.finalWidth += this.spaceWidth;
                        this.spaceWidth = 0;
                    }
                    Enumeration enumeration = this.pendingAreas.elements();
                    while (enumeration.hasMoreElements()) {
                        InlineArea inlineArea = (InlineArea)enumeration.nextElement();
                        this.addChild(inlineArea);
                    }
                    this.finalWidth += this.pendingWidth;
                    this.pendingWidth = 0;
                    this.pendingAreas = new Vector();
                    if (this.wordLength > 0) {
                        this.addChild(new InlineArea(this.currentFontState, this.red, this.green, this.blue, new String(cArray, this.wordStart, this.wordLength), this.wordWidth));
                        this.finalWidth += this.wordWidth;
                        this.wordWidth = 0;
                    }
                    this.prev = 1;
                    if (this.whiteSpaceTreatment != 3) {
                        this.spaceWidth = this.currentFontState.width(32);
                    }
                    if (this.whiteSpaceTreatment == 1) {
                        if (n4 == 10) {
                            return n3;
                        }
                        if (n4 == 9) {
                            this.spaceWidth = this.currentFontState.width(32);
                        }
                    }
                } else if (this.whiteSpaceTreatment == 1) {
                    this.prev = 1;
                    this.spaceWidth = this.currentFontState.width(32);
                } else {
                    ++n;
                }
            } else {
                if (this.prev == 1) {
                    this.wordWidth = n6;
                    if (this.finalWidth + this.spaceWidth + this.wordWidth > this.contentRectangleWidth) {
                        if (bl) {
                            System.err.print(">");
                        }
                        if (this.wrapOption == 1) {
                            return n3;
                        }
                    }
                    this.prev = 2;
                    this.wordStart = n3;
                    this.wordLength = 1;
                } else if (this.prev == 2) {
                    ++this.wordLength;
                    this.wordWidth += n6;
                } else {
                    this.prev = 2;
                    this.wordStart = n3;
                    this.wordLength = 1;
                    this.wordWidth = n6;
                }
                if (this.finalWidth + this.spaceWidth + this.pendingWidth + this.wordWidth > this.contentRectangleWidth) {
                    if (this.wordStart == n) {
                        bl = true;
                        if (this.finalWidth > 0) {
                            return this.wordStart;
                        }
                    } else if (this.wrapOption == 1) {
                        return this.wordStart;
                    }
                }
            }
            ++n3;
        }
        if (this.prev == 2) {
            this.pendingAreas.addElement(new InlineArea(this.currentFontState, this.red, this.green, this.blue, new String(cArray, this.wordStart, this.wordLength), this.wordWidth));
            this.pendingWidth += this.wordWidth;
            this.wordWidth = 0;
        }
        if (bl) {
            System.err.print(">");
        }
        return -1;
    }

    public void addPending() {
        if (this.spaceWidth > 0) {
            this.addChild(new InlineSpace(this.spaceWidth));
            this.finalWidth += this.spaceWidth;
            this.spaceWidth = 0;
        }
        Enumeration enumeration = this.pendingAreas.elements();
        while (enumeration.hasMoreElements()) {
            InlineArea inlineArea = (InlineArea)enumeration.nextElement();
            this.addChild(inlineArea);
        }
        this.finalWidth += this.pendingWidth;
        this.pendingWidth = 0;
        this.pendingAreas = new Vector();
    }

    public void align(int n) {
        switch (n) {
            case 3: {
                int n2 = this.contentRectangleWidth - this.finalWidth;
                this.endIndent += n2;
                break;
            }
            case 2: {
                int n3 = this.contentRectangleWidth - this.finalWidth;
                this.startIndent += n3;
                break;
            }
            case 1: {
                int n4 = (this.contentRectangleWidth - this.finalWidth) / 2;
                this.startIndent += n4;
                this.endIndent += n4;
                break;
            }
            case 4: {
                InlineSpace inlineSpace;
                Object object;
                Vector<InlineSpace> vector = new Vector<InlineSpace>();
                int n5 = 0;
                Enumeration enumeration = this.children.elements();
                while (enumeration.hasMoreElements()) {
                    object = (Box)enumeration.nextElement();
                    if (!(object instanceof InlineSpace)) continue;
                    inlineSpace = (InlineSpace)object;
                    vector.addElement(inlineSpace);
                    ++n5;
                }
                int n6 = n5 > 0 ? (this.contentRectangleWidth - this.finalWidth) / n5 : 0;
                object = vector.elements();
                while (object.hasMoreElements()) {
                    inlineSpace = (InlineSpace)object.nextElement();
                    int n7 = inlineSpace.getSize();
                    inlineSpace.setSize(n7 + n6);
                }
                break;
            }
        }
    }

    public void changeColor(float f, float f2, float f3) {
        this.red = f;
        this.green = f2;
        this.blue = f3;
    }

    public void changeFont(FontState fontState) {
        this.currentFontState = fontState;
    }

    public void changeWhiteSpaceTreatment(int n) {
        this.whiteSpaceTreatment = n;
    }

    public void changeWrapOption(int n) {
        this.wrapOption = n;
    }

    public int getEndIndent() {
        return this.endIndent;
    }

    public int getHeight() {
        return this.allocationHeight;
    }

    public int getPlacementOffset() {
        return this.placementOffset;
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    public boolean isEmpty() {
        return this.prev == 0;
    }

    public Vector getPendingAreas() {
        return this.pendingAreas;
    }

    public int getPendingWidth() {
        return this.pendingWidth;
    }

    public void setPendingAreas(Vector vector) {
        this.pendingAreas = vector;
    }

    public void setPendingWidth(int n) {
        this.pendingWidth = n;
    }
}

