/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.SequenceSpecifier;
import org.apache.fop.layout.PageMasterFactory;

public class SequenceSpecification
extends FObj {
    private PageSequence pageSequence;
    private LayoutMasterSet layoutMasterSet;
    private PageMasterFactory firstPMF;
    private PageMasterFactory currentPMF;

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected SequenceSpecification(FObj fObj, PropertyList propertyList) throws FOPException {
        super(fObj, propertyList);
        this.name = "fo:sequence-specification";
        if (!fObj.getName().equals("fo:page-sequence")) {
            throw new FOPException("sequence-specification must be child of page-sequence, not " + fObj.getName());
        }
        this.pageSequence = (PageSequence)fObj;
        this.pageSequence.setSequenceSpecification(this);
        this.firstPMF = null;
        this.currentPMF = null;
    }

    protected void addSequenceSpecifier(SequenceSpecifier sequenceSpecifier) {
        if (this.firstPMF == null) {
            this.firstPMF = sequenceSpecifier.getPageMasterFactory();
        } else {
            this.currentPMF.setNext(sequenceSpecifier.getPageMasterFactory());
        }
        this.currentPMF = sequenceSpecifier.getPageMasterFactory();
    }

    protected PageMasterFactory getFirstPageMasterFactory() {
        return this.firstPMF;
    }

    LayoutMasterSet getLayoutMasterSet() {
        return this.layoutMasterSet;
    }

    protected void setLayoutMasterSet(LayoutMasterSet layoutMasterSet) {
        this.layoutMasterSet = layoutMasterSet;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new SequenceSpecification(fObj, propertyList);
        }
    }
}

