/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.FontState;

public class ListBlock
extends FObj {
    FontState fs;
    int align;
    int alignLast;
    int breakBefore;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    int provisionalDistanceBetweenStarts;
    int provisionalLabelSeparation;
    int spaceBetweenListRows = 0;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public ListBlock(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:list-block";
    }

    public Status layout(Area area) throws FOPException {
        Object object;
        if (this.marker == -1000) {
            object = this.properties.get("font-family").getString();
            String string = this.properties.get("font-style").getString();
            String string2 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), (String)object, string, string2, n);
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.provisionalDistanceBetweenStarts = this.properties.get("provisional-distance-between-starts").getLength().mvalue();
            this.provisionalLabelSeparation = this.properties.get("provisional-label-separation").getLength().mvalue();
            this.spaceBetweenListRows = 0;
            this.marker = 0;
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.spaceBefore != 0) {
                area.addDisplaySpace(this.spaceBefore);
            }
            if (this.isInListBody) {
                this.startIndent += this.bodyIndent + this.distanceBetweenStarts;
                this.bodyIndent = this.startIndent;
            }
        }
        object = new BlockArea(this.fs, area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, 0, this.align, this.alignLast, this.lineHeight);
        ((Area)object).setPage(area.getPage());
        ((BlockArea)object).start();
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            if (!(this.children.elementAt(n2) instanceof ListItem)) {
                System.err.println("WARNING: This version of FOP requires list-items inside list-blocks");
                return new Status(1);
            }
            ListItem listItem = (ListItem)this.children.elementAt(n2);
            listItem.setDistanceBetweenStarts(this.provisionalDistanceBetweenStarts);
            listItem.setLabelSeparation(this.provisionalLabelSeparation);
            listItem.setBodyIndent(this.bodyIndent);
            Status status = listItem.layout((Area)object);
            if (status.isIncomplete()) {
                this.marker = n2;
                ((BlockArea)object).end();
                area.addChild((Box)object);
                area.increaseHeight(((Area)object).getHeight());
                return status;
            }
            ++n2;
        }
        ((BlockArea)object).end();
        area.addChild((Box)object);
        area.increaseHeight(((Area)object).getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return new Status(1);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new ListBlock(fObj, propertyList);
        }
    }
}

