/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.RuleArea;

public class DisplayRule
extends FObj {
    public static FObj.Maker maker() {
        return new Maker();
    }

    public DisplayRule(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:display-rule";
    }

    public Status layout(Area area) throws FOPException {
        String string = this.properties.get("font-family").getString();
        String string2 = this.properties.get("font-style").getString();
        String string3 = this.properties.get("font-weight").getString();
        int n = this.properties.get("font-size").getLength().mvalue();
        FontState fontState = new FontState(area.getFontInfo(), string, string2, string3, n);
        int n2 = this.properties.get("text-align").getEnum();
        int n3 = this.properties.get("start-indent").getLength().mvalue();
        int n4 = this.properties.get("end-indent").getLength().mvalue();
        int n5 = this.properties.get("space-before.optimum").getLength().mvalue();
        int n6 = this.properties.get("space-after.optimum").getLength().mvalue();
        int n7 = this.properties.get("rule-thickness").getLength().mvalue();
        int n8 = 0;
        ColorType colorType = this.properties.get("color").getColorType();
        float f = colorType.red();
        float f2 = colorType.green();
        float f3 = colorType.blue();
        if (area instanceof BlockArea) {
            area.end();
        }
        if (n5 != 0) {
            area.addDisplaySpace(n5);
        }
        if (this.isInLabel) {
            n4 += area.getAllocationWidth() - this.distanceBetweenStarts - (n3 += this.bodyIndent) + this.labelSeparation;
        }
        if (this.isInListBody) {
            n3 += this.bodyIndent + this.distanceBetweenStarts;
        }
        if (this.isInTableCell) {
            n3 += this.forcedStartOffset;
            n4 += area.getAllocationWidth() - this.forcedWidth - this.forcedStartOffset;
        }
        RuleArea ruleArea = new RuleArea(fontState, area.getAllocationWidth(), area.spaceLeft(), n3, n4, n2, n7, n8, f, f2, f3);
        area.addChild(ruleArea);
        area.increaseHeight(ruleArea.getHeight());
        if (n6 != 0) {
            area.addDisplaySpace(n6);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return new Status(1);
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new DisplayRule(fObj, propertyList);
        }
    }
}

