/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FOTreeBuilder;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.render.Renderer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class Driver {
    protected FOTreeBuilder treeBuilder = new FOTreeBuilder();
    protected AreaTree areaTree;
    protected Renderer renderer;
    protected PrintWriter writer;

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public void setRenderer(String string, String string2) {
        this.renderer = this.createRenderer(string);
        this.renderer.setProducer(string2);
    }

    protected Renderer createRenderer(String string) {
        System.err.println("using renderer " + string);
        try {
            return (Renderer)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            System.err.println(string + " is not a renderer");
        }
        return null;
    }

    public void addElementMapping(ElementMapping elementMapping) {
        elementMapping.addToBuilder(this.treeBuilder);
    }

    public void addElementMapping(String string) {
        this.createElementMapping(string).addToBuilder(this.treeBuilder);
    }

    protected ElementMapping createElementMapping(String string) {
        System.err.println("using element mapping " + string);
        try {
            return (ElementMapping)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Could not find " + string);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Could not instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Could not access " + string);
        }
        catch (ClassCastException classCastException) {
            System.err.println(string + " is not an element mapping");
        }
        return null;
    }

    public DocumentHandler getDocumentHandler() {
        return this.treeBuilder;
    }

    public void buildFOTree(Parser parser, InputSource inputSource) throws FOPException {
        parser.setDocumentHandler(this.treeBuilder);
        try {
            parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() instanceof FOPException) {
                throw (FOPException)sAXException.getException();
            }
            throw new FOPException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new FOPException(iOException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void buildFOTree(Document document) throws FOPException {
        char[] cArray = null;
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        Node node = document;
        try {
            block12: while (true) {
                Node node2;
                if (node == null) {
                    return;
                }
                block1 : switch (node.getNodeType()) {
                    case 9: {
                        this.treeBuilder.startDocument();
                        break;
                    }
                    case 3: 
                    case 4: {
                        String string = node.getNodeValue();
                        int n = string.length();
                        if (cArray == null || cArray.length < n) {
                            cArray = new char[n];
                        }
                        string.getChars(0, n, cArray, 0);
                        this.treeBuilder.characters(cArray, 0, n);
                        break;
                    }
                    case 7: {
                        this.treeBuilder.processingInstruction(node.getNodeName(), node.getNodeValue());
                        break;
                    }
                    case 1: {
                        NamedNodeMap namedNodeMap = node.getAttributes();
                        attributeListImpl.clear();
                        int n = namedNodeMap.getLength() - 1;
                        while (true) {
                            if (n < 0) {
                                this.treeBuilder.startElement(node.getNodeName(), attributeListImpl);
                                break block1;
                            }
                            node2 = (Attr)namedNodeMap.item(n);
                            attributeListImpl.addAttribute(node2.getName(), "CDATA", node2.getValue());
                            --n;
                        }
                    }
                }
                node2 = node.getFirstChild();
                if (node2 != null) {
                    node = node2;
                    continue;
                }
                while (true) {
                    if (node == null) continue block12;
                    switch (node.getNodeType()) {
                        case 9: {
                            this.treeBuilder.endDocument();
                            break;
                        }
                        case 1: {
                            this.treeBuilder.endElement(node.getNodeName());
                            break;
                        }
                    }
                    node2 = node.getNextSibling();
                    if (node2 != null) {
                        node = node2;
                        continue block12;
                    }
                    node = node.getParentNode();
                }
                break;
            }
        }
        catch (SAXException sAXException) {
            throw new FOPException(sAXException.getMessage());
        }
    }

    public void setWriter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void format() throws FOPException {
        FontInfo fontInfo = new FontInfo();
        this.renderer.setupFontInfo(fontInfo);
        this.areaTree = new AreaTree();
        this.areaTree.setFontInfo(fontInfo);
        this.treeBuilder.format(this.areaTree);
    }

    public void render() throws IOException {
        this.renderer.render(this.areaTree, this.writer);
    }
}

