#!/bin/sh

. $MACRO_DIR/makegen/makegen.cf

dll=$1
dllsrc=`echo $2 | sed "s/,/ /g"`
dllobj=`echo $3 | sed "s/,/ /g"`
shift

for src in $dllsrc
do
	if test -c /dev/tty
	then
		$ECHO_N ".$ECHO_C" > /dev/tty
	fi
	base=`echo $src | sed "s/\..*//"`
	obj=`echo $src | sed "s/\.c\$/.o/"`
	dllobj="$dllobj $obj"
	echo	"$obj : $src Makefile.full"
	echo	'	$(CC) $(CC_FLAGS) -c '"$src"
	echo
	echo	"clean ::"
	echo	"	rm -f $obj"
	echo
done

echo
echo	"# Make rules for building $dll"
echo
echo	"all : $dll.dll"
echo
echo	"$dll.dll : $dllobj Makefile.full"
echo    'ifeq ($(OS_ARCH),OS_2)'
echo	'	@echo LIBRARY ' $dll ' INITINSTANCE > ' $dll.def
echo	'	@echo DATA MULTIPLE NONSHARED >> ' $dll.def
echo	'	@echo EXPORTS >> ' $dll.def
echo	'	emxexp ' $dllobj ' >> ' $dll.def
echo	'	$(subst Zexe,Zdll,$(LINK)) $(CC_FLAGS)'" $dllobj -o $dll.dll $dll.def "'$(LD_LIBS)'
echo	'	emximp -o ' lib$dll'.a ' $dll'.def'
echo	'	emximp -o ' $dll'.lib ' $dll'.def'
echo    "else"
echo	"	@echo DLL not supported on this platform."
echo    "endif"
echo
echo	"clean :: "
echo	"	rm -f $dll"
echo
