<?xml version="1.0"?> 

<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl" 
                xmlns:lotusxsl="http://xsl.lotus.com/">

  <!-- Root xsl:template - start processing here -->
  <xsl:template match="/">
    <HTML>
      <HEAD>
        <META http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
        <META http-equiv="Expires" content="0"/>
      </HEAD>
      <BODY>
        <H1>General Pattern Match Test</H1>
        <P>Should show table with Column and row headings underlined, and 
        the row marked critical in yellow background.</P>
		    <xsl:apply-templates/>
      </BODY>
    </HTML>
  </xsl:template>
 
  <!-- document xsl:template -->
  <xsl:template match="*" priority="-1">
	  <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="table">
	  <TABLE><xsl:apply-templates/></TABLE>
  </xsl:template>
  
  <xsl:template match="table/row">
	  <TR><xsl:apply-templates/></TR>
  </xsl:template>

  <xsl:template match="table/row[@test='critical']">
	  <TR style="background-color:yellow"><xsl:apply-templates/></TR>
  </xsl:template>
  
  <xsl:template match="table/row/empty-cell | column-header-cell | cell">
	  <TD><xsl:apply-templates/></TD>
  </xsl:template>

  <xsl:template match="row[first-of-type()]/column-header-cell" priority="1">
	  <TH><SPAN style="text-decoration:underline"><xsl:apply-templates/></SPAN></TH>
  </xsl:template>

  <xsl:template match="cell[first-of-type()]" priority="1">
	  <TH><SPAN style="text-decoration:underline"><xsl:apply-templates/></SPAN></TH>
  </xsl:template>
  
</xsl:stylesheet>