<?xml version="1.0"?> 

<!-- Test for numbering -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">

  <!-- Root template - start processing here -->
  <xsl:template match="/">
    <HTML>
      <HEAD>
        <META http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
        <META http-equiv="Expires" content="0"/>
      </HEAD>
      <BODY>
		    <xsl:apply-templates/>
      </BODY>
    </HTML>
  </xsl:template>
	  
	<xsl:template match="doc">
	  <H1>Test for xsl:number</H1>
	  <xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="title" priority="-1">
	  <P>
	     (any(a): count="title" <xsl:number level="any"
	                 count="title"
	                 from="title"
	                 format="A. "/>)
	     (any(b) - count="chapter|section|subsection": <xsl:number level="any"
	                 count="chapter|section|subsection"
	                 from="chapter|section|subsection"
	                 format="A. "/>)
	     <xsl:apply-templates/>
	  </P>
	</xsl:template>
	  
	<xsl:template match="chapter//title">
	  <P>
	     (single(c): <xsl:number level="single"
	                 count="chapter|section|subsection"
	                 from="chapter|section|subsection"
	                 format="1."/>) 
	     (multi(d): <xsl:number level="multi"
	                 count="chapter|section|subsection"
	                 from="chapter|section|subsection"
	                 format="1.1."/>) 
	     (any(e): <xsl:number level="any"
	                 count="title"
	                 format="A. "/>)
	     <xsl:apply-templates/>
	  </P>
	</xsl:template>

	<xsl:template match="xappendix//title">
	  <P>
	     (single(f): <xsl:number level="single"
	                 count="appendix|section|subsection"
	                 from="appendix|section|subsection"
	                 format="1."/>) 
	     (multi(g): <xsl:number level="multi"
	                 count="appendix|section|subsection"
	                 from="appendix|section|subsection"
	                 format="A.1.I. "/>) 
	     (any(h): <xsl:number level="any"
	                 count="title"
	                 from="title"
	                 format="A. "/>)
	     <xsl:apply-templates/>
	  </P>
	</xsl:template>
   
</xsl:stylesheet>