<?xml version="1.0" standalone='no'?>

<!DOCTYPE xsl:stylesheet SYSTEM "../xsl-html.dtd">

<!--
 * $Id$
 * 
 * Copyright (c) 1998 Lotus Corporation, Inc. All Rights Reserved.
 *				This software is provided without a warranty of any kind.
 * 
 * $State$
 * 
 * @author Scott Boag (scott_boag@lotus.com)
-->

<!-- Formatting instructions for XSL Readme page -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl"
                xmlns="http://www.w3.org/TR/REC-html40"
                result-ns="">

  <xsl:id attribute="id"/>
  <xsl:preserve-space element="human-resource"/>
  
  <xsl:attribute-set name="NEW"> 
    <xsl:attribute name="class">new</xsl:attribute>
  </xsl:attribute-set>

  <!-- Root template - start processing here -->
  <xsl:template match="/">
    <HTML>
      <HEAD>
        <META http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
        <META http-equiv="Expires" content="0"/>
        
        <STYLE type="text/css"> 
          BODY { margin-left:2em;
                 background-color:#C0C0C0;
                 background-image:url("images/Blutop2.gif")} 
          .section { margin-left:2em;} 
          .subsection { margin-left:2em;} 
          .docFieldLabels { font-weight:bold; } 
          .important { color:red;font-style:italic; }
          .new { color:blue; }
          .glossaryLabel { font:bold; }
          header-table-col1 {width:24%; }
          header-table-col2 {width:*; }
          header-table {border-spacing:0; border: inset 5pt;}
          note-border { border:1px solid black;color:teal; }
        </STYLE>

      </HEAD>
      <BODY>
		    <xsl:apply-templates/>
      </BODY>
    </HTML>
  </xsl:template>

  <xsl:template match="sofware-release-note">
    <xsl:apply-templates select="text"/>
  </xsl:template>

  <xsl:template match="text">
      <TABLE class="header-table">
      	<TR>
      		<TD class="header-table-col1">
      		  <IMG src="images/3611beac.jpg" alt="Rabbit blowing horn"></IMG>
      		</TD>
      		<TD  class="col2"> 
       		  <IMG src="images/wthowtw.gif"  alt="Work the Web"></IMG>
            <H1><xsl:apply-templates select="front/titlePage/docTitle/titlePart"/></H1>
            <SPAN class="docFieldLabels">Document Author: </SPAN> 
            <xsl:apply-templates select="front/titlePage/docAuthor"/>
            <BR/>
            <SPAN class="docFieldLabels">Document Date: </SPAN> 
            <xsl:apply-templates select="front/titlePage/docDate"/>
            <BR/>
            <SPAN class="docFieldLabels">Software Version: </SPAN>
            <xsl:value-of select="/sofware-release-note/SOFTPKG/@VERSION"/> 
            [<xsl:value-of select="/sofware-release-note/SOFTPKG/@DATE"/>]
      		</TD>
      	</TR>
      </TABLE>
    <xsl:apply-templates select="section"/>
  </xsl:template>

  <xsl:template match="br">
    <BR/>
  </xsl:template>

  <xsl:template match="section-ref">
    <A href="#{@idref}"><xsl:value-of select="id(@idref)/@title"/></A>
  </xsl:template>
  
  <xsl:template match="section">
    <HR/>
    <DIV class="section">
      <H2>
        <xsl:number level="multi" count="section|subsection" format="1.1. "/>
        <A name="{@id}"><xsl:value-of select="@title"/></A>
      </H2>
      <xsl:apply-templates/>
    </DIV>
  </xsl:template>

  <xsl:template match="subsection">
    <DIV class="subsection">
      <H3>
        <xsl:number level="multi" count="section|subsection" format="1.1. "/>
        <A name="{@id}"><xsl:value-of select="@title"/></A>
      </H3>
      <xsl:apply-templates/>
    </DIV>
  </xsl:template>

  <xsl:template match="p">
      <P><xsl:apply-templates/></P>
  </xsl:template>

  <xsl:template match="p[@type='important']">
    <P class="important"><xsl:apply-templates/></P>
  </xsl:template>

  <xsl:template match="important">
    <SPAN class="important">
    <xsl:apply-templates/></SPAN>
  </xsl:template>
  
  <xsl:template match="list[@type='bulleted']">
    <UL><xsl:apply-templates/></UL>
  </xsl:template>

  <xsl:template match="list" priority="-1">
    <UL>
      <xsl:apply-templates/>
    </UL>
  </xsl:template>

  <xsl:template match="list[@type='gloss']">
    <DL><xsl:apply-templates/></DL>
  </xsl:template>

  <xsl:template match="list[@type='gloss']/label" priority="1">
    <DT class="glossaryLabel"><xsl:apply-templates/></DT>
  </xsl:template>

  <xsl:template match="list[@type='gloss']/item" priority="1">
    <DD>
      <xsl:apply-templates/>
    </DD>
  </xsl:template>

  <xsl:template match="list[@type='ordered']">
    <OL><xsl:apply-templates/></OL>
  </xsl:template>

  <xsl:template match="list[@type='ordered']/item" priority="1">
    <LI>
      <xsl:apply-templates/>
    </LI>
  </xsl:template>

  <xsl:template match="list/item">
    <LI>
      <xsl:apply-templates/>
    </LI>
  </xsl:template>
  
  <xsl:template match="resource" priority="-1">
    <A href="id({@idref})/@location">
      <xsl:value-of select="@long-title"/>
    </A>
  </xsl:template>
  

  <xsl:template match="resource-ref" priority="-1">
    <xsl:for-each select="id(@idref)">
      <A href="{@location}">
        <xsl:value-of select="@long-title"/>
      </A>
    </xsl:for-each>
  </xsl:template>
 
  <xsl:template match="resource-ref[@use-short='yes']">
    <xsl:for-each select="id(@idref)">
      <xsl:value-of select="@name"/>
    </xsl:for-each>
  </xsl:template>
 
  <xsl:template match="id('contact-info')//item[last-of-type()]/human-resource-ref">
    <xsl:for-each select="id(@idref)">
      <A href="mailto:{@mailto}">
        <xsl:value-of select="@name"/>
      </A>
      <PRE><xsl:apply-templates select="id(@id)"/></PRE>
    </xsl:for-each>
  </xsl:template>

  <xsl:template match="human-resource-ref" priority="-1">
    <xsl:for-each select="id(@idref)">
      <A href="mailto:{@mailto}">
        <xsl:value-of select="@name"/>
      </A>
    </xsl:for-each>
  </xsl:template>

  <!-- <term> contains a single-word, multi-word or symbolic 
       designation which is regarded as a technical term. --> 
  <xsl:template match="term">
    <DFN><xsl:apply-templates/></DFN>
  </xsl:template>

  <xsl:template match="pre">
    <PRE><xsl:apply-templates/></PRE>
  </xsl:template>
  
  <xsl:template match="note">
    <SPAN class="note-border">[NOTE: <xsl:apply-templates/>]</SPAN>
  </xsl:template>

  <xsl:template match="code">
    <CODE><xsl:apply-templates/></CODE>
  </xsl:template>

  <xsl:template match="new">
    <INS><xsl:apply-templates/></INS>
  </xsl:template>

  <xsl:template match="del">
    <DEL><xsl:apply-templates/></DEL>
  </xsl:template>
  
  <xsl:template match="text()">
      <xsl:choose>
        <xsl:when test="ancestor(*[@new='true'])[not(text()='')]">
          <INS><xsl:value-of select="."/></INS>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
  </xsl:template>

</xsl:stylesheet>