/* An OS/2 REXX script to send a signal to a running EMX program based on  */
/* a supplied pid file and signal name or number. This script requires     */
/* EMXKILL.EXE be in the current directory or in the path.                 */

/* NOTE: This program must be run from the computer currently running      */
/*       the EMX program. It can not be run accros a LAN                   */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Get paramters. */
PARSE ARG signalNumber pidfile

/* Convert signalNumber to upper case. */
signalNumber = translate(signalNumber)

/* Display help if requested. */
if ( (signalNumber = "HELP") | (left(signalNumber,2) = "-H") | (signalNumber = "?") ) then
    signal USAGE

/* Handle usage problems. */
if ((arg() = 0) | (strip(pidfile) = "")) then
    signal USAGE

/* Translate signal name to number if needed. */
/* NOTE: Values taken from EMX sys/signal.h   */
SELECT
    WHEN (signalNumber = "SIGHUP") THEN
        signalNumber = 1 /* Hangup */
    WHEN (signalNumber = "SIGINT") THEN
        signalNumber = 2 /* Interrupt (Ctrl-C) */
    WHEN (signalNumber = "SIGQUIT") THEN
        signalNumber = 3 /* Quit */
    WHEN (signalNumber = "SIGILL") THEN
        signalNumber = 4 /* Illegal instruction */
    WHEN (signalNumber = "SIGTRAP") THEN
        signalNumber = 5 /* Single step (debugging) */
    WHEN (signalNumber = "SIGABRT") THEN
        signalNumber = 6 /* abort () */
    WHEN (signalNumber = "SIGEMT") THEN
        signalNumber = 7 /* EMT instruction */
    WHEN (signalNumber = "SIGFPE") THEN
        signalNumber = 8 /* Floating point */
    WHEN (signalNumber = "SIGKILL") THEN
        signalNumber = 9 /* Kill process */
    WHEN (signalNumber = "SIGBUS") THEN
        signalNumber = 10 /* Bus error */
    WHEN (signalNumber = "SIGSEGV") THEN
        signalNumber = 11 /* Segmentation fault */
    WHEN (signalNumber = "SIGSYS") THEN
        signalNumber = 12 /* Invalid argument to system call */
    WHEN (signalNumber = "SIGPIPE") THEN
        signalNumber = 13 /* Broken pipe */
    WHEN (signalNumber = "SIGALRM") THEN
        signalNumber = 14 /* Alarm */
    WHEN (signalNumber = "SIGTERM") THEN
        signalNumber = 15 /* Termination, process killed */
    WHEN (signalNumber = "SIGUSR1") THEN
        signalNumber = 16 /* User-defined signal #1 */
    WHEN (signalNumber = "SIGUSR2") THEN
        signalNumber = 17 /* User-defined signal #2 */
    WHEN (signalNumber = "SIGCHLD") THEN
        signalNumber = 18 /* Death of a child process */
    WHEN (signalNumber = "SIGBREAK") THEN
        signalNumber = 21 /* Break (Ctrl-Break) */
    OTHERWISE
        /* Assume the signal number was passed directly. */
END

/* Test for existance of PID file */
result = SysFileTree(pidfile, filefound, "F")
if result > 0 then
    signal ERROR
if filefound.0 \= 1 then
    signal NOTFOUND

/* Get the PID from the PIDFILE. */
pid = strip(linein(pidfile))

/* Send the signal. */
'@emxkill' signalNumber pid

RETURN

USAGE:
SAY
SAY "Usage: SENDSIGNAL signalName|signalNumber pidfile"
SAY
SAY "Signals:  Name    Number   Description"
Say "          SIGHUP     1     Hangup"
Say "          SIGINT     2     Interrupt (Ctrl-C)"
Say "          SIGQUIT    3     Quit"
Say "          SIGILL     4     Illegal instruction"
Say "          SIGTRAP    5     Single step (debugging)"
Say "          SIGABRT    6     abort ()"
Say "          SIGEMT     7     EMT instruction"
Say "          SIGFPE     8     Floating point"
Say "          SIGKILL    9     Kill process"
Say "          SIGBUS    10     Bus error"
Say "          SIGSEGV   11     Segmentation fault"
Say "          SIGSYS    12     Invalid argument to system call"
Say "          SIGPIPE   13     Broken pipe"
Say "          SIGALRM   14     Alarm"
Say "          SIGTERM   15     Termination, process killed"
Say "          SIGUSR1   16     User-defined signal #1"
Say "          SIGUSR2   17     User-defined signal #2"
Say "          SIGCHLD   18     Death of a child process"
Say "          SIGBREAK  21     Break (Ctrl-Break)"

EXIT

ERROR:
SAY
SAY "An ERROR has occured."
SAY
EXIT

NOTFOUND:
SAY
SAY "PID file '"pidfile"' not found."
SAY
EXIT

