/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.psd;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.psd.PSDFileHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class PSDColorMode {
    int length;
    byte[] data;
    byte[] cmap;

    PSDColorMode(DataInputStream dataInputStream, PSDFileHeader pSDFileHeader) throws JimiException, IOException {
        this.length = dataInputStream.readInt();
        if (this.length > 0) {
            this.data = new byte[this.length];
            dataInputStream.read(this.data, 0, this.length);
            if (pSDFileHeader.mode == 2) {
                this.buildCMAP();
            }
        }
    }

    private void buildCMAP() {
        if (this.cmap == null) {
            this.cmap = new byte[this.data.length];
            int n = this.data.length / 3;
            int n2 = 2 * n;
            int n3 = 0;
            int n4 = 0;
            while (n3 < n) {
                this.cmap[n4] = this.data[n3];
                this.cmap[n4 + 1] = this.data[n3 + n];
                this.cmap[n4 + 2] = this.data[n3 + n2];
                ++n3;
                n4 += 3;
            }
        }
    }

    public String toString() {
        return "PSDColorMode length " + this.length;
    }
}

