/*
 * Copyright (C) 2008-2009 Alexei Chaloupov <alexei.chaloupov@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef CERTIFICATEINFO_H
#define CERTIFICATEINFO_H

#include <QtGui/QDialog>
#include <QtNetwork/QSslCertificate>
#include <QtNetwork/QSslError>

QT_BEGIN_NAMESPACE
class Ui_CertificateInfo;
QT_END_NAMESPACE

class QSslSocket;

class CertificateInfo : public QDialog
{
    Q_OBJECT
public:
    CertificateInfo(QString host, QWidget *parent = 0);
    ~CertificateInfo();

    void setCertificateChain(const QList<QSslCertificate> &chain);

private slots:
    void updateCertificateInfo(int index);
    void socketEncrypted();
    void sslErrors(const QList<QSslError> &errors);

private:
    Ui_CertificateInfo *form;
    QList<QSslCertificate> chain;
	
	QString		m_host;
	QSslSocket	*m_socket;
};

#endif
