/*
 * Copyright 2008-2009 Alexei Chaloupov <alexei.chaloupov@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef AUTOCOMPLETE_H
#define AUTOCOMPLETE_H

#include <QObject>
#include <QMap>

class QUrl;
class QWebFrame;

class AutoComplete : public QObject
{
	Q_OBJECT

public:
	AutoComplete(QObject *parent);

	void setFormHtml(QUrl url, QString data  );
	void setFormData(QUrl url, QString data  );

	bool evaluate(QUrl url);
	bool complete( QWebFrame * frame);

private:
	QMap<QString, QString>	m_forms;
	QMap<QString, QString>	m_forms_data;

	QString formUrl(QUrl url);
};

#endif // AUTOCOMPLETE_H
