dnl aclocal.m4 generated automatically by aclocal 1.4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

dnl -*- sh -*-
dnl Copyright (c) 2001, 2002 Thomas Schultz <tststs@gmx.de>
dnl partly based on code by N. D. Bellamy

dnl Wrapper around AC_ARG_ENABLE to set compile time options.
dnl
dnl Parameters:
dnl $1 = option name
dnl $2 = help string
dnl $3 = variable to set in sysconf.h

AC_DEFUN(CF_COMPILE_OPTION,
[AC_ARG_ENABLE($1,[$2],[if test "x$enableval" = "xyes" ; then
AC_DEFINE($3, 1)
else
AC_DEFINE($3, 0)
fi])])dnl

dnl Originally called JD_ANSI_CC and written by John E. Davis:
AC_DEFUN(CF_ANSI_CC,
[
AC_PROG_CC
AC_PROG_CPP
AC_PROG_GCC_TRADITIONAL
AC_ISC_POSIX
AC_AIX

dnl #This stuff came from Yorick config script
dnl
dnl #Be sure we've found compiler that understands prototypes
dnl
AC_MSG_CHECKING(C compiler that understands ANSI prototypes)
AC_TRY_COMPILE([ ],[
 extern int silly (int);], [
 AC_MSG_RESULT($CC looks ok.  Good.)], [
 AC_MSG_RESULT($CC is not a good enough compiler)
 AC_MSG_ERROR(Set env variable CC to your ANSI compiler and rerun configure.)
 ])dnl
])dnl

dnl Originally called JD_TERMCAP and written by John E. Davis
AC_DEFUN(CF_TERMCAP,
[
AC_MSG_CHECKING(for Terminfo)

JD_Terminfo_Dirs="/usr/lib/terminfo \
                 /usr/share/terminfo \
                 /usr/share/lib/terminfo \
		 /usr/local/lib/terminfo \
		 $FINKPREFIX/share/terminfo"

TERMCAP=-ltermcap

AC_MSG_CHECKING(for Terminfo)
for terminfo_dir in $JD_Terminfo_Dirs
do
   if test -d $terminfo_dir 
   then
      AC_MSG_RESULT(yes)
      TERMCAP=""
      break
   fi
done
if test "$TERMCAP"; then
  AC_MSG_RESULT(no)
fi
AC_SUBST(TERMCAP)dnl
])

AC_DEFUN(CF_GCC_OPTIONS,
[
AC_ARG_ENABLE(warnings,
	      [  --enable-warnings       turn on compiler warnings (GCC only)],
	      [gcc_warnings=$enableval])
AC_ARG_ENABLE(profiling,
	      [  --enable-profiling      turn on profiling (GCC only)],
	      [gcc_profiling=$enableval])
if test -n "$GCC"
then

AC_MSG_CHECKING([for gcc 2.7.* (assume bug in strength reduction)])
AC_CACHE_VAL(ac_cv_gcc_optimizer_bug, [
    AC_EGREP_CPP(opt_bug,
    [#if __GNUC__ == 2 && __GNUC_MINOR__ == 7
	opt_bug
    #endif
    ], ac_cv_gcc_optimizer_bug=true, ac_cv_gcc_optimizer_bug=false)
])

  if test "x$ac_cv_gcc_optimizer_bug" = xtrue; then
    CFLAGS="$CFLAGS -fno-strength-reduce"
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi

  if test "x$gcc_warnings" = xyes; then
    CFLAGS="$CFLAGS -Wall -W -pedantic -Winline -Wmissing-prototypes \
 -Wnested-externs -Wpointer-arith -Wcast-align -Wshadow -Wstrict-prototypes"
  fi
  
  if test "x$gcc_profiling" = xyes; then
    CFLAGS="$CFLAGS -pg"
    LDFLAGS="$LDFLAGS -pg"
  fi
  
  # Now trim excess whitespace
  CFLAGS=`echo $CFLAGS`
  LDFLAGS=`echo $LDFLAGS`
fi
])

dnl evaluate $libdir and $includedir
dnl results are in $ev_libdir and $ev_includedir respecively
AC_DEFUN(CF_EVAL_VARS,
[
ev_prefix=$prefix
test "x$ev_prefix" = xNONE && ev_prefix=$ac_default_prefix
ev_exec_prefix=$exec_prefix
test "x$ev_exec_prefix" = xNONE && ev_exec_prefix=$ev_prefix

eval `sh <<+
prefix=$ev_prefix
exec_prefix=$ev_exec_prefix
libdir=$libdir
includedir=$includedir
bindir=$bindir
datadir=$datadir
docdir=$docdir
mandir=$mandir
sysconfdir=$sysconfdir

echo ev_libdir="\$libdir" ev_includedir="\$includedir"
echo ev_bindir="\$bindir" ev_datadir="\$datadir"
echo ev_docdir="\$docdir" ev_mandir="\$mandir"
echo ev_sysconfdir="\$sysconfdir"
+
`
])

AC_DEFUN(CF_HARDCODE_LIBS,
[
AC_ARG_ENABLE(hardcode-libs,
              [  --enable-hardcode-libs  Hardcode path of dynamic libs in binaries])

cf_rpath_option=""
if test "x$enable_hardcode_libs" = "xyes" ; then
  AC_MSG_CHECKING(if linker accepts -rpath)
  AC_CACHE_VAL(ac_cv_rpath, [
  save_ldflags="$LDFLAGS"
  LDFLAGS="$LDFLAGS -Wl,-rpath,/usr/lib"
  AC_TRY_LINK([], [],
	[ac_cv_rpath=true],
	[ac_cv_rpath=false])
  LDFLAGS="$save_ldflags"
  ])
  if test "x$ac_cv_rpath" = "xtrue" ; then
    AC_MSG_RESULT(yes)
    cf_rpath_option="-Wl,-rpath,"
  else
    AC_MSG_RESULT(no)
    cf_rpath_option="-Wl,-R,"
  fi
fi
])

AC_DEFUN(CF_PATH_SLANG_LIB,
[
  AC_REQUIRE([CF_EVAL_VARS])
  AC_MSG_CHECKING(for the slang library)
  
  ac_slang_library="no"
  
  AC_ARG_WITH(slang-library,
    [  --with-slang-library    Where the slang library is located ],
    [  ac_slang_library="$withval" ])

  dnl Did the user give --with-slang-library?
  
  if test "x$ac_slang_library" = xno || test "x$ac_slang_library" = xyes ; then

    dnl No they didn't, so let's look for them...
    
    if test "x$ac_cv_lib_slang" != "x" ; then
      ac_slang_library="$ac_cv_lib_slang"
    fi

    AC_CACHE_VAL(ac_cv_lib_slang, [
    
      dnl If you need to add extra directories to check, add them here.
      
      slang_library_dirs="\
        /usr/local/lib/slang \
	/usr/local/lib \
	/usr/lib/slang \
        /usr/lib \
	/usr/pkg/lib \
	$ev_libdir"
  
      for slang_dir in $slang_library_dirs; do
        if test -r "$slang_dir/libslang.a" || \
	   test -r "$slang_dir/libslang.so" ; then
          ac_slang_library="$slang_dir"
          break
        fi
      done

      ac_cv_lib_slang="$ac_slang_library"
    ])
  fi

  AC_MSG_RESULT([$ac_slang_library])

  if test "x$ac_slang_library" = xno; then
    AC_MSG_ERROR([

I can't find the slang library.

Install the slang library, or if you have it installed, override this check
with the --with-slang-library=DIR option, and I'll take your word for it.
])

  fi
  
  SLANG_LIB_DIR="$ac_slang_library"
  if test "x$enable_hardcode_libs" = "xyes" ; then
      SLANG_LIB="-L$ac_slang_library $cf_rpath_option$ac_slang_library"
  else
      SLANG_LIB="-L$ac_slang_library"
  fi
  
# gcc under solaris is often not installed correctly.  Avoid specifying
# -L/usr/lib.
#if test "$SLANG_LIB_DIR" = "/usr/lib"
#then
#    SLANG_LIB=""
#fi

AC_SUBST(SLANG_LIB)dnl
AC_SUBST(SLANG_LIB_DIR)dnl
])

AC_DEFUN(CF_PATH_SLANG_INC,
[
  AC_REQUIRE([CF_EVAL_VARS])
  AC_MSG_CHECKING(for the slang includes)
  
  ac_slang_includes="no"
  
  AC_ARG_WITH(slang-includes,
    [  --with-slang-includes   Where the slang headers are located ],
    [  ac_slang_includes="$withval" ])

  dnl Did the user give --with-slang-includes?
  
  if test "x$ac_slang_includes" = xno || \
     test "x$ac_slang_includes" = xyes ; then

    dnl No they didn't, so lets look for them...
    
    if test "x$ac_cv_header_slanginc" != "x" ; then
      ac_slang_includes="$ac_cv_header_slanginc"
    fi

    AC_CACHE_VAL(ac_cv_header_slanginc, [

      dnl If you need to add extra directories to check, add them here.
      
      slang_include_dirs="\
        /usr/local/include/slang \
	/usr/local/include \
	/usr/include/slang \
        /usr/include \
	/usr/pkg/include \
	$ev_includedir"
      
      for slang_dir in $slang_include_dirs; do
        if test -r "$slang_dir/slang.h"; then
          ac_slang_includes="$slang_dir"
          break
        fi
      done

      ac_cv_header_slanginc="$ac_slang_includes"
    ])
  fi

  AC_MSG_RESULT([$ac_slang_includes])

  if test "x$ac_slang_includes" = xno; then
    AC_MSG_ERROR([

I can't find the slang header files.

Install the slang development package, or if you have it installed, override
this check with the --with-slang-includes=DIR option, and I'll take your
word for it.
])

  fi

  SLANG_INCLUDE="$ac_slang_includes"
  SLANG_INC="-I$ac_slang_includes"
  
# gcc under solaris is often not installed correctly.  Avoid specifying
# -I/usr/include.
if test "$SLANG_INC" = "-I/usr/include"
then
    SLANG_INC=""
fi

AC_SUBST(SLANG_INC)dnl
AC_SUBST(SLANG_INCLUDE)dnl
])

AC_DEFUN(CF_SSL,
[
  SSLLIB=""
  SSLINC=""
  
  AC_ARG_WITH(ssl,
    [  --with-ssl[=DIR]        For SSL support],
    [  ac_ssl_home="$withval" ], [ ac_ssl_home=no ])
  
  AC_ARG_WITH(ssl-library,
    [  --with-ssl-library      Where the OpenSSL library is located ],
    [  ac_ssl_library="$withval" ], [ ac_ssl_library=no ])

  AC_ARG_WITH(ssl-includes,
    [  --with-ssl-includes     Where the OpenSSL headers are located ],
    [  ac_ssl_includes="$withval" ], [ ac_ssl_includes=no ])

  if test "x$ac_ssl_home" != xno || test "x$ac_ssl_library" != xno || \
     test "x$ac_ssl_includes" != xno ; then
  
    dnl We want SSL support
  
    AC_MSG_CHECKING(for the OpenSSL library)
    
    if test "x$ac_ssl_library" = xno || test "x$ac_ssl_library" = xyes ; then
  
    if test "x$ac_cv_lib_ssl" != "x" ; then
      ac_ssl_library="$ac_cv_lib_ssl"
    fi

    AC_CACHE_VAL(ac_cv_lib_ssl, [
    
      dnl If you need to add extra directories to check, add them here.
      
      ssl_library_dirs="\
        /usr/local/ssl/lib \
	/usr/local/lib \
  	/usr/ssl/lib \
        /usr/lib \
	/usr/pkg/lib"
  	
      if test "x$ac_ssl_home" != xno && test "x$ac_ssl_home" != xyes ; then
        ssl_library_dirs="$ac_ssl_home $ac_ssl_home/lib $ssl_library_dirs"
      fi
  
      for ssl_dir in $ssl_library_dirs; do
        if test -r "$ssl_dir/libssl.a" || \
	   test -r "$ssl_dir/libssl.so" ; then
          ac_ssl_library="$ssl_dir"
          break
        fi
      done

      ac_cv_lib_ssl="$ac_ssl_library"
    ])
    
    fi
    
    AC_MSG_RESULT([$ac_ssl_library])
    
    if test "x$ac_ssl_library" = xno || test "x$ac_ssl_library" = xyes; then
    AC_MSG_ERROR([

Please install the OpenSSL library.  If you already did so, point this script
to the right directory with the --with-ssl-library=DIR option.
])
    fi
    
    # gcc under solaris is often not installed correctly.  Avoid specifying
    # -L/usr/lib.
    if test "x$ac_ssl_library" = "x/usr/lib" ; then
        SSLLIB="-lssl -lcrypto"
    else
        if test "x$enable_hardcode_libs" = "xyes" ; then
            SSLLIB="-L$ac_ssl_library $cf_rpath_option$ac_ssl_library -lssl -lcrypto"
        else
            SSLLIB="-L$ac_ssl_library -lssl -lcrypto"
        fi
    fi
    
    AC_MSG_CHECKING(for the OpenSSL includes)
    
    if test "x$ac_ssl_includes" = xno || test "x$ac_ssl_includes" = xyes ; then
    
    if test "x$ac_cv_header_ssl" != "x" ; then
      ac_ssl_includes="$ac_cv_header_ssl"
    fi

    AC_CACHE_VAL(ac_cv_header_ssl, [

      dnl If you need to add extra directories to check, add them here.
      
      ssl_include_dirs="\
        /usr/local/ssl/include \
	/usr/local/include \
	/usr/ssl/include \
        /usr/include \
	/usr/pkg/include"
	
      if test "x$ac_ssl_home" != xno && test "x$ac_ssl_home" != xyes ; then
        ssl_include_dirs="$ac_ssl_home $ac_ssl_home/include $ssl_include_dirs"
      fi
      
      for ssl_dir in $ssl_include_dirs; do
        if test -r "$ssl_dir/openssl/ssl.h"; then
          ac_ssl_includes="$ssl_dir"
          break
        fi
      done

      ac_cv_header_ssl="$ac_ssl_includes"
    ])
    
    fi
    
    AC_MSG_RESULT([$ac_ssl_includes])

    if test "x$ac_ssl_includes" = xno || test "x$ac_ssl_includes" = xyes; then
    AC_MSG_ERROR([

Please install the OpenSSL header files.  If you already did so, point this
script to the right directory with the --with-ssl-includes=DIR option.
])
    fi

    # gcc under solaris is often not installed correctly.  Avoid specifying
    # -I/usr/include.
    if test "x$ac_ssl_includes" = "x/usr/include" ; then
        SSLINC=""
    else
        SSLINC="-I$ac_ssl_includes"
    fi

    AC_DEFINE(SLRN_HAS_SSL_SUPPORT, 1)
  else
    AC_DEFINE(SLRN_HAS_SSL_SUPPORT, 0)
  fi
  
    AC_SUBST(SSLINC)
    AC_SUBST(SSLLIB)dnl
])

AC_DEFUN(CF_MTA,
[
  AC_ARG_WITH(mta,
    [  --with-mta[=PATHNAME]   To use an alternate mail transport agent],
    [  ac_mta_path="$withval" ], [ ac_mta_path=no ])
  
  if test "x$ac_mta_path" = xno || test "x$ac_mta_path" = xyes || \
     test "x$ac_mta_path" = "x"; then
    dnl We need to find sendmail ourself
    
    AC_PATH_PROG(SENDMAIL, sendmail, no,
      $PATH:/usr/local/sbin:/usr/sbin:/usr/local/lib:/usr/lib)
    if test "x$ac_cv_path_SENDMAIL" != xno; then
      AC_DEFINE_UNQUOTED(SLRN_SENDMAIL_COMMAND, "$ac_cv_path_SENDMAIL -oi -t -oem -odb")
    else
      AC_MSG_ERROR([

I can't find a sendmail executable.  slrn requires a mail transport agent
for sending e-mail.  Please make sure sendmail is in your \$PATH or use
the --with-mta option to point configure to a different MTA (giving the full
pathname and all needed command line arguments).
])
    fi
  else
    AC_DEFINE_UNQUOTED(SLRN_SENDMAIL_COMMAND, "$ac_mta_path")
  fi
])

AC_DEFUN(CF_UUDEVIEW,
[
  UULIB=""
  UUINC=""
  
  AC_ARG_WITH(uudeview,
    [  --with-uudeview[=DIR]   For uudeview library support],
    [  ac_uu_home="$withval" ], [ ac_uu_home=no ])

  if test "x$ac_uu_home" != xno ; then
  
    dnl We want uudeview support
  
    AC_MSG_CHECKING(for the uudeview library)
    
    if test "x$ac_cv_lib_uu" != "x" ; then
      ac_uu_library="$ac_cv_lib_uu"
    else
      ac_uu_library=no
    fi

    AC_CACHE_VAL(ac_cv_lib_uu, [
    
      dnl If you need to add extra directories to check, add them here.
      
      uu_library_dirs="\
	/usr/local/lib \
        /usr/lib \
	/usr/pkg/lib"
  	
      if test "x$ac_uu_home" != xno && test "x$ac_uu_home" != xyes ; then
        uu_library_dirs="$ac_uu_home $ac_uu_home/lib $uu_library_dirs"
      fi
  
      for uu_dir in $uu_library_dirs; do
        if test -r "$uu_dir/libuu.a" ; then
          ac_uu_library="$uu_dir"
          break
        fi
      done

      if test "x$ac_uu_library" != xno; then
        ac_cv_lib_uu="$ac_uu_library"
      fi
    ])
    
    AC_MSG_RESULT([$ac_uu_library])
    
    if test "x$ac_uu_library" = xno ; then
    AC_MSG_ERROR([

Please install the uudeview library.  If you already did so, point this script
to the right directory with the --with-uudeview=DIR option.
])
    fi
    
    # gcc under solaris is often not installed correctly.  Avoid specifying
    # -L/usr/lib.
    if test "x$ac_uu_library" = "x/usr/lib" ; then
        UULIB="-luu"
    else
        if test "x$enable_hardcode_libs" = "xyes" ; then
            UULIB="-L$ac_uu_library $cf_rpath_option$ac_uu_library -luu"
        else
            UULIB="-L$ac_uu_library -luu"
        fi
    fi
    
    AC_MSG_CHECKING(for the uudeview includes)
    
    if test "x$ac_cv_header_uu" != "x" ; then
      ac_uu_includes="$ac_cv_header_uu"
    else
      ac_uu_includes=no
    fi

    AC_CACHE_VAL(ac_cv_header_uu, [

      dnl If you need to add extra directories to check, add them here.
      
      uu_include_dirs="\
	/usr/local/include \
        /usr/include \
	/usr/pkg/include"
	
      if test "x$ac_uu_home" != xno && test "x$ac_uu_home" != xyes ; then
        uu_include_dirs="$ac_uu_home $ac_uu_home/include $uu_include_dirs"
      fi
      
      for uu_dir in $uu_include_dirs; do
        if test -r "$uu_dir/uudeview.h"; then
          ac_uu_includes="$uu_dir"
          break
        fi
      done

      if test "x$ac_uu_includes" != xno; then
        ac_cv_header_uu="$ac_uu_includes"
      fi
    ])
    
    AC_MSG_RESULT([$ac_uu_includes])

    if test "x$ac_uu_includes" = xno ; then
    AC_MSG_ERROR([

Please install the uudeview header files.  If you already did so, point this
script to the right directory with the --with-uudeview=DIR option.
])
    fi

    # gcc under solaris is often not installed correctly.  Avoid specifying
    # -I/usr/include.
    if test "x$ac_uu_includes" = "x/usr/include" ; then
        UUINC=""
    else
        UUINC="-I$ac_uu_includes"
    fi

    AC_DEFINE(SLRN_HAS_UUDEVIEW, 1)
  else
    AC_DEFINE(SLRN_HAS_UUDEVIEW, 0)
  fi
  
    AC_SUBST(UUINC)
    AC_SUBST(UULIB)dnl
])

AC_DEFUN(CF_VA_COPY,
[
 dnl va_copy checks taken from glib 1.2.8
 dnl
 dnl we currently check for all three va_copy possibilities, so we get
 dnl all results in config.log for bug reports.
AC_MSG_CHECKING(for an implementation of va_copy())
AC_CACHE_VAL(slrn_cv_va_copy,[
	AC_TRY_RUN([
	#include <stdarg.h>
	void f (int i, ...) {
	va_list args1, args2;
	va_start (args1, i);
	va_copy (args2, args1);
	if (va_arg (args2, int) != 42 || va_arg (args1, int) != 42)
	  exit (1);
	va_end (args1); va_end (args2);
	}
	int main() {
	  f (0, 42);
	  return 0;
	}],
	slrn_cv_va_copy=yes
	,
	slrn_cv_va_copy=no
	,)
])
AC_MSG_RESULT($slrn_cv_va_copy)
AC_MSG_CHECKING(for an implementation of __va_copy())
AC_CACHE_VAL(slrn_cv___va_copy,[
	AC_TRY_RUN([
	#include <stdarg.h>
	void f (int i, ...) {
	va_list args1, args2;
	va_start (args1, i);
	__va_copy (args2, args1);
	if (va_arg (args2, int) != 42 || va_arg (args1, int) != 42)
	  exit (1);
	va_end (args1); va_end (args2);
	}
	int main() {
	  f (0, 42);
	  return 0;
	}],
	slrn_cv___va_copy=yes
	,
	slrn_cv___va_copy=no
	,)
])
AC_MSG_RESULT($slrn_cv___va_copy)
AC_MSG_CHECKING(whether va_lists can be copied by value)
AC_CACHE_VAL(slrn_cv_va_val_copy,[
	AC_TRY_RUN([
	#include <stdarg.h>
	void f (int i, ...) {
	va_list args1, args2;
	va_start (args1, i);
	args2 = args1;
	if (va_arg (args2, int) != 42 || va_arg (args1, int) != 42)
	  exit (1);
	va_end (args1); va_end (args2);
	}
	int main() {
	  f (0, 42);
	  return 0;
	}],
	slrn_cv_va_val_copy=yes
	,
	slrn_cv_va_val_copy=no
	,)
])
if test "x$slrn_cv_va_copy" = "xyes"; then
  AC_DEFINE(VA_COPY, va_copy)
else if test "x$slrn_cv___va_copy" = "xyes"; then
  AC_DEFINE(VA_COPY, __va_copy)
fi
fi
if test "x$slrn_cv_va_val_copy" = "xno"; then
  AC_DEFINE(VA_COPY_AS_ARRAY)
fi
AC_MSG_RESULT($slrn_cv_va_val_copy)
])

AC_DEFUN(CF_SUMMARY,
[
  AC_REQUIRE([CF_EVAL_VARS])

echo ""
echo "slrn will be installed to the following directories:"
echo "Binaries      : $ev_bindir"
echo "Documentation : $ev_docdir"
echo "Manual pages  : $ev_mandir"
echo "Macros        : ${ev_datadir}/slrn"
echo ""
echo "System-wide configuration is read from $ev_sysconfdir"

if test "x$enable_hardcode_libs" != xyes && test ! -x /sbin/ldconfig ; then
AC_MSG_WARN([
/sbin/ldconfig not found.
It\'s probably a good idea to specify --enable-hardcode-libs])
fi

dnl There seems to be (currently unused) free software for this ...

dnl if test "x$enable_grouplens" != x && test "x$enable_grouplens" != xno ; then
dnl AC_MSG_WARN([
dnl You enabled GroupLens support.
dnl 
dnl As far as I could find out, GroupLens is dead for years, so I consider
dnl removing the code from slrn.  Please contact me at tststs@gmx.de to let
dnl me know you still need it.])
dnl fi

echo ""
echo "Look at doc/INSTALL.unix for a list of configure options."
echo "For some less common compile time options, edit \"src/slrnfeat.h\"."
echo "Then, type \"make all\" to start compilation."
echo ""
])

#serial 1
# This test replaces the one in autoconf.
# Currently this macro should have the same name as the autoconf macro
# because gettext's gettext.m4 (distributed in the automake package)
# still uses it.  Otherwise, the use in gettext.m4 makes autoheader
# give these diagnostics:
#   configure.in:556: AC_TRY_COMPILE was called before AC_ISC_POSIX
#   configure.in:556: AC_TRY_RUN was called before AC_ISC_POSIX

undefine([AC_ISC_POSIX])

AC_DEFUN([AC_ISC_POSIX],
  [
    dnl This test replaces the obsolescent AC_ISC_POSIX kludge.
    AC_CHECK_LIB(cposix, strerror, [LIBS="$LIBS -lcposix"])
  ]
)

# Macro to add for using GNU gettext.
# Ulrich Drepper <drepper@cygnus.com>, 1995.
#
# This file can be copied and used freely without restrictions.  It can
# be used in projects which are not available under the GNU Public License
# but which still want to provide support for the GNU gettext functionality.
# Please note that the actual code is *not* freely available.

# serial 9

dnl Usage: AM_WITH_NLS([TOOLSYMBOL], [NEEDSYMBOL], [LIBDIR]).
dnl If TOOLSYMBOL is specified and is 'use-libtool', then a libtool library
dnl    $(top_builddir)/intl/libintl.la will be created (shared and/or static,
dnl    depending on --{enable,disable}-{shared,static} and on the presence of
dnl    AM-DISABLE-SHARED). Otherwise, a static library
dnl    $(top_builddir)/intl/libintl.a will be created.
dnl If NEEDSYMBOL is specified and is 'need-ngettext', then GNU gettext
dnl    implementations (in libc or libintl) without the ngettext() function
dnl    will be ignored.
dnl LIBDIR is used to find the intl libraries.  If empty,
dnl    the value `$(top_builddir)/intl/' is used.
dnl
dnl The result of the configuration is one of three cases:
dnl 1) GNU gettext, as included in the intl subdirectory, will be compiled
dnl    and used.
dnl    Catalog format: GNU --> install in $(datadir)
dnl    Catalog extension: .mo after installation, .gmo in source tree
dnl 2) GNU gettext has been found in the system's C library.
dnl    Catalog format: GNU --> install in $(datadir)
dnl    Catalog extension: .mo after installation, .gmo in source tree
dnl 3) No internationalization, always use English msgid.
dnl    Catalog format: none
dnl    Catalog extension: none
dnl The use of .gmo is historical (it was needed to avoid overwriting the
dnl GNU format catalogs when building on a platform with an X/Open gettext),
dnl but we keep it in order not to force irrelevant filename changes on the
dnl maintainers.
dnl
AC_DEFUN([AM_WITH_NLS],
  [AC_MSG_CHECKING([whether NLS is requested])
    dnl Default is enabled NLS
    AC_ARG_ENABLE(nls,
      [  --disable-nls           do not use Native Language Support],
      USE_NLS=$enableval, USE_NLS=yes)
    AC_MSG_RESULT($USE_NLS)
    AC_SUBST(USE_NLS)

    BUILD_INCLUDED_LIBINTL=no
    USE_INCLUDED_LIBINTL=no
    INTLLIBS=

    dnl If we use NLS figure out what method
    if test "$USE_NLS" = "yes"; then
      AC_DEFINE(ENABLE_NLS, 1,
        [Define to 1 if translation of program messages to the user's native language
   is requested.])
      AC_MSG_CHECKING([whether included gettext is requested])
      AC_ARG_WITH(included-gettext,
        [  --with-included-gettext use the GNU gettext library included here],
        nls_cv_force_use_gnu_gettext=$withval,
        nls_cv_force_use_gnu_gettext=no)
      AC_MSG_RESULT($nls_cv_force_use_gnu_gettext)

      nls_cv_use_gnu_gettext="$nls_cv_force_use_gnu_gettext"
      if test "$nls_cv_force_use_gnu_gettext" != "yes"; then
        dnl User does not insist on using GNU NLS library.  Figure out what
        dnl to use.  If GNU gettext is available we use this.  Else we have
        dnl to fall back to GNU NLS library.
	CATOBJEXT=NONE

        dnl Add a version number to the cache macros.
        define(gt_cv_func_gnugettext_libc, [gt_cv_func_gnugettext]ifelse([$2], need-ngettext, 2, 1)[_libc])
        define(gt_cv_func_gnugettext_libintl, [gt_cv_func_gnugettext]ifelse([$2], need-ngettext, 2, 1)[_libintl])

	AC_CHECK_HEADER(libintl.h,
	  [AC_CACHE_CHECK([for GNU gettext in libc], gt_cv_func_gnugettext_libc,
	    [AC_TRY_LINK([#include <libintl.h>
extern int _nl_msg_cat_cntr;],
	       [bindtextdomain ("", "");
return (int) gettext ("")]ifelse([$2], need-ngettext, [ + (int) ngettext ("", "", 0)], [])[ + _nl_msg_cat_cntr],
	       gt_cv_func_gnugettext_libc=yes,
	       gt_cv_func_gnugettext_libc=no)])

	   if test "$gt_cv_func_gnugettext_libc" != "yes"; then
	     AC_CACHE_CHECK([for GNU gettext in libintl],
	       gt_cv_func_gnugettext_libintl,
	       [gt_save_LIBS="$LIBS"
		LIBS="$LIBS -lintl $LIBICONV"
		AC_TRY_LINK([#include <libintl.h>
extern int _nl_msg_cat_cntr;],
		  [bindtextdomain ("", "");
return (int) gettext ("")]ifelse([$2], need-ngettext, [ + (int) ngettext ("", "", 0)], [])[ + _nl_msg_cat_cntr],
		  gt_cv_func_gnugettext_libintl=yes,
		  gt_cv_func_gnugettext_libintl=no)
		LIBS="$gt_save_LIBS"])
	   fi

	   dnl If an already present or preinstalled GNU gettext() is found,
	   dnl use it.  But if this macro is used in GNU gettext, and GNU
	   dnl gettext is already preinstalled in libintl, we update this
	   dnl libintl.  (Cf. the install rule in intl/Makefile.in.)
	   if test "$gt_cv_func_gnugettext_libc" = "yes" \
	      || { test "$gt_cv_func_gnugettext_libintl" = "yes" \
		   && test "$PACKAGE" != gettext; }; then
	     AC_DEFINE(HAVE_GETTEXT, 1,
               [Define if the GNU gettext() function is already present or preinstalled.])

	     if test "$gt_cv_func_gnugettext_libintl" = "yes"; then
	       dnl If iconv() is in a separate libiconv library, then anyone
	       dnl linking with libintl{.a,.so} also needs to link with
	       dnl libiconv.
	       INTLLIBS="-lintl $LIBICONV"
	     fi

	     gt_save_LIBS="$LIBS"
	     LIBS="$LIBS $INTLLIBS"
	     AC_CHECK_FUNCS(dcgettext)
	     LIBS="$gt_save_LIBS"

	     AM_PATH_PROG_WITH_TEST(MSGFMT, msgfmt,
	       [test -z "`$ac_dir/$ac_word -h 2>&1 | grep 'dv '`"], no)dnl
	     if test "$MSGFMT" != "no"; then
	       AC_PATH_PROG(GMSGFMT, gmsgfmt, $MSGFMT)
	     fi

	     AM_PATH_PROG_WITH_TEST(XGETTEXT, xgettext,
	       [test -z "`$ac_dir/$ac_word -h 2>&1 | grep '(HELP)'`"], :)

	     CATOBJEXT=.gmo
	   fi
	])

        if test "$CATOBJEXT" = "NONE"; then
	  dnl GNU gettext is not found in the C library.
	  dnl Fall back on GNU gettext library.
	  nls_cv_use_gnu_gettext=yes
        fi
      fi

      if test "$nls_cv_use_gnu_gettext" = "yes"; then
        dnl Mark actions used to generate GNU NLS library.
        INTLOBJS="\$(GETTOBJS)"
        AM_PATH_PROG_WITH_TEST(MSGFMT, msgfmt,
	  [test -z "`$ac_dir/$ac_word -h 2>&1 | grep 'dv '`"], msgfmt)
        AC_PATH_PROG(GMSGFMT, gmsgfmt, $MSGFMT)
        AM_PATH_PROG_WITH_TEST(XGETTEXT, xgettext,
	  [test -z "`$ac_dir/$ac_word -h 2>&1 | grep '(HELP)'`"], :)
        AC_SUBST(MSGFMT)
	BUILD_INCLUDED_LIBINTL=yes
	USE_INCLUDED_LIBINTL=yes
        CATOBJEXT=.gmo
	INTLLIBS="ifelse([$3],[],\$(top_builddir)/intl,[$3])/libintl.ifelse([$1], use-libtool, [l], [])a $LIBICONV"
	LIBS=`echo " $LIBS " | sed -e 's/ -lintl / /' -e 's/^ //' -e 's/ $//'`
      fi

      dnl Test whether we really found GNU xgettext.
      if test "$XGETTEXT" != ":"; then
	dnl If it is no GNU xgettext we define it as : so that the
	dnl Makefiles still can work.
	if $XGETTEXT --omit-header /dev/null 2> /dev/null; then
	  : ;
	else
	  AC_MSG_RESULT(
	    [found xgettext program is not GNU xgettext; ignore it])
	  XGETTEXT=":"
	fi
      fi

      dnl We need to process the po/ directory.
      POSUB=po
    fi
    AC_OUTPUT_COMMANDS(
     [for ac_file in $CONFIG_FILES; do
        # Support "outfile[:infile[:infile...]]"
        case "$ac_file" in
          *:*) ac_file=`echo "$ac_file"|sed 's%:.*%%'` ;;
        esac
        # PO directories have a Makefile.in generated from Makefile.in.in.
        case "$ac_file" in */Makefile.in)
          # Adjust a relative srcdir.
          ac_dir=`echo "$ac_file"|sed 's%/[^/][^/]*$%%'`
          ac_dir_suffix="/`echo "$ac_dir"|sed 's%^\./%%'`"
          ac_dots=`echo "$ac_dir_suffix"|sed 's%/[^/]*%../%g'`
          case "$ac_given_srcdir" in
            .)  top_srcdir=`echo $ac_dots|sed 's%/$%%'` ;;
            /*) top_srcdir="$ac_given_srcdir" ;;
            *)  top_srcdir="$ac_dots$ac_given_srcdir" ;;
          esac
          if test -f "$ac_given_srcdir/$ac_dir/POTFILES.in"; then
            rm -f "$ac_dir/POTFILES"
            echo creating "$ac_dir/POTFILES"
            sed -e "/^#/d" -e "/^[ 	]*\$/d" -e "s,.*,     $top_srcdir/& \\\\," -e "\$s/\(.*\) \\\\/\1/" < "$ac_given_srcdir/$ac_dir/POTFILES.in" > "$ac_dir/POTFILES"
            echo creating "$ac_dir/Makefile"
            sed -e "/POTFILES =/r $ac_dir/POTFILES" "$ac_dir/Makefile.in" > "$ac_dir/Makefile"
          fi
          ;;
        esac
      done])


    dnl If this is used in GNU gettext we have to set BUILD_INCLUDED_LIBINTL
    dnl to 'yes' because some of the testsuite requires it.
    if test "$PACKAGE" = gettext; then
      BUILD_INCLUDED_LIBINTL=yes
    fi

    dnl intl/plural.c is generated from intl/plural.y. It requires bison,
    dnl because plural.y uses bison specific features. It requires at least
    dnl bison-1.26 because earlier versions generate a plural.c that doesn't
    dnl compile.
    dnl bison is only needed for the maintainer (who touches plural.y). But in
    dnl order to avoid separate Makefiles or --enable-maintainer-mode, we put
    dnl the rule in general Makefile. Now, some people carelessly touch the
    dnl files or have a broken "make" program, hence the plural.c rule will
    dnl sometimes fire. To avoid an error, defines BISON to ":" if it is not
    dnl present or too old.
    AC_CHECK_PROGS([INTLBISON], [bison])
    if test -z "$INTLBISON"; then
      ac_verc_fail=yes
    else
      dnl Found it, now check the version.
      AC_MSG_CHECKING([version of bison])
changequote(<<,>>)dnl
      ac_prog_version=`$INTLBISON --version 2>&1 | sed -n 's/^.*GNU Bison .* \([0-9]*\.[0-9.]*\).*$/\1/p'`
      case $ac_prog_version in
        '') ac_prog_version="v. ?.??, bad"; ac_verc_fail=yes;;
        1.2[6-9]* | 1.[3-9][0-9]* | [2-9].*)
changequote([,])dnl
           ac_prog_version="$ac_prog_version, ok"; ac_verc_fail=no;;
        *) ac_prog_version="$ac_prog_version, bad"; ac_verc_fail=yes;;
      esac
      AC_MSG_RESULT([$ac_prog_version])
    fi
    if test $ac_verc_fail = yes; then
      INTLBISON=:
    fi

    dnl These rules are solely for the distribution goal.  While doing this
    dnl we only have to keep exactly one list of the available catalogs
    dnl in configure.in.
    for lang in $ALL_LINGUAS; do
      GMOFILES="$GMOFILES $lang.gmo"
      POFILES="$POFILES $lang.po"
    done

    dnl Make all variables we use known to autoconf.
    AC_SUBST(BUILD_INCLUDED_LIBINTL)
    AC_SUBST(USE_INCLUDED_LIBINTL)
    AC_SUBST(CATALOGS)
    AC_SUBST(CATOBJEXT)
    AC_SUBST(GMOFILES)
    AC_SUBST(INTLLIBS)
    AC_SUBST(INTLOBJS)
    AC_SUBST(POFILES)
    AC_SUBST(POSUB)

    dnl For backward compatibility. Some configure.ins may be using this.
    nls_cv_header_intl=
    nls_cv_header_libgt=

    dnl For backward compatibility. Some Makefiles may be using this.
    DATADIRNAME=share
    AC_SUBST(DATADIRNAME)

    dnl For backward compatibility. Some Makefiles may be using this.
    INSTOBJEXT=.mo
    AC_SUBST(INSTOBJEXT)

    dnl For backward compatibility. Some Makefiles may be using this.
    GENCAT=gencat
    AC_SUBST(GENCAT)
  ])

dnl Usage: Just like AM_WITH_NLS, which see.
AC_DEFUN([AM_GNU_GETTEXT],
  [AC_REQUIRE([AC_PROG_MAKE_SET])dnl
   AC_REQUIRE([AC_PROG_CC])dnl
   AC_REQUIRE([AC_CANONICAL_HOST])dnl
   AC_REQUIRE([AC_PROG_RANLIB])dnl
   AC_REQUIRE([AC_ISC_POSIX])dnl
   AC_REQUIRE([AC_HEADER_STDC])dnl
   AC_REQUIRE([AC_C_CONST])dnl
   AC_REQUIRE([AC_C_INLINE])dnl
   AC_REQUIRE([AC_TYPE_OFF_T])dnl
   AC_REQUIRE([AC_TYPE_SIZE_T])dnl
   AC_REQUIRE([AC_FUNC_ALLOCA])dnl
   AC_REQUIRE([AC_FUNC_MMAP])dnl

   AC_CHECK_HEADERS([argz.h limits.h locale.h nl_types.h malloc.h stddef.h \
stdlib.h string.h unistd.h sys/param.h])
   AC_CHECK_FUNCS([feof_unlocked fgets_unlocked getcwd getegid geteuid \
getgid getuid mempcpy munmap putenv setenv setlocale stpcpy strchr strcasecmp \
strdup strtoul tsearch __argz_count __argz_stringify __argz_next])

   AM_ICONV
   AM_LANGINFO_CODESET
   AM_LC_MESSAGES
   AM_WITH_NLS([$1],[$2],[$3])

   if test "x$CATOBJEXT" != "x"; then
     if test "x$ALL_LINGUAS" = "x"; then
       LINGUAS=
     else
       AC_MSG_CHECKING(for catalogs to be installed)
       NEW_LINGUAS=
       for presentlang in $ALL_LINGUAS; do
         useit=no
         for desiredlang in ${LINGUAS-$ALL_LINGUAS}; do
           # Use the presentlang catalog if desiredlang is
           #   a. equal to presentlang, or
           #   b. a variant of presentlang (because in this case,
           #      presentlang can be used as a fallback for messages
           #      which are not translated in the desiredlang catalog).
           case "$desiredlang" in
             "$presentlang"*) useit=yes;;
           esac
         done
         if test $useit = yes; then
           NEW_LINGUAS="$NEW_LINGUAS $presentlang"
         fi
       done
       LINGUAS=$NEW_LINGUAS
       AC_MSG_RESULT($LINGUAS)
     fi

     dnl Construct list of names of catalog files to be constructed.
     if test -n "$LINGUAS"; then
       for lang in $LINGUAS; do CATALOGS="$CATALOGS $lang$CATOBJEXT"; done
     fi
   fi

   dnl If the AC_CONFIG_AUX_DIR macro for autoconf is used we possibly
   dnl find the mkinstalldirs script in another subdir but $(top_srcdir).
   dnl Try to locate is.
   MKINSTALLDIRS=
   if test -n "$ac_aux_dir"; then
     MKINSTALLDIRS="$ac_aux_dir/mkinstalldirs"
   fi
   if test -z "$MKINSTALLDIRS"; then
     MKINSTALLDIRS="\$(top_srcdir)/mkinstalldirs"
   fi
   AC_SUBST(MKINSTALLDIRS)

   dnl Enable libtool support if the surrounding package wishes it.
   INTL_LIBTOOL_SUFFIX_PREFIX=ifelse([$1], use-libtool, [l], [])
   AC_SUBST(INTL_LIBTOOL_SUFFIX_PREFIX)
  ])

# Search path for a program which passes the given test.
# Ulrich Drepper <drepper@cygnus.com>, 1996.
#
# This file can be copied and used freely without restrictions.  It can
# be used in projects which are not available under the GNU Public License
# but which still want to provide support for the GNU gettext functionality.
# Please note that the actual code is *not* freely available.

# serial 1

dnl AM_PATH_PROG_WITH_TEST(VARIABLE, PROG-TO-CHECK-FOR,
dnl   TEST-PERFORMED-ON-FOUND_PROGRAM [, VALUE-IF-NOT-FOUND [, PATH]])
AC_DEFUN([AM_PATH_PROG_WITH_TEST],
[# Extract the first word of "$2", so it can be a program name with args.
set dummy $2; ac_word=[$]2
AC_MSG_CHECKING([for $ac_word])
AC_CACHE_VAL(ac_cv_path_$1,
[case "[$]$1" in
  /*)
  ac_cv_path_$1="[$]$1" # Let the user override the test with a path.
  ;;
  *)
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS="${IFS}:"
  for ac_dir in ifelse([$5], , $PATH, [$5]); do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      if [$3]; then
	ac_cv_path_$1="$ac_dir/$ac_word"
	break
      fi
    fi
  done
  IFS="$ac_save_ifs"
dnl If no 4th arg is given, leave the cache variable unset,
dnl so AC_PATH_PROGS will keep looking.
ifelse([$4], , , [  test -z "[$]ac_cv_path_$1" && ac_cv_path_$1="$4"
])dnl
  ;;
esac])dnl
$1="$ac_cv_path_$1"
if test -n "[$]$1"; then
  AC_MSG_RESULT([$]$1)
else
  AC_MSG_RESULT(no)
fi
AC_SUBST($1)dnl
])

#serial AM2

dnl From Bruno Haible.

AC_DEFUN([AM_ICONV],
[
  dnl Some systems have iconv in libc, some have it in libiconv (OSF/1 and
  dnl those with the standalone portable GNU libiconv installed).

  AC_ARG_WITH([libiconv-prefix],
[  --with-libiconv-prefix=DIR  search for libiconv in DIR/include and DIR/lib], [
    for dir in `echo "$withval" | tr : ' '`; do
      if test -d $dir/include; then CPPFLAGS="$CPPFLAGS -I$dir/include"; fi
      if test -d $dir/lib; then LDFLAGS="$LDFLAGS -L$dir/lib"; fi
    done
   ])

  AC_CACHE_CHECK(for iconv, am_cv_func_iconv, [
    am_cv_func_iconv="no, consider installing GNU libiconv"
    am_cv_lib_iconv=no
    AC_TRY_LINK([#include <stdlib.h>
#include <iconv.h>],
      [iconv_t cd = iconv_open("","");
       iconv(cd,NULL,NULL,NULL,NULL);
       iconv_close(cd);],
      am_cv_func_iconv=yes)
    if test "$am_cv_func_iconv" != yes; then
      am_save_LIBS="$LIBS"
      LIBS="$LIBS -liconv"
      AC_TRY_LINK([#include <stdlib.h>
#include <iconv.h>],
        [iconv_t cd = iconv_open("","");
         iconv(cd,NULL,NULL,NULL,NULL);
         iconv_close(cd);],
        am_cv_lib_iconv=yes
        am_cv_func_iconv=yes)
      LIBS="$am_save_LIBS"
    fi
  ])
  if test "$am_cv_func_iconv" = yes; then
    AC_DEFINE(HAVE_ICONV, 1, [Define if you have the iconv() function.])
    AC_MSG_CHECKING([for iconv declaration])
    AC_CACHE_VAL(am_cv_proto_iconv, [
      AC_TRY_COMPILE([
#include <stdlib.h>
#include <iconv.h>
extern
#ifdef __cplusplus
"C"
#endif
#if defined(__STDC__) || defined(__cplusplus)
size_t iconv (iconv_t cd, char * *inbuf, size_t *inbytesleft, char * *outbuf, size_t *outbytesleft);
#else
size_t iconv();
#endif
], [], am_cv_proto_iconv_arg1="", am_cv_proto_iconv_arg1="const")
      am_cv_proto_iconv="extern size_t iconv (iconv_t cd, $am_cv_proto_iconv_arg1 char * *inbuf, size_t *inbytesleft, char * *outbuf, size_t *outbytesleft);"])
    am_cv_proto_iconv=`echo "[$]am_cv_proto_iconv" | tr -s ' ' | sed -e 's/( /(/'`
    AC_MSG_RESULT([$]{ac_t:-
         }[$]am_cv_proto_iconv)
    AC_DEFINE_UNQUOTED(ICONV_CONST, $am_cv_proto_iconv_arg1,
      [Define as const if the declaration of iconv() needs const.])
  fi
  LIBICONV=
  if test "$am_cv_lib_iconv" = yes; then
    LIBICONV="-liconv"
  fi
  AC_SUBST(LIBICONV)
])

#serial AM1

dnl From Bruno Haible.

AC_DEFUN([AM_LANGINFO_CODESET],
[
  AC_CACHE_CHECK([for nl_langinfo and CODESET], am_cv_langinfo_codeset,
    [AC_TRY_LINK([#include <langinfo.h>],
      [char* cs = nl_langinfo(CODESET);],
      am_cv_langinfo_codeset=yes,
      am_cv_langinfo_codeset=no)
    ])
  if test $am_cv_langinfo_codeset = yes; then
    AC_DEFINE(HAVE_LANGINFO_CODESET, 1,
      [Define if you have <langinfo.h> and nl_langinfo(CODESET).])
  fi
])

# Check whether LC_MESSAGES is available in <locale.h>.
# Ulrich Drepper <drepper@cygnus.com>, 1995.
#
# This file can be copied and used freely without restrictions.  It can
# be used in projects which are not available under the GNU Public License
# but which still want to provide support for the GNU gettext functionality.
# Please note that the actual code is *not* freely available.

# serial 2

AC_DEFUN([AM_LC_MESSAGES],
  [if test $ac_cv_header_locale_h = yes; then
    AC_CACHE_CHECK([for LC_MESSAGES], am_cv_val_LC_MESSAGES,
      [AC_TRY_LINK([#include <locale.h>], [return LC_MESSAGES],
       am_cv_val_LC_MESSAGES=yes, am_cv_val_LC_MESSAGES=no)])
    if test $am_cv_val_LC_MESSAGES = yes; then
      AC_DEFINE(HAVE_LC_MESSAGES, 1,
        [Define if your <locale.h> file defines LC_MESSAGES.])
    fi
  fi])

# Like AC_CONFIG_HEADER, but automatically create stamp file.

AC_DEFUN(AM_CONFIG_HEADER,
[AC_PREREQ([2.12])
AC_CONFIG_HEADER([$1])
dnl When config.status generates a header, we must update the stamp-h file.
dnl This file resides in the same directory as the config header
dnl that is generated.  We must strip everything past the first ":",
dnl and everything past the last "/".
AC_OUTPUT_COMMANDS(changequote(<<,>>)dnl
ifelse(patsubst(<<$1>>, <<[^ ]>>, <<>>), <<>>,
<<test -z "<<$>>CONFIG_HEADERS" || echo timestamp > patsubst(<<$1>>, <<^\([^:]*/\)?.*>>, <<\1>>)stamp-h<<>>dnl>>,
<<am_indx=1
for am_file in <<$1>>; do
  case " <<$>>CONFIG_HEADERS " in
  *" <<$>>am_file "*<<)>>
    echo timestamp > `echo <<$>>am_file | sed -e 's%:.*%%' -e 's%[^/]*$%%'`stamp-h$am_indx
    ;;
  esac
  am_indx=`expr "<<$>>am_indx" + 1`
done<<>>dnl>>)
changequote([,]))])

