/*
 * main.c - PM VNC Viewer, program entry
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef DEBUG
#define INCL_DOSPROCESS
#endif

#define INCL_DOS
#define INCL_PM
#include <os2.h>

#include "pmvncdef.h"
#include "pmvncres.h"

/*
 * Name and Version of this Program
 */
UCHAR   ProgramVers[] = "PM VNC Viewer, Version 1.01 OW" ;

int deadthread = 0;

// MKG 1.01 - SEM to signal thread start/stop - Mike likes SEMs :)
PSZ    NETSTOPSEM    = "\\SEM32\\PMVNC\\THREADSTOP";
HEV    hevNETSTOPSEM = 0;
ULONG  NETSTOPSEMCt  = 0;

PSZ    NETSTARTSEM    = "\\SEM32\\PMVNC\\THREADSTART";
HEV    hevNETSTARTSEM = 0;
ULONG  NETSTARTSEMCt  = 0;

#ifdef DEBUG
/*
 * Doodle's Morph to PM to get printf to the console
 */

void MorphToPM( void )
{
    PPIB pib;
    PTIB tib;

    DosGetInfoBlocks(&tib, &pib);

    // Change flag from VIO to PM:
    if (pib->pib_ultype==2) pib->pib_ultype = 3;
}
#endif

/*
 * Error Notify
 */

void    errMessage(PSZ msg)
{
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, msg, ProgramVers, 0, MB_OK) ;
}

/*
 * Place Dialog near the mouse pointer
 */

void    dialogAtMouse(HWND hwndDialog, int target)
{
    HWND    hwndTarget = WinWindowFromID(hwndDialog, target) ;
    POINTL  pt ;
    SWP     posDlg ;
    SWP     posScr ;
    SWP     posCtl ;

    WinQueryPointerPos(HWND_DESKTOP, &pt)    ;
    WinQueryWindowPos(HWND_DESKTOP, &posScr) ;
    WinQueryWindowPos(hwndDialog,   &posDlg) ;

    if (hwndTarget != NULLHANDLE) {
        WinQueryWindowPos(hwndTarget, &posCtl) ;
    } else {
        posCtl.x  = posCtl.y  = 0 ;
        posCtl.cx = posCtl.cy = 0 ;
    }

    posDlg.x = pt.x - posCtl.x ;
    posDlg.y = pt.y - posCtl.y - (posCtl.cy / 2) ;

    if (posDlg.x < 0) {
        posDlg.x = 0 ;
    }
    if (posDlg.y < 0) {
        posDlg.y = 0 ;
    }
    if ((posDlg.x + posDlg.cx) > posScr.cx) {
        posDlg.x = posScr.cx - posDlg.cx ;
    }
    if ((posDlg.y + posDlg.cy) > posScr.cy) {
        posDlg.y = posScr.cy - posDlg.cy ;
    }
    WinSetWindowPos(hwndDialog, NULLHANDLE,
                    posDlg.x, posDlg.y, 0, 0, SWP_MOVE) ;
}

/*
 * Place Dialog at Center of Screen
 */

void    dialogAtCenter(HWND hwndDialog)
{
    SWP     posDlg ;
    SWP     posScr ;

    WinQueryWindowPos(HWND_DESKTOP, &posScr) ;
    WinQueryWindowPos(hwndDialog,   &posDlg) ;

    posDlg.x = (posScr.cx - posDlg.cx) / 2 ;
    posDlg.y = (posScr.cy - posDlg.cy) / 2 ;

    WinSetWindowPos(hwndDialog, NULLHANDLE,
                    posDlg.x, posDlg.y, 0, 0, SWP_MOVE) ;
}

/*
 * myname - trim and save Program Names
 */

UCHAR   ProgramPath[256] ;
UCHAR   ProgramName[256] ;
UCHAR   ProfilePath[256] ;

static  void    myname(PSZ me)
{
    PUCHAR  p, last ;

    /*
     * full pathname of program
     */

    for (p = me, last = NULL ; *p ; p++) {
        if (*p == '/' || *p == '\\') {
            last = p ;
        }
    }
    if (last != NULL) {
        strcpy(ProgramPath, me) ;
    } else if (DosSearchPath(7, "PATH", me, ProgramPath, 256) != 0) {
        strcpy(ProgramPath, me) ;
    }

    /*
     * basename of program
     */

    for (p = ProgramPath, last = NULL ; *p ; p++) {
        if (*p == '/' || *p == '\\') {
            last = p ;
        }
    }
    if (last == NULL) {
        strcpy(ProgramName, ProgramPath) ;
    } else {
        strcpy(ProgramName, &last[1]) ;
    }
    if ((p = strrchr(ProgramName, '.')) != NULL) {
        *p = '\0' ;
    }

    /*
     * pathname of Profile
     */

    strcpy(ProfilePath, ProgramPath) ;

    if ((p = strrchr(ProfilePath, '.')) == NULL) {
        strcat(ProfilePath, ".ini") ;
    } else {
        strcpy(p, ".ini") ;
    }
}

/*
 * Program Start here
 */

int     main(int ac, char *av[])
{
    HAB     hab  ;
    HMQ     hmq  ;
    QMSG    qmsg ;

    /*
     * Initializing
     */

#ifdef DEBUG
    // morph to PM if DEBUG

    MorphToPM( );

    setbuf( stdout, NULL);
    setbuf( stdin, NULL);
#endif

#ifndef __WATCOMC__
    _wildcard(&ac, &av) ;
#endif

    myname(av[0]) ;

    sessParse(ac, av) ;

    hab = WinInitialize(0) ;
    hmq = WinCreateMsgQueue(hab, 0) ;

    if (winCreate(hab) != TRUE) {
        errMessage("failed to create window") ;
        WinDestroyMsgQueue(hmq) ;
        WinTerminate(hab) ;
        return 1 ;
    }
    if (sessSetup(hab) != TRUE) {
        winDispose(hab) ;
        WinDestroyMsgQueue(hmq) ;
        WinTerminate(hab) ;
        return 1 ;
    }

    if(DosCreateEventSem(NETSTARTSEM, &hevNETSTARTSEM, DC_SEM_SHARED, FALSE))
    {
#ifdef DEBUG
        TRACE("Network start SEM not created\n") ;
#endif
        winDispose(hab) ;
        WinDestroyMsgQueue(hmq) ;
        WinTerminate(hab) ;
        return 1 ;
    }

    if(DosCreateEventSem(NETSTOPSEM, &hevNETSTOPSEM, DC_SEM_SHARED, FALSE))
    {
#ifdef DEBUG
        TRACE("Network stop SEM not created\n") ;
#endif
        winDispose(hab) ;
        WinDestroyMsgQueue(hmq) ;
        WinTerminate(hab) ;
        return 1 ;
    }
#ifdef DEBUG
    else TRACE("Network SEMs created\n") ;
#endif

    if(!netStartup(hab))
    {
        winDispose(hab) ;
        WinDestroyMsgQueue(hmq) ;
        WinTerminate(hab) ;
        return 1 ;
    }

    if(DosWaitEventSem(hevNETSTARTSEM, 5000))
    {
#ifdef DEBUG
        TRACE("Network start SEM signal thread timeout.\n") ;
#endif
        winDispose(hab) ;
        WinDestroyMsgQueue(hmq) ;
        WinTerminate(hab) ;
        return 1 ;
    } else {
#ifdef DEBUG
        TRACE("Network start SEM signal thread start.\n") ;
#endif
        // could destroy SEM now but keep around in case needed later
        DosResetEventSem(hevNETSTARTSEM, &NETSTARTSEMCt);
    }

    /*
     * Window Processing
     */

    while (WinGetMsg(hab, &qmsg, 0, 0, 0)) {
        WinDispatchMsg(hab, &qmsg) ;
    }

#ifdef DEBUG
        TRACE("Shutdown started....\n") ;
#endif

    sessSaveProfile(hab) ;
    kmapFree() ;

    /*
     * Dispose Resources
     */

    if(!deadthread) {
        netFinish(hab);
#ifdef DEBUG
        TRACE("Thread still kicking...\n") ;
    } else TRACE("Thread already dead...\n") ;
#else
    }
#endif

    winDispose(hab) ;

    WinDestroyMsgQueue(hmq) ;
    WinTerminate(hab) ;

    return 0 ;
}
