/*
 * main.c - PM VNC Viewer, program entry
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define INCL_DOS
#define INCL_PM
#include <os2.h>

#include "pmvncdef.h"
#include "pmvncres.h"

/*
 * Name and Version of this Program
 */
 
UCHAR   ProgramVers[] = "PM VNC Viewer, Version 1.00" ;

/*
 * Error Notify
 */

void    errMessage(PSZ msg)
{
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, msg, ProgramVers, 0, MB_OK) ;
}

/*
 * Place Dialog near the mouse pointer
 */

void    dialogAtMouse(HWND hwndDialog, int target)
{
    HWND    hwndTarget = WinWindowFromID(hwndDialog, target) ;
    POINTL  pt ;
    SWP     posDlg ;
    SWP     posScr ;
    SWP     posCtl ;

    WinQueryPointerPos(HWND_DESKTOP, &pt)    ;
    WinQueryWindowPos(HWND_DESKTOP, &posScr) ;
    WinQueryWindowPos(hwndDialog,   &posDlg) ;

    if (hwndTarget != NULLHANDLE) {
        WinQueryWindowPos(hwndTarget, &posCtl) ;
    } else {
        posCtl.x  = posCtl.y  = 0 ;
        posCtl.cx = posCtl.cy = 0 ;
    }

    posDlg.x = pt.x - posCtl.x ;
    posDlg.y = pt.y - posCtl.y - (posCtl.cy / 2) ;

    if (posDlg.x < 0) {
        posDlg.x = 0 ;
    }
    if (posDlg.y < 0) {
        posDlg.y = 0 ;
    }
    if ((posDlg.x + posDlg.cx) > posScr.cx) {
        posDlg.x = posScr.cx - posDlg.cx ;
    }
    if ((posDlg.y + posDlg.cy) > posScr.cy) {
        posDlg.y = posScr.cy - posDlg.cy ;
    }
    WinSetWindowPos(hwndDialog, NULLHANDLE,
                    posDlg.x, posDlg.y, 0, 0, SWP_MOVE) ;
}

/*
 * Place Dialog at Center of Screen
 */

void    dialogAtCenter(HWND hwndDialog)
{
    SWP     posDlg ;
    SWP     posScr ;

    WinQueryWindowPos(HWND_DESKTOP, &posScr) ;
    WinQueryWindowPos(hwndDialog,   &posDlg) ;

    posDlg.x = (posScr.cx - posDlg.cx) / 2 ;
    posDlg.y = (posScr.cy - posDlg.cy) / 2 ;

    WinSetWindowPos(hwndDialog, NULLHANDLE,
                    posDlg.x, posDlg.y, 0, 0, SWP_MOVE) ;
}

/*
 * myname - trim and save Program Names
 */

UCHAR   ProgramPath[256] ;
UCHAR   ProgramName[256] ;
UCHAR   ProfilePath[256] ;

static  void    myname(PSZ me)
{
    PUCHAR  p, last ;

    /*
     * full pathname of program
     */

    for (p = me, last = NULL ; *p ; p++) {
        if (*p == '/' || *p == '\\') {
            last = p ;
        }
    }
    if (last != NULL) {
        strcpy(ProgramPath, me) ;
    } else if (DosSearchPath(7, "PATH", me, ProgramPath, 256) != 0) {
        strcpy(ProgramPath, me) ;
    }

    /*
     * basename of program
     */

    for (p = ProgramPath, last = NULL ; *p ; p++) {
        if (*p == '/' || *p == '\\') {
            last = p ;
        }
    }
    if (last == NULL) {
        strcpy(ProgramName, ProgramPath) ;
    } else {
        strcpy(ProgramName, &last[1]) ;
    }
    if ((p = strrchr(ProgramName, '.')) != NULL) {
        *p = '\0' ;
    }

    /*
     * pathname of Profile
     */

    strcpy(ProfilePath, ProgramPath) ;

    if ((p = strrchr(ProfilePath, '.')) == NULL) {
        strcat(ProfilePath, ".ini") ;
    } else {
        strcpy(p, ".ini") ;
    }
}

/*
 * Program Start here
 */

int     main(int ac, char *av[])
{
    HAB     hab  ;
    HMQ     hmq  ;
    QMSG    qmsg ;

    /*
     * Initializing
     */

    _wildcard(&ac, &av) ;
    myname(av[0]) ;

    sessParse(ac, av) ;
    
    hab = WinInitialize(0) ;
    hmq = WinCreateMsgQueue(hab, 0) ;
    
    if (winCreate(hab) != TRUE) {
        errMessage("failed to create window") ;
	WinDestroyMsgQueue(hmq) ;
	WinTerminate(hab) ;
	return 1 ;
    }
    if (sessSetup(hab) != TRUE) {
	winDispose(hab) ;
	WinDestroyMsgQueue(hmq) ;
	WinTerminate(hab) ;
	return 1 ;
    }
    if (netStartup(hab) != TRUE) {
	winDispose(hab) ;
	WinDestroyMsgQueue(hmq) ;
	WinTerminate(hab) ;
	return 1 ;
    }
    
    /*
     * Window Processing
     */
     
    while (WinGetMsg(hab, &qmsg, 0, 0, 0)) {
        WinDispatchMsg(hab, &qmsg) ;
    }

    sessSaveProfile(hab) ;
    kmapFree() ;
    
    /*
     * Dispose Resources
     */

    netFinish(hab)  ;
    winDispose(hab) ;
    
    WinDestroyMsgQueue(hmq) ;
    WinTerminate(hab) ;

    return 0 ;
}   
