/* os2_ErrCodes.h */
#ifndef OS2_ERR_CODES_H
#define OS2_ERR_CODES_H

struct OS2_ErrMsg
{  int ierrcode;
   char *msg;
};

struct OS2_ErrMsg  OS2TCPErrMessages[]=
{
 /* OS/2 SOCKETS  API definitions of regular Microsoft C 6.0 error constants */
SOCEPERM,    "Not owner",
SOCESRCH,    "No such process",
SOCEINTR,  "Interrupted system call",
SOCENXIO,  "No such device or address",
SOCEBADF,  "Bad file number",
SOCEACCES, "Permission denied",
SOCEFAULT, "Bad address",
SOCEINVAL, "Invalid argument",
SOCEMFILE, "The maximum number of sockets are currently in use",
SOCEPIPE,  "Broken pipe",
SOCEOS2ERR, "OS/2 Error",
/* OS/2 SOCKETS API definitions of regular BSD error constants */
SOCEWOULDBLOCK,        "Operation would block",
SOCEINPROGRESS,        "Operation now in progress",
SOCEALREADY,       "Operation already in progress",
SOCENOTSOCK,       "Socket operation on non-socket",
SOCEDESTADDRREQ,   "Destination address required",
SOCEMSGSIZE,       "Message too long",
SOCEPROTOTYPE,     "Protocol wrong type for socket",
SOCENOPROTOOPT,        "Protocol not available",
SOCEPROTONOSUPPORT,    "is not supported in the specified domain or the protocol is not supported for the specified socket type",
SOCESOCKTNOSUPPORT,    "Socket type not supported",
SOCEOPNOTSUPP,     "Operation not supported on socket",
SOCEPFNOSUPPORT,   "Protocol family not supported",
SOCEAFNOSUPPORT,   "Address family not supported by protocol family",
SOCEADDRINUSE,     "Address already in use",
SOCEADDRNOTAVAIL,  "Can't assign requested address",
SOCENETDOWN,       "Network is down",
SOCENETUNREACH,        "Network is unreachable",
SOCENETRESET,      "Network dropped connection on reset",
SOCECONNABORTED,   "Software caused connection abort",
SOCECONNRESET,     "Connection reset by peer",
SOCENOBUFS,        "No buffer space available",
SOCEISCONN,        "Socket is already connected",
SOCENOTCONN,       "Socket is not connected",
SOCESHUTDOWN,      "Can't send after socket shutdown",
SOCETOOMANYREFS,   "Too many references: can't splice",
SOCETIMEDOUT,      "Connection timed out",
SOCECONNREFUSED,   "Connection refused",
SOCELOOP,      "Too many levels of symbolic links",
SOCENAMETOOLONG,   "File name too long",
SOCEHOSTDOWN,      "Host is down",
SOCEHOSTUNREACH,   "No route to host",
SOCENOTEMPTY,      "Directory not empty"
};

struct OS2_ErrMsg  OS2_ErrMessages[]=
{
NO_ERROR,      "NO_ERROR",
ERROR_SUCCESS, "SUCCESS",
ERROR_INVALID_FUNCTION,        "INVALID_FUNCTION",
ERROR_FILE_NOT_FOUND,  "FILE_NOT_FOUND",
ERROR_PATH_NOT_FOUND,  "PATH_NOT_FOUND",
ERROR_TOO_MANY_OPEN_FILES,     "TOO_MANY_OPEN_FILES",
ERROR_ACCESS_DENIED,   "ACCESS_DENIED",
ERROR_INVALID_HANDLE,  "INVALID_HANDLE",
ERROR_ARENA_TRASHED,   "ARENA_TRASHED",
ERROR_NOT_ENOUGH_MEMORY,       "NOT_ENOUGH_MEMORY",
ERROR_INVALID_BLOCK,   "INVALID_BLOCK",
ERROR_BAD_ENVIRONMENT, "BAD_ENVIRONMENT",
ERROR_BAD_FORMAT,      "BAD_FORMAT",
ERROR_INVALID_ACCESS,  "INVALID_ACCESS",
ERROR_INVALID_DATA,    "INVALID_DATA",
ERROR_OUTOFMEMORY,     "OUTOFMEMORY",
ERROR_INVALID_DRIVE,   "INVALID_DRIVE",
ERROR_CURRENT_DIRECTORY,       "CURRENT_DIRECTORY",
ERROR_NOT_SAME_DEVICE, "NOT_SAME_DEVICE",
ERROR_NO_MORE_FILES,   "NO_MORE_FILES",
ERROR_WRITE_PROTECT,   "WRITE_PROTECT",
ERROR_BAD_UNIT,        "BAD_UNIT",
ERROR_NOT_READY,       "NOT_READY",
ERROR_BAD_COMMAND,     "BAD_COMMAND",
ERROR_CRC,     "CRC",
ERROR_BAD_LENGTH,      "BAD_LENGTH",
ERROR_SEEK,    "SEEK",
ERROR_NOT_DOS_DISK,    "NOT_DOS_DISK",
ERROR_SECTOR_NOT_FOUND,        "SECTOR_NOT_FOUND",
ERROR_OUT_OF_PAPER,    "OUT_OF_PAPER",
ERROR_WRITE_FAULT,     "WRITE_FAULT",
ERROR_READ_FAULT,      "READ_FAULT",
ERROR_GEN_FAILURE,     "GEN_FAILURE",
ERROR_SHARING_VIOLATION,       "SHARING_VIOLATION",
ERROR_LOCK_VIOLATION,  "LOCK_VIOLATION",
ERROR_WRONG_DISK,      "WRONG_DISK",
ERROR_SHARING_BUFFER_EXCEEDED, "SHARING_BUFFER_EXCEEDED",
ERROR_HANDLE_EOF,      "HANDLE_EOF",
ERROR_HANDLE_DISK_FULL,        "HANDLE_DISK_FULL",
ERROR_NOT_SUPPORTED,   "NOT_SUPPORTED",
ERROR_REM_NOT_LIST,    "REM_NOT_LIST",
ERROR_DUP_NAME,        "DUP_NAME",
ERROR_BAD_NETPATH,     "BAD_NETPATH",
ERROR_NETWORK_BUSY,    "NETWORK_BUSY",
ERROR_DEV_NOT_EXIST,   "DEV_NOT_EXIST",
ERROR_TOO_MANY_CMDS,   "TOO_MANY_CMDS",
ERROR_ADAP_HDW_ERR,    "ADAP_HDW_ERR",
ERROR_BAD_NET_RESP,    "BAD_NET_RESP",
ERROR_UNEXP_NET_ERR,   "UNEXP_NET_ERR",
ERROR_BAD_REM_ADAP,    "BAD_REM_ADAP",
ERROR_PRINTQ_FULL,     "PRINTQ_FULL",
ERROR_NO_SPOOL_SPACE,  "NO_SPOOL_SPACE",
ERROR_PRINT_CANCELLED, "PRINT_CANCELLED",
ERROR_NETNAME_DELETED, "NETNAME_DELETED",
ERROR_NETWORK_ACCESS_DENIED,   "NETWORK_ACCESS_DENIED",
ERROR_BAD_DEV_TYPE,    "BAD_DEV_TYPE",
ERROR_BAD_NET_NAME,    "BAD_NET_NAME",
ERROR_TOO_MANY_NAMES,  "TOO_MANY_NAMES",
ERROR_TOO_MANY_SESS,   "TOO_MANY_SESS",
ERROR_SHARING_PAUSED,  "SHARING_PAUSED",
ERROR_REQ_NOT_ACCEP,   "REQ_NOT_ACCEP",
ERROR_REDIR_PAUSED,    "REDIR_PAUSED",
ERROR_FILE_EXISTS,     "FILE_EXISTS",
ERROR_CANNOT_MAKE,     "CANNOT_MAKE",
ERROR_FAIL_I24,        "FAIL_I24",
ERROR_OUT_OF_STRUCTURES,       "OUT_OF_STRUCTURES",
ERROR_ALREADY_ASSIGNED,        "ALREADY_ASSIGNED",
ERROR_INVALID_PASSWORD,        "INVALID_PASSWORD",
ERROR_INVALID_PARAMETER,       "INVALID_PARAMETER",
ERROR_NET_WRITE_FAULT, "NET_WRITE_FAULT",
ERROR_NO_PROC_SLOTS,   "NO_PROC_SLOTS",
ERROR_TOO_MANY_SEMAPHORES,     "TOO_MANY_SEMAPHORES",
ERROR_EXCL_SEM_ALREADY_OWNED,  "EXCL_SEM_ALREADY_OWNED",
ERROR_SEM_IS_SET,      "SEM_IS_SET",
ERROR_TOO_MANY_SEM_REQUESTS,   "TOO_MANY_SEM_REQUESTS",
ERROR_INVALID_AT_INTERRUPT_TIME,       "INVALID_AT_INTERRUPT_TIME",
ERROR_SEM_OWNER_DIED,  "SEM_OWNER_DIED",
ERROR_SEM_USER_LIMIT,  "SEM_USER_LIMIT",
ERROR_DISK_CHANGE,     "DISK_CHANGE",
ERROR_DRIVE_LOCKED,    "DRIVE_LOCKED",
ERROR_BROKEN_PIPE,     "BROKEN_PIPE",
ERROR_OPEN_FAILED,     "OPEN_FAILED",
ERROR_BUFFER_OVERFLOW, "BUFFER_OVERFLOW",
ERROR_DISK_FULL,       "DISK_FULL",
ERROR_NO_MORE_SEARCH_HANDLES,  "NO_MORE_SEARCH_HANDLES",
ERROR_INVALID_TARGET_HANDLE,   "INVALID_TARGET_HANDLE",
ERROR_INVALID_CATEGORY,        "INVALID_CATEGORY",
ERROR_INVALID_VERIFY_SWITCH,   "INVALID_VERIFY_SWITCH",
ERROR_BAD_DRIVER_LEVEL,        "BAD_DRIVER_LEVEL",
ERROR_CALL_NOT_IMPLEMENTED,    "CALL_NOT_IMPLEMENTED",
ERROR_SEM_TIMEOUT,     "SEM_TIMEOUT",
ERROR_INSUFFICIENT_BUFFER,     "INSUFFICIENT_BUFFER",
ERROR_INVALID_NAME,    "INVALID_NAME",
ERROR_INVALID_LEVEL,   "INVALID_LEVEL",
ERROR_NO_VOLUME_LABEL, "NO_VOLUME_LABEL",
ERROR_MOD_NOT_FOUND,   "MOD_NOT_FOUND",
ERROR_PROC_NOT_FOUND,  "PROC_NOT_FOUND",
ERROR_WAIT_NO_CHILDREN,        "WAIT_NO_CHILDREN",
ERROR_CHILD_NOT_COMPLETE,      "CHILD_NOT_COMPLETE",
ERROR_DIRECT_ACCESS_HANDLE,    "DIRECT_ACCESS_HANDLE",
ERROR_NEGATIVE_SEEK,   "NEGATIVE_SEEK",
ERROR_SEEK_ON_DEVICE,  "SEEK_ON_DEVICE",
ERROR_IS_JOIN_TARGET,  "IS_JOIN_TARGET",
ERROR_IS_JOINED,       "IS_JOINED",
ERROR_IS_SUBSTED,      "IS_SUBSTED",
ERROR_NOT_JOINED,      "NOT_JOINED",
ERROR_NOT_SUBSTED,     "NOT_SUBSTED",
ERROR_JOIN_TO_JOIN,    "JOIN_TO_JOIN",
ERROR_SUBST_TO_SUBST,  "SUBST_TO_SUBST",
ERROR_JOIN_TO_SUBST,   "JOIN_TO_SUBST",
ERROR_SUBST_TO_JOIN,   "SUBST_TO_JOIN",
ERROR_BUSY_DRIVE,      "BUSY_DRIVE",
ERROR_SAME_DRIVE,      "SAME_DRIVE",
ERROR_DIR_NOT_ROOT,    "DIR_NOT_ROOT",
ERROR_DIR_NOT_EMPTY,   "DIR_NOT_EMPTY",
ERROR_IS_SUBST_PATH,   "IS_SUBST_PATH",
ERROR_IS_JOIN_PATH,    "IS_JOIN_PATH",
ERROR_PATH_BUSY,       "PATH_BUSY",
ERROR_IS_SUBST_TARGET, "IS_SUBST_TARGET",
ERROR_SYSTEM_TRACE,    "SYSTEM_TRACE",
ERROR_INVALID_EVENT_COUNT,     "INVALID_EVENT_COUNT",
ERROR_TOO_MANY_MUXWAITERS,     "TOO_MANY_MUXWAITERS",
ERROR_INVALID_LIST_FORMAT,     "INVALID_LIST_FORMAT",
ERROR_LABEL_TOO_LONG,  "LABEL_TOO_LONG",
ERROR_TOO_MANY_TCBS,   "TOO_MANY_TCBS",
ERROR_SIGNAL_REFUSED,  "SIGNAL_REFUSED",
ERROR_DISCARDED,       "DISCARDED",
ERROR_NOT_LOCKED,      "NOT_LOCKED",
ERROR_BAD_THREADID_ADDR,       "BAD_THREADID_ADDR",
ERROR_BAD_ARGUMENTS,   "BAD_ARGUMENTS",
ERROR_BAD_PATHNAME,    "BAD_PATHNAME",
ERROR_SIGNAL_PENDING,  "SIGNAL_PENDING",
ERROR_MAX_THRDS_REACHED,       "MAX_THRDS_REACHED",
ERROR_LOCK_FAILED,     "LOCK_FAILED",
ERROR_BUSY,    "BUSY",
ERROR_CANCEL_VIOLATION,        "CANCEL_VIOLATION",
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED,      "ATOMIC_LOCKS_NOT_SUPPORTED",
ERROR_INVALID_SEGMENT_NUMBER,  "INVALID_SEGMENT_NUMBER",
ERROR_INVALID_ORDINAL, "INVALID_ORDINAL",
ERROR_ALREADY_EXISTS,  "ALREADY_EXISTS",
ERROR_INVALID_FLAG_NUMBER,     "INVALID_FLAG_NUMBER",
ERROR_SEM_NOT_FOUND,   "SEM_NOT_FOUND",
ERROR_INVALID_STARTING_CODESEG,        "INVALID_STARTING_CODESEG",
ERROR_INVALID_STACKSEG,        "INVALID_STACKSEG",
ERROR_INVALID_MODULETYPE,      "INVALID_MODULETYPE",
ERROR_INVALID_EXE_SIGNATURE,   "INVALID_EXE_SIGNATURE",
ERROR_EXE_MARKED_INVALID,      "EXE_MARKED_INVALID",
ERROR_BAD_EXE_FORMAT,  "BAD_EXE_FORMAT",
ERROR_ITERATED_DATA_EXCEEDS_64k,       "ITERATED_DATA_EXCEEDS_64k",
ERROR_INVALID_MINALLOCSIZE,    "INVALID_MINALLOCSIZE",
ERROR_DYNLINK_FROM_INVALID_RING,       "DYNLINK_FROM_INVALID_RING",
ERROR_IOPL_NOT_ENABLED,        "IOPL_NOT_ENABLED",
ERROR_INVALID_SEGDPL,  "INVALID_SEGDPL",
ERROR_AUTODATASEG_EXCEEDS_64k, "AUTODATASEG_EXCEEDS_64k",
ERROR_RING2SEG_MUST_BE_MOVABLE,        "RING2SEG_MUST_BE_MOVABLE",
ERROR_RELOC_CHAIN_XEEDS_SEGLIM,        "RELOC_CHAIN_XEEDS_SEGLIM",
ERROR_INFLOOP_IN_RELOC_CHAIN,  "INFLOOP_IN_RELOC_CHAIN",
ERROR_ENVVAR_NOT_FOUND,        "ENVVAR_NOT_FOUND",
ERROR_NO_SIGNAL_SENT,  "NO_SIGNAL_SENT",
ERROR_FILENAME_EXCED_RANGE,    "FILENAME_EXCED_RANGE",
ERROR_RING2_STACK_IN_USE,      "RING2_STACK_IN_USE",
ERROR_META_EXPANSION_TOO_LONG, "META_EXPANSION_TOO_LONG",
ERROR_INVALID_SIGNAL_NUMBER,   "INVALID_SIGNAL_NUMBER",
ERROR_THREAD_1_INACTIVE,       "THREAD_1_INACTIVE",
ERROR_LOCKED,  "LOCKED",
ERROR_TOO_MANY_MODULES,        "TOO_MANY_MODULES",
ERROR_NESTING_NOT_ALLOWED,     "NESTING_NOT_ALLOWED",
ERROR_BAD_PIPE,        "BAD_PIPE",
ERROR_PIPE_BUSY,       "PIPE_BUSY",
ERROR_NO_DATA, "NO_DATA",
ERROR_PIPE_NOT_CONNECTED,      "PIPE_NOT_CONNECTED",
ERROR_MORE_DATA,       "MORE_DATA",
ERROR_VC_DISCONNECTED, "VC_DISCONNECTED",
ERROR_INVALID_EA_NAME, "INVALID_EA_NAME",
ERROR_EA_LIST_INCONSISTENT,    "EA_LIST_INCONSISTENT",
ERROR_NO_MORE_ITEMS,   "NO_MORE_ITEMS",
ERROR_CANNOT_COPY,     "CANNOT_COPY",
ERROR_DIRECTORY,       "DIRECTORY",
ERROR_EAS_DIDNT_FIT,   "EAS_DIDNT_FIT",
ERROR_EA_FILE_CORRUPT, "EA_FILE_CORRUPT",
ERROR_EA_TABLE_FULL,   "EA_TABLE_FULL",
ERROR_INVALID_EA_HANDLE,       "INVALID_EA_HANDLE",
ERROR_EAS_NOT_SUPPORTED,       "EAS_NOT_SUPPORTED",
ERROR_NOT_OWNER,       "NOT_OWNER",
ERROR_TOO_MANY_POSTS,  "TOO_MANY_POSTS",
ERROR_PARTIAL_COPY,    "PARTIAL_COPY",
ERROR_MR_MID_NOT_FOUND,        "MR_MID_NOT_FOUND",
ERROR_INVALID_ADDRESS, "INVALID_ADDRESS",
ERROR_ARITHMETIC_OVERFLOW,     "ARITHMETIC_OVERFLOW",
ERROR_PIPE_CONNECTED,  "PIPE_CONNECTED",
ERROR_PIPE_LISTENING,  "PIPE_LISTENING",
ERROR_EA_ACCESS_DENIED,        "EA_ACCESS_DENIED",
ERROR_OPERATION_ABORTED,       "OPERATION_ABORTED",
ERROR_IO_INCOMPLETE,   "IO_INCOMPLETE",
ERROR_IO_PENDING,      "IO_PENDING",
ERROR_NOACCESS,        "NOACCESS",
ERROR_SWAPERROR,       "SWAPERROR",
ERROR_STACK_OVERFLOW,  "STACK_OVERFLOW",
ERROR_INVALID_MESSAGE, "INVALID_MESSAGE",
ERROR_CAN_NOT_COMPLETE,        "CAN_NOT_COMPLETE",
ERROR_INVALID_FLAGS,   "INVALID_FLAGS",
ERROR_UNRECOGNIZED_VOLUME,     "UNRECOGNIZED_VOLUME",
ERROR_FILE_INVALID,    "FILE_INVALID",
ERROR_FULLSCREEN_MODE, "FULLSCREEN_MODE",
ERROR_NO_TOKEN,        "NO_TOKEN",
ERROR_BADDB,   "BADDB",
ERROR_BADKEY,  "BADKEY",
ERROR_CANTOPEN,        "CANTOPEN",
ERROR_CANTREAD,        "CANTREAD",
ERROR_CANTWRITE,       "CANTWRITE",
ERROR_REGISTRY_RECOVERED,      "REGISTRY_RECOVERED",
ERROR_REGISTRY_CORRUPT,        "REGISTRY_CORRUPT",
ERROR_REGISTRY_IO_FAILED,      "REGISTRY_IO_FAILED",
ERROR_NOT_REGISTRY_FILE,       "NOT_REGISTRY_FILE",
ERROR_KEY_DELETED,     "KEY_DELETED",
ERROR_NO_LOG_SPACE,    "NO_LOG_SPACE",
ERROR_KEY_HAS_CHILDREN,        "KEY_HAS_CHILDREN",
ERROR_CHILD_MUST_BE_VOLATILE,  "CHILD_MUST_BE_VOLATILE",
ERROR_NOTIFY_ENUM_DIR, "NOTIFY_ENUM_DIR",
ERROR_DEPENDENT_SERVICES_RUNNING,      "DEPENDENT_SERVICES_RUNNING",
ERROR_INVALID_SERVICE_CONTROL, "INVALID_SERVICE_CONTROL",
ERROR_SERVICE_REQUEST_TIMEOUT, "SERVICE_REQUEST_TIMEOUT",
ERROR_SERVICE_NO_THREAD,       "SERVICE_NO_THREAD",
ERROR_SERVICE_DATABASE_LOCKED, "SERVICE_DATABASE_LOCKED",
ERROR_SERVICE_ALREADY_RUNNING, "SERVICE_ALREADY_RUNNING",
ERROR_INVALID_SERVICE_ACCOUNT, "INVALID_SERVICE_ACCOUNT",
ERROR_SERVICE_DISABLED,        "SERVICE_DISABLED",
ERROR_CIRCULAR_DEPENDENCY,     "CIRCULAR_DEPENDENCY",
ERROR_SERVICE_DOES_NOT_EXIST,  "SERVICE_DOES_NOT_EXIST",
ERROR_SERVICE_CANNOT_ACCEPT_CTRL,      "SERVICE_CANNOT_ACCEPT_CTRL",
ERROR_SERVICE_NOT_ACTIVE,      "SERVICE_NOT_ACTIVE",
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT,       "FAILED_SERVICE_CONTROLLER_CONNECT",
ERROR_EXCEPTION_IN_SERVICE,    "EXCEPTION_IN_SERVICE",
ERROR_DATABASE_DOES_NOT_EXIST, "DATABASE_DOES_NOT_EXIST",
ERROR_SERVICE_SPECIFIC_ERROR,  "SERVICE_SPECIFIC_ERROR",
ERROR_PROCESS_ABORTED, "PROCESS_ABORTED",
ERROR_SERVICE_DEPENDENCY_FAIL, "SERVICE_DEPENDENCY_FAIL",
ERROR_SERVICE_LOGON_FAILED,    "SERVICE_LOGON_FAILED",
ERROR_SERVICE_START_HANG,      "SERVICE_START_HANG",
ERROR_INVALID_SERVICE_LOCK,    "INVALID_SERVICE_LOCK",
ERROR_SERVICE_MARKED_FOR_DELETE,       "SERVICE_MARKED_FOR_DELETE",
ERROR_SERVICE_EXISTS,  "SERVICE_EXISTS",
ERROR_ALREADY_RUNNING_LKG,     "ALREADY_RUNNING_LKG",
ERROR_SERVICE_DEPENDENCY_DELETED,      "SERVICE_DEPENDENCY_DELETED",
ERROR_BOOT_ALREADY_ACCEPTED,   "BOOT_ALREADY_ACCEPTED",
ERROR_SERVICE_NEVER_STARTED,   "SERVICE_NEVER_STARTED",
ERROR_DUPLICATE_SERVICE_NAME,  "DUPLICATE_SERVICE_NAME",
ERROR_END_OF_MEDIA,    "END_OF_MEDIA",
ERROR_FILEMARK_DETECTED,       "FILEMARK_DETECTED",
ERROR_BEGINNING_OF_MEDIA,      "BEGINNING_OF_MEDIA",
ERROR_SETMARK_DETECTED,        "SETMARK_DETECTED",
ERROR_NO_DATA_DETECTED,        "NO_DATA_DETECTED",
ERROR_PARTITION_FAILURE,       "PARTITION_FAILURE",
ERROR_INVALID_BLOCK_LENGTH,    "INVALID_BLOCK_LENGTH",
ERROR_DEVICE_NOT_PARTITIONED,  "DEVICE_NOT_PARTITIONED",
ERROR_UNABLE_TO_LOCK_MEDIA,    "UNABLE_TO_LOCK_MEDIA",
ERROR_UNABLE_TO_UNLOAD_MEDIA,  "UNABLE_TO_UNLOAD_MEDIA",
ERROR_MEDIA_CHANGED,   "MEDIA_CHANGED",
ERROR_BUS_RESET,       "BUS_RESET",
ERROR_NO_MEDIA_IN_DRIVE,       "NO_MEDIA_IN_DRIVE",
ERROR_NO_UNICODE_TRANSLATION,  "NO_UNICODE_TRANSLATION",
ERROR_DLL_INIT_FAILED, "DLL_INIT_FAILED",
ERROR_SHUTDOWN_IN_PROGRESS,    "SHUTDOWN_IN_PROGRESS",
ERROR_NO_SHUTDOWN_IN_PROGRESS, "NO_SHUTDOWN_IN_PROGRESS",
ERROR_IO_DEVICE,       "IO_DEVICE",
ERROR_SERIAL_NO_DEVICE,        "SERIAL_NO_DEVICE",
ERROR_IRQ_BUSY,        "IRQ_BUSY",
ERROR_MORE_WRITES,     "MORE_WRITES",
ERROR_COUNTER_TIMEOUT, "COUNTER_TIMEOUT",
ERROR_FLOPPY_ID_MARK_NOT_FOUND,        "FLOPPY_ID_MARK_NOT_FOUND",
ERROR_FLOPPY_WRONG_CYLINDER,   "FLOPPY_WRONG_CYLINDER",
ERROR_FLOPPY_UNKNOWN_ERROR,    "FLOPPY_UNKNOWN_ERROR",
ERROR_FLOPPY_BAD_REGISTERS,    "FLOPPY_BAD_REGISTERS",
ERROR_DISK_RECALIBRATE_FAILED, "DISK_RECALIBRATE_FAILED",
ERROR_DISK_OPERATION_FAILED,   "DISK_OPERATION_FAILED",
ERROR_DISK_RESET_FAILED,       "DISK_RESET_FAILED",
ERROR_EOM_OVERFLOW,    "EOM_OVERFLOW",
ERROR_NOT_ENOUGH_SERVER_MEMORY,        "NOT_ENOUGH_SERVER_MEMORY",
ERROR_POSSIBLE_DEADLOCK,       "POSSIBLE_DEADLOCK",
ERROR_MAPPED_ALIGNMENT,        "MAPPED_ALIGNMENT",
ERROR_BAD_USERNAME,    "BAD_USERNAME",
ERROR_NOT_CONNECTED,   "NOT_CONNECTED",
ERROR_OPEN_FILES,      "OPEN_FILES",
ERROR_ACTIVE_CONNECTIONS,      "ACTIVE_CONNECTIONS",
ERROR_DEVICE_IN_USE,   "DEVICE_IN_USE",
ERROR_BAD_DEVICE,      "BAD_DEVICE",
ERROR_CONNECTION_UNAVAIL,      "CONNECTION_UNAVAIL",
ERROR_DEVICE_ALREADY_REMEMBERED,       "DEVICE_ALREADY_REMEMBERED",
ERROR_NO_NET_OR_BAD_PATH,      "NO_NET_OR_BAD_PATH",
ERROR_BAD_PROVIDER,    "BAD_PROVIDER",
ERROR_CANNOT_OPEN_PROFILE,     "CANNOT_OPEN_PROFILE",
ERROR_BAD_PROFILE,     "BAD_PROFILE",
ERROR_NOT_CONTAINER,   "NOT_CONTAINER",
ERROR_EXTENDED_ERROR,  "EXTENDED_ERROR",
ERROR_INVALID_GROUPNAME,       "INVALID_GROUPNAME",
ERROR_INVALID_COMPUTERNAME,    "INVALID_COMPUTERNAME",
ERROR_INVALID_EVENTNAME,       "INVALID_EVENTNAME",
ERROR_INVALID_DOMAINNAME,      "INVALID_DOMAINNAME",
ERROR_INVALID_SERVICENAME,     "INVALID_SERVICENAME",
ERROR_INVALID_NETNAME, "INVALID_NETNAME",
ERROR_INVALID_SHARENAME,       "INVALID_SHARENAME",
ERROR_INVALID_PASSWORDNAME,    "INVALID_PASSWORDNAME",
ERROR_INVALID_MESSAGENAME,     "INVALID_MESSAGENAME",
ERROR_INVALID_MESSAGEDEST,     "INVALID_MESSAGEDEST",
ERROR_SESSION_CREDENTIAL_CONFLICT,     "SESSION_CREDENTIAL_CONFLICT",
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED,   "REMOTE_SESSION_LIMIT_EXCEEDED",
ERROR_DUP_DOMAINNAME,  "DUP_DOMAINNAME",
ERROR_NO_NETWORK,      "NO_NETWORK",
ERROR_CANCELLED,       "CANCELLED",
ERROR_USER_MAPPED_FILE,        "USER_MAPPED_FILE",
ERROR_CONNECTION_REFUSED,      "CONNECTION_REFUSED",
ERROR_GRACEFUL_DISCONNECT,     "GRACEFUL_DISCONNECT",
ERROR_ADDRESS_ALREADY_ASSOCIATED,      "ADDRESS_ALREADY_ASSOCIATED",
ERROR_ADDRESS_NOT_ASSOCIATED,  "ADDRESS_NOT_ASSOCIATED",
ERROR_CONNECTION_INVALID,      "CONNECTION_INVALID",
ERROR_CONNECTION_ACTIVE,       "CONNECTION_ACTIVE",
ERROR_NETWORK_UNREACHABLE,     "NETWORK_UNREACHABLE",
ERROR_HOST_UNREACHABLE,        "HOST_UNREACHABLE",
ERROR_PROTOCOL_UNREACHABLE,    "PROTOCOL_UNREACHABLE",
ERROR_PORT_UNREACHABLE,        "PORT_UNREACHABLE",
ERROR_REQUEST_ABORTED, "REQUEST_ABORTED",
ERROR_CONNECTION_ABORTED,      "CONNECTION_ABORTED",
ERROR_RETRY,   "RETRY",
ERROR_CONNECTION_COUNT_LIMIT,  "CONNECTION_COUNT_LIMIT",
ERROR_LOGIN_TIME_RESTRICTION,  "LOGIN_TIME_RESTRICTION",
ERROR_LOGIN_WKSTA_RESTRICTION, "LOGIN_WKSTA_RESTRICTION",
ERROR_INCORRECT_ADDRESS,       "INCORRECT_ADDRESS",
ERROR_ALREADY_REGISTERED,      "ALREADY_REGISTERED",
ERROR_SERVICE_NOT_FOUND,       "SERVICE_NOT_FOUND",
ERROR_NOT_ALL_ASSIGNED,        "NOT_ALL_ASSIGNED",
ERROR_SOME_NOT_MAPPED, "SOME_NOT_MAPPED",
ERROR_NO_QUOTAS_FOR_ACCOUNT,   "NO_QUOTAS_FOR_ACCOUNT",
ERROR_LOCAL_USER_SESSION_KEY,  "LOCAL_USER_SESSION_KEY",
ERROR_NULL_LM_PASSWORD,        "NULL_LM_PASSWORD",
ERROR_UNKNOWN_REVISION,        "UNKNOWN_REVISION",
ERROR_REVISION_MISMATCH,       "REVISION_MISMATCH",
ERROR_INVALID_OWNER,   "INVALID_OWNER",
ERROR_INVALID_PRIMARY_GROUP,   "INVALID_PRIMARY_GROUP",
ERROR_NO_IMPERSONATION_TOKEN,  "NO_IMPERSONATION_TOKEN",
ERROR_CANT_DISABLE_MANDATORY,  "CANT_DISABLE_MANDATORY",
ERROR_NO_LOGON_SERVERS,        "NO_LOGON_SERVERS",
ERROR_NO_SUCH_LOGON_SESSION,   "NO_SUCH_LOGON_SESSION",
ERROR_NO_SUCH_PRIVILEGE,       "NO_SUCH_PRIVILEGE",
ERROR_PRIVILEGE_NOT_HELD,      "PRIVILEGE_NOT_HELD",
ERROR_INVALID_ACCOUNT_NAME,    "INVALID_ACCOUNT_NAME",
ERROR_USER_EXISTS,     "USER_EXISTS",
ERROR_NO_SUCH_USER,    "NO_SUCH_USER",
ERROR_GROUP_EXISTS,    "GROUP_EXISTS",
ERROR_NO_SUCH_GROUP,   "NO_SUCH_GROUP",
ERROR_MEMBER_IN_GROUP, "MEMBER_IN_GROUP",
ERROR_MEMBER_NOT_IN_GROUP,     "MEMBER_NOT_IN_GROUP",
ERROR_LAST_ADMIN,      "LAST_ADMIN",
ERROR_WRONG_PASSWORD,  "WRONG_PASSWORD",
ERROR_ILL_FORMED_PASSWORD,     "ILL_FORMED_PASSWORD",
ERROR_PASSWORD_RESTRICTION,    "PASSWORD_RESTRICTION",
ERROR_LOGON_FAILURE,   "LOGON_FAILURE",
ERROR_ACCOUNT_RESTRICTION,     "ACCOUNT_RESTRICTION",
ERROR_INVALID_LOGON_HOURS,     "INVALID_LOGON_HOURS",
ERROR_INVALID_WORKSTATION,     "INVALID_WORKSTATION",
ERROR_PASSWORD_EXPIRED,        "PASSWORD_EXPIRED",
ERROR_ACCOUNT_DISABLED,        "ACCOUNT_DISABLED",
ERROR_NONE_MAPPED,     "NONE_MAPPED",
ERROR_TOO_MANY_LUIDS_REQUESTED,        "TOO_MANY_LUIDS_REQUESTED",
ERROR_LUIDS_EXHAUSTED, "LUIDS_EXHAUSTED",
ERROR_INVALID_SUB_AUTHORITY,   "INVALID_SUB_AUTHORITY",
ERROR_INVALID_ACL,     "INVALID_ACL",
ERROR_INVALID_SID,     "INVALID_SID",
ERROR_INVALID_SECURITY_DESCR,  "INVALID_SECURITY_DESCR",
ERROR_BAD_INHERITANCE_ACL,     "BAD_INHERITANCE_ACL",
ERROR_SERVER_DISABLED, "SERVER_DISABLED",
ERROR_SERVER_NOT_DISABLED,     "SERVER_NOT_DISABLED",
ERROR_INVALID_ID_AUTHORITY,    "INVALID_ID_AUTHORITY",
ERROR_ALLOTTED_SPACE_EXCEEDED, "ALLOTTED_SPACE_EXCEEDED",
ERROR_INVALID_GROUP_ATTRIBUTES,        "INVALID_GROUP_ATTRIBUTES",
ERROR_BAD_IMPERSONATION_LEVEL, "BAD_IMPERSONATION_LEVEL",
ERROR_CANT_OPEN_ANONYMOUS,     "CANT_OPEN_ANONYMOUS",
ERROR_BAD_VALIDATION_CLASS,    "BAD_VALIDATION_CLASS",
ERROR_BAD_TOKEN_TYPE,  "BAD_TOKEN_TYPE",
ERROR_NO_SECURITY_ON_OBJECT,   "NO_SECURITY_ON_OBJECT",
ERROR_CANT_ACCESS_DOMAIN_INFO, "CANT_ACCESS_DOMAIN_INFO",
ERROR_INVALID_SERVER_STATE,    "INVALID_SERVER_STATE",
ERROR_INVALID_DOMAIN_STATE,    "INVALID_DOMAIN_STATE",
ERROR_INVALID_DOMAIN_ROLE,     "INVALID_DOMAIN_ROLE",
ERROR_NO_SUCH_DOMAIN,  "NO_SUCH_DOMAIN",
ERROR_DOMAIN_EXISTS,   "DOMAIN_EXISTS",
ERROR_DOMAIN_LIMIT_EXCEEDED,   "DOMAIN_LIMIT_EXCEEDED",
ERROR_INTERNAL_DB_CORRUPTION,  "INTERNAL_DB_CORRUPTION",
ERROR_INTERNAL_ERROR,  "INTERNAL_ERROR",
ERROR_GENERIC_NOT_MAPPED,      "GENERIC_NOT_MAPPED",
ERROR_BAD_DESCRIPTOR_FORMAT,   "BAD_DESCRIPTOR_FORMAT",
ERROR_NOT_LOGON_PROCESS,       "NOT_LOGON_PROCESS",
ERROR_LOGON_SESSION_EXISTS,    "LOGON_SESSION_EXISTS",
ERROR_NO_SUCH_PACKAGE, "NO_SUCH_PACKAGE",
ERROR_BAD_LOGON_SESSION_STATE, "BAD_LOGON_SESSION_STATE",
ERROR_LOGON_SESSION_COLLISION, "LOGON_SESSION_COLLISION",
ERROR_INVALID_LOGON_TYPE,      "INVALID_LOGON_TYPE",
ERROR_CANNOT_IMPERSONATE,      "CANNOT_IMPERSONATE",
ERROR_RXACT_INVALID_STATE,     "RXACT_INVALID_STATE",
ERROR_RXACT_COMMIT_FAILURE,    "RXACT_COMMIT_FAILURE",
ERROR_SPECIAL_ACCOUNT, "SPECIAL_ACCOUNT",
ERROR_SPECIAL_GROUP,   "SPECIAL_GROUP",
ERROR_SPECIAL_USER,    "SPECIAL_USER",
ERROR_MEMBERS_PRIMARY_GROUP,   "MEMBERS_PRIMARY_GROUP",
ERROR_TOKEN_ALREADY_IN_USE,    "TOKEN_ALREADY_IN_USE",
ERROR_NO_SUCH_ALIAS,   "NO_SUCH_ALIAS",
ERROR_MEMBER_NOT_IN_ALIAS,     "MEMBER_NOT_IN_ALIAS",
ERROR_MEMBER_IN_ALIAS, "MEMBER_IN_ALIAS",
ERROR_ALIAS_EXISTS,    "ALIAS_EXISTS",
ERROR_LOGON_NOT_GRANTED,       "LOGON_NOT_GRANTED",
ERROR_TOO_MANY_SECRETS,        "TOO_MANY_SECRETS",
ERROR_SECRET_TOO_LONG, "SECRET_TOO_LONG",
ERROR_INTERNAL_DB_ERROR,       "INTERNAL_DB_ERROR",
ERROR_TOO_MANY_CONTEXT_IDS,    "TOO_MANY_CONTEXT_IDS",
ERROR_LOGON_TYPE_NOT_GRANTED,  "LOGON_TYPE_NOT_GRANTED",
ERROR_NT_CROSS_ENCRYPTION_REQUIRED,    "NT_CROSS_ENCRYPTION_REQUIRED",
ERROR_NO_SUCH_MEMBER,  "NO_SUCH_MEMBER",
ERROR_INVALID_MEMBER,  "INVALID_MEMBER",
ERROR_TOO_MANY_SIDS,   "TOO_MANY_SIDS",
ERROR_LM_CROSS_ENCRYPTION_REQUIRED,    "LM_CROSS_ENCRYPTION_REQUIRED",
ERROR_NO_INHERITANCE,  "NO_INHERITANCE",
ERROR_FILE_CORRUPT,    "FILE_CORRUPT",
ERROR_DISK_CORRUPT,    "DISK_CORRUPT",
ERROR_NO_USER_SESSION_KEY,     "NO_USER_SESSION_KEY",
ERROR_INVALID_WINDOW_HANDLE,   "INVALID_WINDOW_HANDLE",
ERROR_INVALID_MENU_HANDLE,     "INVALID_MENU_HANDLE",
ERROR_INVALID_CURSOR_HANDLE,   "INVALID_CURSOR_HANDLE",
ERROR_INVALID_ACCEL_HANDLE,    "INVALID_ACCEL_HANDLE",
ERROR_INVALID_HOOK_HANDLE,     "INVALID_HOOK_HANDLE",
ERROR_INVALID_DWP_HANDLE,      "INVALID_DWP_HANDLE",
ERROR_TLW_WITH_WSCHILD,        "TLW_WITH_WSCHILD",
ERROR_CANNOT_FIND_WND_CLASS,   "CANNOT_FIND_WND_CLASS",
ERROR_WINDOW_OF_OTHER_THREAD,  "WINDOW_OF_OTHER_THREAD",
ERROR_HOTKEY_ALREADY_REGISTERED,       "HOTKEY_ALREADY_REGISTERED",
ERROR_CLASS_ALREADY_EXISTS,    "CLASS_ALREADY_EXISTS",
ERROR_CLASS_DOES_NOT_EXIST,    "CLASS_DOES_NOT_EXIST",
ERROR_CLASS_HAS_WINDOWS,       "CLASS_HAS_WINDOWS",
ERROR_INVALID_INDEX,   "INVALID_INDEX",
ERROR_INVALID_ICON_HANDLE,     "INVALID_ICON_HANDLE",
ERROR_PRIVATE_DIALOG_INDEX,    "PRIVATE_DIALOG_INDEX",
ERROR_LISTBOX_ID_NOT_FOUND,    "LISTBOX_ID_NOT_FOUND",
ERROR_NO_WILDCARD_CHARACTERS,  "NO_WILDCARD_CHARACTERS",
ERROR_CLIPBOARD_NOT_OPEN,      "CLIPBOARD_NOT_OPEN",
ERROR_HOTKEY_NOT_REGISTERED,   "HOTKEY_NOT_REGISTERED",
ERROR_WINDOW_NOT_DIALOG,       "WINDOW_NOT_DIALOG",
ERROR_CONTROL_ID_NOT_FOUND,    "CONTROL_ID_NOT_FOUND",
ERROR_INVALID_COMBOBOX_MESSAGE,        "INVALID_COMBOBOX_MESSAGE",
ERROR_WINDOW_NOT_COMBOBOX,     "WINDOW_NOT_COMBOBOX",
ERROR_INVALID_EDIT_HEIGHT,     "INVALID_EDIT_HEIGHT",
ERROR_DC_NOT_FOUND,    "DC_NOT_FOUND",
ERROR_INVALID_HOOK_FILTER,     "INVALID_HOOK_FILTER",
ERROR_INVALID_FILTER_PROC,     "INVALID_FILTER_PROC",
ERROR_HOOK_NEEDS_HMOD, "HOOK_NEEDS_HMOD",
ERROR_GLOBAL_ONLY_HOOK,        "GLOBAL_ONLY_HOOK",
ERROR_JOURNAL_HOOK_SET,        "JOURNAL_HOOK_SET",
ERROR_HOOK_NOT_INSTALLED,      "HOOK_NOT_INSTALLED",
ERROR_INVALID_LB_MESSAGE,      "INVALID_LB_MESSAGE",
ERROR_SETCOUNT_ON_BAD_LB,      "SETCOUNT_ON_BAD_LB",
ERROR_LB_WITHOUT_TABSTOPS,     "LB_WITHOUT_TABSTOPS",
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD,  "DESTROY_OBJECT_OF_OTHER_THREAD",
ERROR_CHILD_WINDOW_MENU,       "CHILD_WINDOW_MENU",
ERROR_NO_SYSTEM_MENU,  "NO_SYSTEM_MENU",
ERROR_INVALID_MSGBOX_STYLE,    "INVALID_MSGBOX_STYLE",
ERROR_INVALID_SPI_VALUE,       "INVALID_SPI_VALUE",
ERROR_SCREEN_ALREADY_LOCKED,   "SCREEN_ALREADY_LOCKED",
ERROR_HWNDS_HAVE_DIFF_PARENT,  "HWNDS_HAVE_DIFF_PARENT",
ERROR_NOT_CHILD_WINDOW,        "NOT_CHILD_WINDOW",
ERROR_INVALID_GW_COMMAND,      "INVALID_GW_COMMAND",
ERROR_INVALID_THREAD_ID,       "INVALID_THREAD_ID",
ERROR_NON_MDICHILD_WINDOW,     "NON_MDICHILD_WINDOW",
ERROR_POPUP_ALREADY_ACTIVE,    "POPUP_ALREADY_ACTIVE",
ERROR_NO_SCROLLBARS,   "NO_SCROLLBARS",
ERROR_INVALID_SCROLLBAR_RANGE, "INVALID_SCROLLBAR_RANGE",
ERROR_INVALID_SHOWWIN_COMMAND, "INVALID_SHOWWIN_COMMAND",
ERROR_EVENTLOG_FILE_CORRUPT,   "EVENTLOG_FILE_CORRUPT",
ERROR_EVENTLOG_CANT_START,     "EVENTLOG_CANT_START",
ERROR_LOG_FILE_FULL,   "LOG_FILE_FULL",
ERROR_EVENTLOG_FILE_CHANGED,   "EVENTLOG_FILE_CHANGED",
ERROR_INVALID_USER_BUFFER,     "INVALID_USER_BUFFER",
ERROR_UNRECOGNIZED_MEDIA,      "UNRECOGNIZED_MEDIA",
ERROR_NO_TRUST_LSA_SECRET,     "NO_TRUST_LSA_SECRET",
ERROR_NO_TRUST_SAM_ACCOUNT,    "NO_TRUST_SAM_ACCOUNT",
ERROR_TRUSTED_DOMAIN_FAILURE,  "TRUSTED_DOMAIN_FAILURE",
ERROR_TRUSTED_RELATIONSHIP_FAILURE,    "TRUSTED_RELATIONSHIP_FAILURE",
ERROR_TRUST_FAILURE,   "TRUST_FAILURE",
ERROR_NETLOGON_NOT_STARTED,    "NETLOGON_NOT_STARTED",
ERROR_ACCOUNT_EXPIRED, "ACCOUNT_EXPIRED",
ERROR_REDIRECTOR_HAS_OPEN_HANDLES,     "REDIRECTOR_HAS_OPEN_HANDLES",
ERROR_PRINTER_DRIVER_ALREADY_INSTALLED,        "PRINTER_DRIVER_ALREADY_INSTALLED",
ERROR_UNKNOWN_PORT,    "UNKNOWN_PORT",
ERROR_UNKNOWN_PRINTER_DRIVER,  "UNKNOWN_PRINTER_DRIVER",
ERROR_UNKNOWN_PRINTPROCESSOR,  "UNKNOWN_PRINTPROCESSOR",
ERROR_INVALID_SEPARATOR_FILE,  "INVALID_SEPARATOR_FILE",
ERROR_INVALID_PRIORITY,        "INVALID_PRIORITY",
ERROR_INVALID_PRINTER_NAME,    "INVALID_PRINTER_NAME",
ERROR_PRINTER_ALREADY_EXISTS,  "PRINTER_ALREADY_EXISTS",
ERROR_INVALID_PRINTER_COMMAND, "INVALID_PRINTER_COMMAND",
ERROR_INVALID_DATATYPE,        "INVALID_DATATYPE",
ERROR_INVALID_ENVIRONMENT,     "INVALID_ENVIRONMENT",
ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT,       "NOLOGON_INTERDOMAIN_TRUST_ACCOUNT",
ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT,       "NOLOGON_WORKSTATION_TRUST_ACCOUNT",
ERROR_NOLOGON_SERVER_TRUST_ACCOUNT,    "NOLOGON_SERVER_TRUST_ACCOUNT",
ERROR_DOMAIN_TRUST_INCONSISTENT,       "DOMAIN_TRUST_INCONSISTENT",
ERROR_SERVER_HAS_OPEN_HANDLES, "SERVER_HAS_OPEN_HANDLES",
ERROR_RESOURCE_DATA_NOT_FOUND, "RESOURCE_DATA_NOT_FOUND",
ERROR_RESOURCE_TYPE_NOT_FOUND, "RESOURCE_TYPE_NOT_FOUND",
ERROR_RESOURCE_NAME_NOT_FOUND, "RESOURCE_NAME_NOT_FOUND",
ERROR_RESOURCE_LANG_NOT_FOUND, "RESOURCE_LANG_NOT_FOUND",
ERROR_NOT_ENOUGH_QUOTA,        "NOT_ENOUGH_QUOTA",
ERROR_INVALID_TIME,    "INVALID_TIME",
ERROR_INVALID_FORM_NAME,       "INVALID_FORM_NAME",
ERROR_INVALID_FORM_SIZE,       "INVALID_FORM_SIZE",
ERROR_ALREADY_WAITING, "ALREADY_WAITING",
ERROR_PRINTER_DELETED, "PRINTER_DELETED",
ERROR_INVALID_PRINTER_STATE,   "INVALID_PRINTER_STATE",
ERROR_PASSWORD_MUST_CHANGE,    "PASSWORD_MUST_CHANGE",
ERROR_DOMAIN_CONTROLLER_NOT_FOUND,     "DOMAIN_CONTROLLER_NOT_FOUND",
ERROR_ACCOUNT_LOCKED_OUT,      "ACCOUNT_LOCKED_OUT",
ERROR_INVALID_PIXEL_FORMAT,    "INVALID_PIXEL_FORMAT",
ERROR_BAD_DRIVER,      "BAD_DRIVER",
ERROR_INVALID_WINDOW_STYLE,    "INVALID_WINDOW_STYLE",
ERROR_METAFILE_NOT_SUPPORTED,  "METAFILE_NOT_SUPPORTED",
ERROR_TRANSFORM_NOT_SUPPORTED, "TRANSFORM_NOT_SUPPORTED",
ERROR_CLIPPING_NOT_SUPPORTED,  "CLIPPING_NOT_SUPPORTED",
ERROR_UNKNOWN_PRINT_MONITOR,   "UNKNOWN_PRINT_MONITOR",
ERROR_PRINTER_DRIVER_IN_USE,   "PRINTER_DRIVER_IN_USE",
ERROR_SPOOL_FILE_NOT_FOUND,    "SPOOL_FILE_NOT_FOUND",
ERROR_SPL_NO_STARTDOC, "SPL_NO_STARTDOC",
ERROR_SPL_NO_ADDJOB,   "SPL_NO_ADDJOB",
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED,       "PRINT_PROCESSOR_ALREADY_INSTALLED",
ERROR_PRINT_MONITOR_ALREADY_INSTALLED, "PRINT_MONITOR_ALREADY_INSTALLED",
ERROR_WINS_INTERNAL,   "WINS_INTERNAL",
ERROR_CAN_NOT_DEL_LOCAL_WINS,  "CAN_NOT_DEL_LOCAL_WINS",
ERROR_STATIC_INIT,     "STATIC_INIT",
ERROR_INC_BACKUP,      "INC_BACKUP",
ERROR_FULL_BACKUP,     "FULL_BACKUP",
ERROR_REC_NON_EXISTENT,        "REC_NON_EXISTENT",
ERROR_RPL_NOT_ALLOWED, "RPL_NOT_ALLOWED"
};

struct OS2_ErrMsg  OS2_StdErrMessages[]=
{
NO_ERROR,  "Errno is 0",
EDOM,      "Domain error",
ERANGE,    "Range error",
EBADMODE,  "The file mode parameter is not correct",
EBADNAME,  "The file name is \"\", a null pointer, or an invalid DDNAME",
EISTEMPMEM, "Temporary memory files cannot be reopened",
EBADSHARE,  "The file sharing mode specified is not correct",
EBUFMODE,   "The buffering mode specified is not correct",
EERRSET,   "A previous error has occurred on the stream",
EISOPEN,   "The file is open",
ENOTEXIST, "The file cannot be found",
ENOTINIT,   "This operation must be done before any reads, writes, or repositions",
ENULLFCB,   "The stream pointer is NULL",
EOUTOFMEM,  "There is not enough memory available to complete the operation",
ESMALLBF,   "The specified buffer size is too small",
//15,       "There is no message for this message number (EDC5015)",
EEXIST,   "The file already exists",
ENOGEN,   "A unique file name could not be generated" ,
18,       "There is no message for this message number (EDC5018)",
ENOSEEK,  "The seek operation is not valid for this stream",
EBADPOS,  "The file position for the file is not valid",
//21,       "There is no message for this message number (EDC5021)" ,
EBADSEEK, "Attempted to seek to an invalid file position"  ,
ENOENT,   "The file or directory specified cannot be found",
EACCESS,  "The file or directory specified is read-only",
EMFILE,    "Too many open files",
ENOCMD,    "A command processor could not be found",
//27,        "There is no message for this message number (EDC5027)",
EGETANDPUT,"A read operation cannot immediately follow a write operation",
EPASTEOF,  "Attempted to read past end-of-file",
ENOTREAD,  "The file is not open for reading",
ETOOMANYUNGETC, "Too many consecutive calls to ungetc",
EUNGETEOF,  "Cannot put EOF back to the stream",
EPUTUNGET,  "Cannot put a character back to the stream immediately following a write operation on the stream",
ECHILD,     "The process identifier specified for the child process is not valid",
EINTR,      "The child process ended abnormally",
EINVAL,     "The action code specified is not correct"  ,
ENOEXEC,    "Cannot run the specified file",
EAGAIN,     "Cannot start another process",
EBADTYPE,   "The stream specified is the wrong type for the operation",
ENOTWRITE,  "The file is not opened for writing",
EPUTANDGET, "A write operation must not immediately follow a read operation" ,
ELARGEBF,   "The specified buffer length is too large",
EBADF,      "The file handle is not valid",
EXDEV,      "Cannot rename a file to a different device",
ENOSPC,     "There is no space left on the device",
EMATH,      "An unrecognized exception occurred in a math routine. The control word has probably been changed",
EMODNAME,   "The DLL specified cannot be found"  ,
//48,         "There is no message for this message number (EDC5048)",
EMAXATTR,   "The value specified for blksize or lrecl is too large",
EREADERROR, "Error in reading the C Locale Description (CLD) file",
EBADATTR,   "The value specified for blksize or lrecl conflicts with a previously set value",
//EILSEQ,
//E2BIG ,
EOS2ERR,     "OS/2 error"

};
/* */

#endif //OS2_ERR_CODES_H
