/*  Tagline Exit Script for PMMail - Copyright 1996, Stephen Berg and IceBerg  */
/*                                   Software Productions.                     */

Parse Arg targetfile
'@echo off'

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/*  Now for the TagLine stuff                                    */

/*  First we load up the VRexx utilities so we can create and manipulate the   */
/*  The pretty windows!!  =:-)                                                 */
call RxFuncAdd 'Vinit', 'VREXX', 'VINIT'
initcode = VInit()
	if initcode = 'ERROR' then SIGNAL CLEANUP
	signal on failure name CLEANUP
	signal on halt name CLEANUP
	signal on syntax name CLEANUP

Call Start

/*  Now we create a small dialog to let the user pick how he/she wants the     */
/*  tagline for the current message to be chosen.                              */
Start:

pick.0 = 5
pick.1 = 'Let PMTagLine randomly pick a TagLine.'
pick.2 = 'Pick one from the file specifically.'
pick.3 = 'Input your own TagLine manually.'
pick.4 = 'Search for text in a tagline, then pick'
pick.5 = 'Bypass the TagLine insertion.'
Call VRadioBox 'PMTagLine V 1.10', pick, 1
choice = pick.vstring

/*  Take action according to the user's choice.                                */
SELECT
WHEN choice = pick.1 THEN
	Call PickRandom
WHEN choice = pick.2 THEN
	Call PickOne
WHEN choice = pick.3 THEN
	CALL Insert
WHEN choice = pick.4 THEN
	CALL SearchPick
WHEN choice = pick.5 THEN
	CALL QuitIt
OTHERWISE 
	Call QuitIt
end

/*  Make sure that the message is closed before we exit.                       */
	rc = LineOut(targetfile)
Return

/*  Kill any remaining VREXX stuff.                                            */
CLEANUP:
	Say 'PMTagLine interrupted!!'
	Call QuitIt
return

/*  For randomly picking taglines                                              */
PickRandom:
	Call GetTagArray
	pick = RANDOM(1, tagline.0)
	tag = tagline.pick
	rc = LineOut(targetfile, 'PMTagLine v1.1 - Copyright, 1996, Stephen Berg')
	rc = LineOut(targetfile, '...' tag)
	rc = LineOut(targetfile)
	Call QuitIt
return

/*  To let the user specifically pick one tagline from the taglines.txt       */
/*  file                                                                      */
PickOne:
	Call GetTagArray
	Call VListBox 'Pick a tagline', tagline, 60, 10, 1
	tag = tagline.vstring
	rc = LineOut(targetfile, 'PMTagLine v1.1 - Copyright, 1996, Stephen Berg')
	rc = LineOut(targetfile, '...' tag)
	rc = LineOut(targetfile)
	Call QuitIt
return

/*  To let the user insert their own tagline                                   */
Insert:
	msg.0 = 3
	msg.1 = 'Please input your own tagline'
	msg.2 = 'in the window below.'
	msg.3 = ''
	msg.vstring = 'Insert witty remark here'
	Call VInputBox 'PMTagLine V 0.10', msg, 60, 1
	tag = msg.vstring
	rc = LineOut(targetfile, 'PMTagLine v1.1 - Copyright, 1996, Stephen Berg')
	rc = LineOut(targetfile, '...' tag)
	rc = LineOut(targetfile)
	Call QuitIt
return

/*  Search for a particular string, load it into an array to allow the         */
/*  User to pick from them.                                                    */
SearchPick:
	msg.0 = 3
	msg.1 = 'Input the string to search for:'
	msg.2 = 'Click OK to continue'
	msg.3 = ''
	CALL VInputBox 'PM TagLine V1.1', msg, 60, 1
	text = msg.vstring
	CALL LoadUtils
	rc = SysFileSearch(text, 'tagline.txt', tagline)
	Call VListBox 'Pick a tagline', tagline, 60, 10, 1
	tag = tagline.vstring
	if tag = "TAGLINE.VSTRING" then do
		msg.0 = 3
		msg.1 = "The string you searched for was not found in the tagline"
		msg.2 = "file.  Please try again"
		msg.3 = ""
		Call VMsgBox "Error on Search", msg, 1
		Call Start
	end
	else do
		rc = LineOut(targetfile, 'PMTagLine v1.1 - Copyright, 1996, Stephen Berg')
		rc = LineOut(targetfile, '...' tag)
		rc = LineOut(targetfile)
	end
	Call QuitIt
exit

		
/*  Load the tagline file into an array for either picking or random choice.   */
GetTagArray:
	cnt = 0
	do While Lines('tagline.txt') > 0
		cnt = cnt + 1
		tagline.0 = cnt
		tagline.cnt = LineIn('tagline.txt')
	end
return

/* Inform the user that the search found no taglines and then restart the   */
/* Search routine                                                           */


/* Load the REXXUtil functions                                                 */
LoadUtils:
CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
CALL SysLoadFuncs
Return

/* Close up and shut down   */
/*  Or for no tagline functions to the current message.                           */

QuitIt:
	Call VExit
exit


