/*---------------------------------------------------------------------+
( Exec to load in the current INEWS items                              )
+----------------------------------------------------------------------+
( Written By: Ken Taylor                                               )
(             InnoVal Systems Solutions                                )
(                                                                      )
( (c) 1995, InnoVal Systems Solutions Inc.  All rights reserved.       )
+---------------------------------------------------------------------*/

 Signal On Syntax

 NUMERIC DIGITS 22

'VMPUSH SET'
'CP SET  MSG OFF'
'CP SET IMSG OFF'
'CP SET EMSG OFF'

'SET CMSTYPE RT'
'VMFCLEAR'
 Say '** Post INEWS VM 1.0   ** 'userid()

 if INIT_EXEC() = 0 then do
   Do Forever
    'DESBUF'

     pull cmd

     Select
       When word(cmd,1) = 'POLLITEMS' then do
        'SET CMSTYPE RT'
        '** POSTINEWS POLLING SYSTEM FOR NEW NEWS ITEMS **'

        'GLOBALV SELECT POSTINEWS GET LAST_DATE'
         if datatype(last_date) = 'NUM' then
           item.LAST_PULL_DATE = last_date

         Select
           When word(cmd,2) = 'DATE' then do
             Parse Value word(cmd,3) With mm'/'dd'/'yy .
             yy = yy + 1900
             if yy < 50 then yy = yy + 100
             item.LAST_PULL_DATE = yy''mm''dd'000000'

             Parse Value word(cmd,4) With mm'/'dd'/'yy .
             yy = yy + 1900
             if yy < 50 then yy = yy + 100
             item.END_PULL_DATE = yy''mm''dd'999999'
             if word(cmd,5) = 'TEMPFILE' then do
               tempfile = '$$TMP$$ CAT A'
              'EXECIO * DISKR 'tempfile' (STEM LINE. FINIS'
               if RC = 0 & line.0 > 0 then do i = 0 to line.0
                 item.NEWSCAT.i = strip(line.i)
               end
               Address 'COMMAND' 'ERASE 'tempfile
             end
             else do
               do i = 1 to words(cmd) - 4
                 item.NEWSCAT.i = word(cmd,i+4)
               end
               item.NEWSCAT.0 = words(cmd) - 4
             end
           end
           When word(cmd,2) = 'TODAY' then
             item.LAST_PULL_DATE = date('SORTED')'000000'
           When word(cmd,2) = 'MONTH' then do
             Parse Value date('SORTED') With 1 yy 5 mm 7 dd
             item.LAST_PULL_DATE = yy''mm'00000000'
           end
           When word(cmd,2) = 'YEAR'  then do
             Parse Value date('SORTED') With 1 yy 5 mm 7 dd
             item.LAST_PULL_DATE = yy'0000000000'
           end
           When word(cmd,2) = 'ALL'   then
             item.LAST_PULL_DATE = 0
           Otherwise nop
         end

         Call POLL_FOR_ITEMS

         Parse Value time() With hh':'mn':'ss
         ldate = date('SORTED')''hh''mn''ss
        'GLOBALV SELECT POSTINEWS SETLP LAST_DATE 'ldate


        'SET CMSTYPE RT'
        'ESTATE POSTINWS NEWITEMS A'
         If RC = 0 then Say '** POSTINEWS NEW ITEMS FOUND **'
         else           Say '** POSTINEWS NEW ITEMS NONE **'
       end
       When word(cmd,1) = 'POLLLIST' then do
        'SET CMSTYPE RT'
        '** POSTINEWS PULLING LIST OF SUBSCRIPTIONS **'

         Call POLL_FOR_CATS

        'SET CMSTYPE RT'
        'ESTATE POSTINWS NEWSCATS A'
         If RC = 0 then Say '** POSTINEWS CATEGORIES FOUND **'
         else           Say '** POSTINEWS CATEGORIES NONE **'
       end
       When cmd = ''         then LEAVE
       When cmd = 'POSTQUIT' then LEAVE
       Otherwise do
         Address 'CMS' cmd
        'VMFCLEAR'
       end
     end /* select */
   end /* do...forever */
 end /* if */

/*---------------------------------------------------------------------+
( Exit the exec.  One way in...One way out.                            )
+---------------------------------------------------------------------*/
QUIT:
 do i = 1 to item.INEWSDISK.0
   Parse Var item.INEWSDISK.i addr fm .
  'RELEASE 'fm
  'EXECIO 0 CP(STRING DETACH 'addr
 end /* do...i */

'ESTATE POSTINWS NEWITEMS A'
 If RC = 0 then Address 'COMMAND' 'ERASE POSTINWS NEWITEMS A'
'ESTATE POSTINWS NEWSCATS A'
 If RC = 0 then Address 'COMMAND' 'ERASE POSTINWS NEWSCATS A'

'VMPOP SET'
'VMFCLEAR'
 EXIT(0)

/*---------------------------------------------------------------------+
( Display any syntax errors on the screen                              )
+---------------------------------------------------------------------*/
SYNTAX:
  ret = RC
 'SET CMSTYPE RT'
  Say 'Error' ret 'in line' sigl ':' errortext(ret)
/*  Say sigl':'sourceline(sigl) */
  pull .
  Signal QUIT
  RETURN(0)


/*--------------------------------------------------------------------*/
/* Initialize the program variables                                   */
/*--------------------------------------------------------------------*/
INIT_EXEC:Procedure Expose item.
 ret_code = 0
 item.    = 0
 node     = NODE()

 newsfile = 'NT$$TABL 'node' *'

'ESTATE 'newsfile
 If rc <> 0 then newsfile = 'NT$$TABL LOC_NODE *'

'EXECIO * DISKR 'newsfile' (STEM LINE. FINIS'
 If RC = 0 then do i = 1 to line.0
   Parse Var line.i term value
   item.term = value

   if term = 'INEWSDISK' then do
     Parse Var value id disk .
     /*---------------------------*/
     /* Link up to the INEWs disk */
     /*---------------------------*/
    'DESBUF'
    'GETFMADR'
     pull . fm addr .
    'EXECIO 0 CP (STRING LINK 'id disk addr' RR'
     If RC = 0 then do
      'ACCESS 'addr fm
       item.term.0   = item.term.0 + 1
       tot           = item.term.0
       item.term.tot = addr fm
     end
     else do
       ret_code = RC
      'SET CMSTYPE RT'
       Say '** POSTINEWS ERROR LINKING TO INEWS DISK 'id disk' **'
     end
   end
 end
 else do
   ret_code = 0
  'SET CMSTYPE RT'
   Say '** POSTINEWS ERROR LOCATING LOCAL INEWS TABLE **'
 end

 if ret_code = 0 then do
   /*----------------------------------------------------------*/
   /* read the INEWS catagories that the user is subscribed to */
   /*----------------------------------------------------------*/
   newsfile = '$$NT$$ USERDATA A0'
  'EXECIO * DISKR 'newsfile' (STEM LINE. FINIS'
   If RC = 0 then do i = 1 to line.0
     Parse Var line.i cat . .
     item.NEWSCAT.0 = item.NEWSCAT.0 + 1
     tot            = item.NEWSCAT.0
     item.NEWSCAT.tot = cat
   end

   if item.NEWSCAT.0 = 0 then do
     ret_code = 3
    'SET CMSTYPE RT'
     Say '** POSTINEWS ERROR NO SUBSCRIBED NEWS',
         'CATAGORIES WERE FOUND **'
   end
 end
 RETURN(ret_code)

/*--------------------------------------------------------------------*/
/* Return the current VM node                                         */
/*--------------------------------------------------------------------*/
NODE:Procedure
'ID (LIFO'
 pull . . node .
 RETURN(node)

/*--------------------------------------------------------------------*/
/* Check the system for new news items                                */
/*--------------------------------------------------------------------*/
POLL_FOR_ITEMS:Procedure Expose item.

 file = 'POSTINWS NEWITEMS A'
 node = left(NODE(),8)

'ESTATE 'file
 If RC = 0 then Address 'COMMAND' 'ERASE 'file

 cnt      = 0
 ret_code = 0
 do i = 1 to item.INEWSDISK.0
   fm = word(item.INEWSDISK.i,2)
   do j = 1 to item.NEWSCAT.0
     cat = item.NEWSCAT.j

    'DESBUF'
    'LISTFILE * 'cat fm' (STACK DATE'
     If RC = 0 then do queued()
       Pull fn ft fm . . . . date time .

       date = right(date,8,'0')
       time = right(time,8,'0')

       Parse Var date mm'/'dd'/'yy
       Parse Var time hh':'mn':'ss

       if yy < 50 then yy = '20'yy
       else            yy = '19'yy
       timestamp = yy''mm''dd''hh''mn''ss

       go = 0
       if timestamp > item.LAST_PULL_DATE then do
         if item.END_PULL_DATE <> 0 then do
           if timestamp < item.END_PULL_DATE then go = 1
         end
         else go = 1
       end


       if go = 1 then do
         cnt = cnt + 1
         if cnt = 1 then do
           line = 'DATE: 'date('USA') time()
          'EXECIO 1 DISKW 'file' (VAR LINE FINIS'
          'EXECIO * DISKR $$NT$$ USERDATA A (STEM REC. FINIS'
           If RC = 0 then do k = 1 to rec.0
             line = 'CAT: 'word(rec.k,1)
            'EXECIO 1 DISKW 'file' (VAR LINE FINIS'
           end /* do i */
         end

         line = left(fn,8) left(ft,8) left(fm,3) node right(date,8,'0'),
                right(time,8,'0')
        'EXECIO 1 DISKW 'file' (VAR LINE FINIS'
         If RC <> 0 then do
           ret_code = 0
          'SET CMSTYPE RT'
           Say '** POSTINEWS ERROR WRITING NEW ITEMS FILE **'
           Say '** A-DISK MAY BE FULL **'
         end
       end /* if */
     end /* do queued */
     if ret_code <> 0 then LEAVE
   end /* do...j */
   if ret_code <> 0 then LEAVE
 end /* do...i */

 RETURN

/*--------------------------------------------------------------------*/
/* Pull the list of INEWS categories                                  */
/*--------------------------------------------------------------------*/
POLL_FOR_CATS:Procedure Expose item.
 ofile = 'POSTINWS NEWSCATS A'

'ESTATE 'ofile
 If RC = 0 then Address 'COMMAND' 'ERASE 'ofile

 line. = ''
 count = 0
 do i = 1 to item.NEWSCAT.0
   count      = count + 1
   line.count = item.NEWSCAT.i
 end
 line.0 = count
'EXECIO 'count' DISKW 'ofile' (STEM LINE. FINIS'
 RETURN
