/*********************************************************************/
/* DMI IRC REXX Command Script for REXX Clients.  v1.25   26 Sep 96  */
/*********************************************************************/
/* Inbound Functions                                      26 Sep 96  */
/*********************************************************************/

Parse Upper Arg WinHandle OurNick Prefix Cmd Chan Nick Rest More
Parse Arg xWinHandle xOurNick xPrefix xCmd xChan xNick xRest
Parse Arg zWinHandle zOurNick zPrefix zCmd zChan zNick zRest zWall zWall1
Parse Arg AllArgs

Pool = 'OS2ENVIRONMENT'
CMDHandle = Value('CMDHandle',, Pool)
DataDir = Value('DataDir',, Pool)
IF ((Right(DataDir, 1) \= '\') & (DataDir \= '')) then
   Value('DataDir', DataDir'\', Pool)
DMIMsg = '*DMI*'
ErrStr = '*[Error]*'
Version = '1.25'

SIGNAL ON SYNTAX;
/* LineOut('C:\IRC-In.Txt', AllArgs); LineOut('C:\IRC-In.Txt')*/ /* For debugging */

if (Cmd == 'PRIVMSG') then do
   Call GetNickId
   Select
      When (Chan == OurNick) then do   /* These are messages to us, otherwise they're to the chan */
         Select
            When (Nick == ':CLIENTINFO') then do
               IrcRexxSend('NOTICE' FromNick ':CLIENTINFO CLIENTINFO DCC ECHO FINGER PAGE PING SOUND SOURCE TIME USERINFO VERSION XDCC', WinHandle)
               Return ''
            end
            When ((Nick = ':DCC') | (Nick = ':DCC')) then do
               IF (Rest \= 'SEND') & (Rest \= 'CHAT') then do
                  Call GetNickId       /* Eat CTCP DCC to get around GTIRC bug                  */
                  IrcRexxDisplay(DMIMsg ''FromNick' has just attempted to crash GTirc! Auto-Ignoring.', WinHandle);
                  IrcRexxCommand('/IGNORE' FromNick 'CTCP', WinHandle);
                  Return ''
               end
               else
                  Return 'OK'
            end
            When (Nick == ':SOURCE') then do
               IrcRexxSend('NOTICE' FromNick ':SOURCE For GammaTech IRC, call SofTouch Systems (405) 947-8085.', WinHandle)
               IrcRexxSend('NOTICE' FromNick ':SOURCE For DMI, look for Deek on EFnet.', WinHandle)
               Return ''
            end
            When (Nick = ':VERSION') then do
               IrcRexxSend('NOTICE' FromNick ':VERSION DMI '|| Version ||', Copyright (C) 1996 Dusk To Dawn Computing', WinHandle)
               Return 'OK'
            end
            When ((Nick = ':PAGE') | (Nick = ':PAGE')) then do
               Paging = Value('Paging',, Pool)
               if (Paging == 'ON' | Paging == 'BEEPS') then do
                  note.0 = 8
                  note.1 = 220                  /* Play a series of musical notes */
                  note.2 = 330
                  note.3 = 440
                  note.4 = 550
                  note.5 = 660
                  note.6 = 770
                  note.7 = 880
                  note.8 = 990
                  do i=1 to note.0
                     Beep(note.i, 50)
                  end
               end
               if (Paging == 'WAVE') then call play 'File='Value('PageWave',, Pool)
               if (Nick = ':PAGE') then
                  IrcRexxDisplay('*** CTCP PAGE ('FromNick'):' Strip(xRest, 'T', ''), WinHandle)
               else
                  IrcRexxDisplay('*** CTCP PAGE ('FromNick')', WinHandle)
               Return ''
            end
            When ((Nick == ':XDCC') | (Nick == ':XDCC')) then do
               TempVar = XDCC_In(AllArgs)
               Return TempVar
            end
            Otherwise do
               If (Value('MsgLog',, Pool) == 'ON') then do /* MSG Logger */
                  MessageLog = DataDir || 'Messages.Log'
                  Flag = Pos('', xNick)
                  if (Flag == 0) then do
                     xNick = Strip(xNick,L,':')
                     Message = xNick xRest
                     LogText = FromNick FromID Date('N') Time('C') Message
                     LineOut(MessageLog, LogText)
                     LineOut(MessageLog)
                  end
               end
               Return 'OK'
            end
         end
      end
      Otherwise Return 'OK'
   end
end

if (Cmd = 'JOIN') then do
   Call GetNickId
   If Value('AutoLog',, Pool) = 'ON' then do /* Begin a log file when we join a channel */
      if IrcRexxWildcard(':'OurNick'!*@*', Prefix) = 'MATCH' then do
         IrcRexxCommand('/LOG ON', WinHandle);
      end
   end
   If Value('AutoMode',, Pool) = 'ON' then do /* Automatically change mode */
      AutoList = DataDir||'AutoMode.Lst'
      do while Lines(AutoList)
         userline = LineIn(AutoList)
         Parse Upper Var userline Action UsrMask Channel dummy
         Parse Var Userline xAction xUsrMask xChannel Comment
         Chan = Strip(Chan, 'L', ':')
         If (IrcRexxWildCard(':'UsrMask, Prefix) = 'MATCH') & (IrcRexxWildCard(Channel, Chan) = 'MATCH') then do
            Select
               When Action = 'V' then IrcRexxSend('MODE' Chan '+v' FromNick, WinHandle)
               When Action = 'O' then IrcRexxSend('MODE' Chan '+o' FromNick, WinHandle)
               When Action = 'B' then do
                  IrcRexxSend('MODE' Chan '-o+b' FromNick xUsrMask, WinHandle)
                  if Comment = '' then
                     BKMsg = Value('BKMsg',, Pool)
                  else
                     BKMsg = Comment
                  IrcRexxSend('KICK' Chan FromNick ':'BKMsg, WinHandle)
               end
               Otherwise NOP
            end
         end
      end
      LineOut(AutoList)
   end
   Return 'OK'
end

/*********************************************************************/
/* We see if this is a kick message for us. If so we format and      */
/* display a message in the window and rejoin the channel.           */
/*********************************************************************/

if (Cmd = 'KICK' & Nick = OurNick) then do
   Call GetNickId
   xRest = SubStr(xRest, 2)
   IrcRexxDisplay(DMIMsg 'Kicked by' FromNick '(' || xRest || ')',WinHandle)
   IrcRexxSend('JOIN' xChan, WinHandle)
   Return ''
End

if (Cmd = '301') then do
   Select
      When (Value('GetInfo',, Pool) = 'ON') then do
         IrcRexxDisplay('Away    : 'Strip(xRest, 'L', ':')'', CmdHandle)
         Return ''
      end
      When (Value('GetIdle',, Pool) = 'ON') then Return ''
      When (Value('GetIdle2',, Pool) = 'ON') then Return ''
      Otherwise Return 'OK'
   end
end

if (Cmd = '311') then do
   Select
      When (Value('GetInfo',, Pool) = 'ON') then do
         TempStr1 = 'User Information for: ' || zNick || ''
         TempLen = Length('User Information for: ' || zNick)
         Parse var zWall1 Dummy zWall1
         IrcRexxDisplay('User Information for: 'zNick'', CmdHandle)
         IrcRexxDisplay(Copies('~', TempLen), CmdHandle)
         IrcRexxDisplay('IRC Name: 'Strip(zWall1, 'L', ':')'', CmdHandle)
         IrcRexxDisplay('Address : 'zRest'@'zWall'', CmdHandle)
         Return ''
      end
      When (Value('GetIdle',, Pool) = 'ON') then Return ''
      When (Value('GetIdle2',, Pool) = 'ON') then Return ''
      Otherwise Return 'OK'
   end
end

if (Cmd = '312') then do
   Select
      When (Value('GetInfo',, Pool) = 'ON') then do
         IrcRexxDisplay('Server  : 'zRest' ('Strip(zWall, 'L', ':') zWall1')', CmdHandle)
         Return ''
      end
      When (Value('GetIdle',, Pool) = 'ON') then do
         Parse var xRest IdleServer dummy
         IrcRexxSend('WHOIS' IdleServer Value('IdleNick',, Pool), WinHandle)
         Value('GetIdle2', 'ON', Pool)
         Return ''
      end
      When (Value('GetIdle2',, Pool) = 'ON') then Return ''
      Otherwise Return 'OK'
   end
end

if (Cmd = '313') then do
   Select
      When (Value('GetInfo',, Pool) = 'ON') then do
         IrcRexxDisplay('Info    : 'zNick' is an IRCop!', CmdHandle)
         Return ''
      end
      When (Value('GetIdle',, Pool) = 'ON') then Return ''
      When (Value('GetIdle2',, Pool) = 'ON') then Return ''
      Otherwise Return 'OK'
   end
end

if (Cmd = '317') then do
   Select
      When (Value('GetInfo',, Pool) = 'ON') then do
         IrcRexxDisplay('Idle    : 'zRest' Seconds', CmdHandle)
         Return ''
      end
      When (Value('GetIdle',, Pool) = 'ON') then Return ''
      When (Value('GetIdle2',, Pool) = 'ON') then do
         IrcRexxDisplay(''Value('IdleNick',, Pool)' has been idle for 'zRest' seconds.', CmdHandle)
         Return ''
      end
      Otherwise Return 'OK'
   end
end

if (Cmd = '318') then do
   Select
      When (Value('GetInfo',, Pool) = 'ON') then do
         Value('GetInfo', 'OFF', Pool)          /* Turn off GetInfo */
         Return ''
      end
      When (Value('GetIdle',, Pool) = 'ON') then do
         Value('GetIdle', 'OFF', Pool)
         Return ''
      end
      When (Value('GetIdle2',, Pool) = 'ON') then do
         Value('GetIdle2', 'OFF', Pool)
         Return ''
      end
      Otherwise Return 'OK'
   end
end

if (Cmd = '319') then do
   Select
      When (Value('GetInfo',, Pool) = 'ON') then do
         IrcRexxDisplay('Channels: 'Strip(zRest, 'L', ':') zWall zWall1'', CmdHandle)
         Return ''
      end
      When (Value('GetIdle',, Pool) = 'ON') then Return ''
      When (Value('GetIdle2',, Pool) = 'ON') then Return ''
      Otherwise Return 'OK'
   end
end

if (Cmd = '321' & Value('CSTATING',,Pool) = 'ON') then do
   Junk = xRest                        /* Eat "Channel Created" timestamp */
   Return ''
end

if (Cmd = '322' & Value('CSTATING',,Pool) = 'ON') then do
   Parse Var xRest NickTotal Topic
   Topic = Strip(Topic, L, ':')
   if (topic = '') then do
      IrcRexxDisplay('*' Center('' nicktotal 'Total people',58) '*', CmdHandle)
      IrcRexxDisplay('*' Center('Topic for' xNick 'is:',58) '*', CmdHandle)
      IrcRexxDisplay('*' Center(' No topic has been set!',58) '*', CmdHandle)
      IrcRexxDisplay(Copies('*', 60), CmdHandle)
   end
   else do
      if (Length(topic) > 56) then do
         wordcount = Words(topic)
         halfcount = wordcount % 2
         firsthalf = SubWord(topic, 1, halfcount)
         secondhalf = Subword(topic, halfcount + 1)
         firsthalf = Strip(firsthalf, B)
         secondhalf = Strip(secondhalf, B)
         IrcRexxDisplay('*' Center('' nicktotal 'Total people',58) '*', CmdHandle)
         IrcRexxDisplay('*' Center('Topic for' xNick 'is:',58) '*', CmdHandle)
         IrcRexxDisplay('*' Center(firsthalf, 56) '*', CmdHandle)
         IrcRexxDisplay('*' Center(secondhalf, 56) '*', CmdHandle)
         IrcRexxDisplay(Copies('*',60), CmdHandle)
      end
      else do
         IrcRexxDisplay('*' Center('' nicktotal 'Total people',58) '*', CmdHandle)
         IrcRexxDisplay('*' Center('Topic for' xNick 'is:',58) '*', CmdHandle)
         IrcRexxDisplay('*' Center(topic,56) '*', CmdHandle)
         IrcRexxDisplay(Copies('*',60), CmdHandle)
      end
   end
   Value('cstating','OFF',Pool)
   Return ''
end

if (Cmd = '324' & Value('CSTATING',,Pool) = 'ON') then do
   modes = xRest
   IrcRexxDisplay('*' Center('Modes for' xNick':' modes, 58) '*', CmdHandle)
   Return ''
end

if (Cmd = '329' & Value('CSTATING',, Pool) = 'ON') then do      /* Suppress Created Time stamp on Undernet */
   Junk = xRest
   Return ''
end

if (Cmd = '353') then do
   Select
      When (Value('CStating',, Pool) = 'ON') then do   /* Handle incoming channel info for display */
         Parse Var xRest channel nicks
         nickcount = Words(nicks)
         opcount = '0'
         marker = Pos('@', nicks)
         if (marker = '0') then do
            opcount = 'No'
         end
         else do
            do until marker = '0'
               marker = Pos('@', nicks, marker + 1)
               opcount = opcount + 1
            end
         end
         IrcRexxDisplay(Copies('*', 60), CmdHandle)
         IrcRexxDisplay('*' Center('Stats for' channel':',58) '*', CmdHandle)
         IrcRexxDisplay('*' Center('' nickcount 'visible People',58) '*', CmdHandle)
         IrcRexxDisplay('*' Center('' opcount 'Channel Operators',58) '*', CmdHandle)
         IrcRexxDisplay(Copies('*',60), CmdHandle)
      end
      When (Value('Walling',, Pool) = 'ON') then do      /* Wall - Get nicks, save 'em, NOTICE 'em. */
         Names. = ''
         Names.0 = 0
         Count = 0
         NickOne = Strip(zWall, 'L', ':')
         NickPool = NickOne zWall1
         do until NickPool = ''
            parse var NickPool tmpWord NickPool
            Count = Count + 1
            Names.Count = tmpWord
            Names.0 = Count
         end
         do Count = 1 to Count
            if (Pos('@', Names.Count) = 1) then do
               Names.Count = Strip(Names.Count, 'L', '@')
            end
         end
         NickStr = Names.1
         do Count = 2 to Count
            NickStr = NickStr || ',' || Names.Count
         end
         TempVar = Value('WallMsg',,Pool)
         Strip(NickStr, 'B', ',')
         NotNick = 'NOTICE' NickStr ':'
         IrcRexxSend(NotNick || TempVar, WinHandle)
         Value('Walling', 'OFF', Pool)
      end
      When (Value('WallOping',,Pool) = 'ON') then do     /* WallOp - Get Ops' nicks, save 'em, NOTICE 'em. */
         Names. = ''
         Names.0 = 0
         Count = 0
         NickOne = Strip(zWall, 'L', ':')
         NickPool = NickOne zWall1
         do until NickPool = ''
            parse var NickPool tmpWord NickPool
            Count = Count + 1
            Names.Count = tmpWord
            Names.0 = Count
         end
         nickstr = ''
         do Count = 1 to Count
            if (Pos("@", Names.Count) = 1) then do
               CleanNick = Strip(Names.Count, L, '@')
               NickStr = NickStr || CleanNick || ','
            end
         end
         TempVar = Value('WallMsg',, Pool)
         Strip(NickStr, 'B', ',')
         NotNick = 'NOTICE' NickStr ':'
         IrcRexxSend(NotNick || TempVar, WinHandle)
         Value('WallOping', 'OFF', Pool)
      end
      Otherwise Return 'OK'
   end
   Return ''
end

if (Cmd == '364') then do
   Select
      When (Value('GetSrvr',, Pool) = 'ON') then do
         TempCount = Value('Cnt',, Pool) + 1
         Value('Cnt', TempCount, Pool)
         Value('Srvrs.'TempCount, xNick, Pool)
      end
      When (Value('GetCurr',,Pool) = 'ON') then do
         TempCount = Value('CurrCnt',, Pool) + 1
         Value('CurrCnt', TempCount, Pool)
         Value('CurrSvrs.'TempCount, xNick, Pool)
      end
      Otherwise Return 'OK'
   end
   Return ''
end

if (Cmd == 365) then do                /* End of server list - stop looking for it */
   Select
      When (Value('GetSrvr',, Pool) = 'ON') then do
         Value('GetSrvr', 'OFF', Pool)
         IrcRexxCommand('/WRITESVR', CmdHandle)
      end
      When (Value('GetCurr',, Pool) = 'ON') then do
         Value('GetCurr','OFF', Pool)
         IrcRexxCommand('/WRITECURRSVR', CmdHandle)
      end
      Otherwise Return 'OK'
   end
   Return ''
end

Return 'OK'                            /* No special message, pass it on to client */

GetNickId:
   Pos1 = Pos('!', xPrefix)
   FromNick = SubStr(xPrefix, 2, Pos1 - 2)
   FromId = SubStr(xPrefix, Pos1 + 1)
Return

SYNTAX:
   IrcRexxDisplay(ErrStr 'REXX Syntax Error' RC '(' || ErrorText(RC) || ') at line' SIGL 'of DMI-Msg.Cmd.', WinHandle);
Return ''

