/*********************************************************************/
/* DMI IRC REXX Command Script for REXX Clients.  v1.25   26 Sep 96  */
/*********************************************************************/
/* AutoMode Functions                                     26 Sep 96  */
/*********************************************************************/

AutoMode:
   Parse Upper Arg WinHandle WinName OurNick Verb Command Action Mask Channel Extra
   Parse Arg xWinHandle xWinName xOurNick xVerb xCommand xAction xMask xChannel xExtra

   Pool = 'OS2ENVIRONMENT'
   CMD = Value('COMSPEC',, Pool)
   ErrStr = '*[Error]*'
   DMIMsg = '*DMI*'
   DataDir = Value('DataDir',, Pool)
   AutoList = DataDir || 'AutoMode.Lst'

   SIGNAL ON SYNTAX
   Select
      When (Command == 'ADD') then do
         Stream(AutoList, 'C', 'SEEK <0') /* Go to End of File */
         LineOut(AutoList, Action xMask xChannel xExtra)
         Select
            When (Action == 'B') then TempAct = 'BanKick'
            When (Action == 'O') then TempAct = 'Op'
            When (Action == 'V') then TempAct = 'Voice'
            Otherwise TempAct = '[UnknownAction]'
         end
         IrcRexxDisplay(DMIMsg 'AutoMode Added: ' || TempAct xMask || ' in channel ' || xChannel || '.', WinHandle)
         IrcRexxDisplay(DMIMsg 'Comments: ' || xExtra || '', WinHandle)
         LineOut(AutoList)
      end
      When (Command == 'DEL') then do
         AutoTemp = 0
         Stream(AutoList, 'C', 'CLOSE')
         do while Lines(AutoList)
            TempLine = LineIn(AutoList)
            Parse upper var TempLine TempAct TempMask dummy
            If (IrcRexxWildCard(Action, TempMask) == 'MATCH') then
               IrcRexxDisplay(DMIMsg 'AutoMode deleted: ' || TempLine, WinHandle)
            else do
               AutoTemp = AutoTemp + 1
               AutoLine.AutoTemp = TempLine
            end
         end
         Stream(AutoList, 'C', 'CLOSE')
         CALL Library
         rc = SysFileDelete(AutoList)
         LineOut(AutoList)
         do temp = 1 to AutoTemp
            LineOut(AutoList, AutoLine.temp)
         end
         LineOut(AutoList)
      end
      When (Command == 'LIST') then do
         IrcRexxDisplay('Current AutoMode List:', WinHandle)
         IrcRexxDisplay('~~~~~~~~~~~~~~~~~~~~~~', WinHandle)
         IrcRexxDisplay('Action   UserMask                  Channel       Comments/Reason', WinHandle)
         IrcRexxDisplay('~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~', WinHandle)
         do while Lines(AutoList)
            TempLine = LineIn(AutoList)
            Parse var TempLine TempAct TempMask TempChan TempExtra
            Select
               When (TempAct == 'B') then TempAct = 'BanKick '
               When (TempAct == 'O') then TempAct = 'Op      '
               When (TempAct == 'V') then TempAct = 'Voice   '
               Otherwise TempAct = 'Unknown '
            end
            IrcRexxDisplay(TempAct Left(TempMask, 25) Left(TempChan, 13) TempExtra, WinHandle)
         end
         LineOut(AutoList)
      end
      Otherwise IrcRexxDisplay(ErrStr 'Usage: /AUTO <Command> <Action> <Mask> <Channel> [Comments/Reason]', WinHandle)
   end
   Return ''

library:
   CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   CALL SysLoadFuncs
Return

SYNTAX:
   IrcRexxDisplay(ErrStr 'REXX Syntax Error' RC '(' || ErrorText(RC) || ') at line' SIGL 'of AutoMode.Cmd.', WinHandle);
Return ''

