/****************************************************************/
/*           Reset the position of the SETUP.EXE windows        */
/*                                                              */
/*      Author:       Peter Moylan (peter@ee.newcastle.edu.au)  */
/*      Started:      21 September 2000                         */
/*      Last revised: 1 April 2019                              */
/*                                                              */
/*  Usage:                                                      */
/*         tools\resetpos                                       */
/*                                                              */
/*      You can use this when one or more of the windows        */
/*      belonging to SETUP.EXE and/or MONITOR.EXE has moved     */
/*      off-screen.  This script will move the windows to       */
/*      the bottom left of the screen.  You can then run        */
/*      the two programs and move the windows to where you      */
/*      really want them.  Note: run the script when SETUP      */
/*      and MONITOR are NOT running - otherwise they will undo  */
/*      your work by saving their present positions when        */
/*      they exit.                                              */
/*                                                              */
/*  Installation:                                               */
/*      Put this file anywhere you like, but run it from the    */
/*           FtpServer main directory                           */
/*                                                              */
/****************************************************************/

CALL RxFuncAdd SysLoadFuncs, rexxutil, sysloadfuncs
CALL SysLoadFuncs
CALL CheckPrerequisites SelectTNI INIget INIput

CALL Reset SETUP
CALL Reset MONITOR

SAY "The window positions have been reset"
SAY "You may now run SETUP.EXE or MONITOR.EXE"

EXIT 0

/****************************************************************/
/*                  RESETTING ONE SET OF WINDOWS                */
/****************************************************************/

Reset:  PROCEDURE

    PARSE arg base

    Nul = D2C(0)
    Null8 = Nul||Nul||Nul||Nul||Nul||Nul||Nul||Nul
    
    IF SelectTNI(base) THEN extension = "TNI"
    ELSE extension = "INI"
    INIfile = base"."extension
    list = INIget( INIfile, 'WindowPos' )
    DO WHILE (list \= '') & (list \= '00'X)
        PARSE VAR list thiswin '00'X list
        CALL INIput INIfile, 'WindowPos', thiswin, Null8
    END
    RETURN

/****************************************************************/
/*                      CHECKING PREREQUISITES                  */
/****************************************************************/

CheckPrerequisites: PROCEDURE

    /* The argument is a space-separated list of prerequisite   */
    /* functions, for example                                   */
    /*      CALL CheckPrerequisites rxu SelectTNI INIget        */
    /* where (at least in this version) each list item is       */
    /* either 'rxu' or a function from my TNItools package.     */
    /* If any is missing then we exit with an error message.    */

    PARSE UPPER ARG funclist
    funclist = STRIP(funclist)
    needrxu = 0
    needtools = 0
    DO WHILE funclist \= ''
        PARSE VAR funclist func funclist
        funclist = STRIP(funclist)
        IF func = 'RXU' THEN DO

            /* Initialise RXU if not already available, fail if */
            /* the RxFuncAdd operation fails.  We must          */
            /* RxFuncQuery RxuTerm because RxuTerm does not     */
            /* deregister RxuInit.  The RxFuncDrop is needed    */
            /* because RxFuncAdd seems to report failure if the */
            /* function is already registered.                  */

            IF RxFuncQuery('RxuTerm') THEN DO
                CALL RxFuncDrop('RxuInit')
                CALL RxFuncAdd 'RxuInit','RXU','RxuInit'
                IF result THEN DO
                    SAY 'Cannot load RXU'
                    needrxu = 1
                END
                ELSE CALL RxuInit
            END
        END
        ELSE DO
            func = func||'.CMD'
            IF SysSearchPath('PATH', func) = '' THEN DO
                SAY 'ERROR: 'func' must be in your PATH'
                needtools = 1
            END
        END
    END
    IF needrxu THEN SAY 'You can find RXU1a.zip at Hobbes'
    IF needtools THEN SAY 'Please install the TNItools package'
    IF needrxu | needtools THEN EXIT 1
    RETURN

/****************************************************************/

