/* Drag and Drop script using get.exe - compliments of Dan Harms
This REXX script will upload multiple files to a server using drag and drop.
To use the script, you must modify the GETSTR = line to include the server
paramters. You must then place a shadow of the script on your desktop or
in a convenient location for drag and drop.

When you drag a file onto the drop.cmd script, it will then build a command line
and pass it to get.exe to upload the file to the server. If you drop multiple files 
on the .cmd icon, the script will process multiple uploads, each within its own
vio window. 

Be sure that get.exe is in a directory in your config.sys path.
*/

parse arg ARGS;
STRING = ARGS;
STRING = space(STRING);
NAMES = FILESPEC("name",STRING);
NAMES = space(NAMES);
/* modify the GETSTR line where,
server_address is the internet ip of the ftp server
server_directory is the directory on the ftp server where you want to upload
server_username is your username for the ftp server
server_password is your password for the ftp server
For example: get -p hobbes.nmsu.edu/pub/incoming/"NAMES" "STRING" anonymous anonymous@anonymous.com
*/
GETSTR = "get -p server_address/server_directory/"NAMES" "STRING" server_username server_password";
say GETSTR
GETSTR
exit;
